/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.rcp;

import java.lang.reflect.InvocationTargetException;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import sernet.gs.ui.rcp.main.ImageCache;
import sernet.gs.ui.rcp.main.common.model.CnAElementFactory;
import sernet.verinice.iso27k.rcp.action.HideEmptyFilter;
import sernet.verinice.model.common.TagParameter;
import sernet.verinice.model.common.TypeParameter;
import sernet.verinice.rcp.ViewFilterDialog;

public class ViewFilterAction
extends Action {
    private static final Logger LOG = Logger.getLogger(ViewFilterAction.class);
    public static final String[][] ISO_TYPES = new String[][]{{"asset", "assetgroup"}, {"audit", "auditgroup"}, {"control", "controlgroup"}, {"samt_topic", "controlgroup"}, {"document", "document_group"}, {"evidence", "evidence_group"}, {"exception", "exceptiongroup"}, {"finding", "finding_group"}, {"incident", "incident_group"}, {"interview", "interview_group"}, {"person-iso", "persongroup"}, {"process", "process_group"}, {"record", "record_group"}, {"requirement", "requirementgroup"}, {"response", "response_group"}, {"incident_scenario", "incident_scenario_group"}, {"threat", "threat_group"}, {"vulnerability", "vulnerability_group"}};
    private String[][] types = ISO_TYPES;
    private TagParameter tagParameter;
    private HideEmptyFilter hideEmptyFilter;
    private TypeParameter typeParameter;

    public ViewFilterAction(String title, TagParameter tagFilter, HideEmptyFilter hideEmptyFilter, TypeParameter typeFilter) {
        super(title, 2);
        this.tagParameter = tagFilter;
        this.hideEmptyFilter = hideEmptyFilter;
        this.typeParameter = typeFilter;
        this.setImageDescriptor(ImageCache.getInstance().getImageDescriptor("filter_tsk.gif"));
        this.setUpCheckStatus();
    }

    public void setUpCheckStatus() {
        this.setChecked(this.tagParameter.isActive() || this.hideEmptyFilter.isActive());
    }

    public void run() {
        ViewFilterDialog dialog = new ViewFilterDialog(Display.getCurrent().getActiveShell(), this);
        dialog.setTypes(this.types);
        if (dialog.open() == 0) {
            this.tagParameter.setPattern(dialog.getCheckedElements());
            this.tagParameter.setFilterOrgs(dialog.getFilterOrgs());
            this.hideEmptyFilter.setHideEmpty(dialog.getHideEmpty());
            this.typeParameter.setVisibleTypeSet(dialog.getVisibleTypes());
            try {
                PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        monitor.beginTask("Activating filter...", -1);
                        CnAElementFactory.getInstance().reloadAllModelsFromDatabase();
                        monitor.done();
                    }
                });
            }
            catch (Exception e) {
                LOG.error((Object)"Error while activating filter", (Throwable)e);
            }
        }
        this.setUpCheckStatus();
    }

    public TagParameter getTagParameter() {
        return this.tagParameter;
    }

    public HideEmptyFilter getHideEmptyFilter() {
        return this.hideEmptyFilter;
    }

    public TypeParameter getTypeParameter() {
        return this.typeParameter;
    }

    public String[][] getTypes() {
        return this.types;
    }

    public void setTypes(String[][] types) {
        this.types = types;
    }
}

