/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.rcp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import sernet.gs.ui.rcp.main.ImageCache;
import sernet.gs.ui.rcp.main.service.ServiceFactory;
import sernet.hui.common.VeriniceContext;
import sernet.verinice.interfaces.CommandException;
import sernet.verinice.interfaces.IAuthService;
import sernet.verinice.interfaces.ICommand;
import sernet.verinice.interfaces.ICommandService;
import sernet.verinice.interfaces.IRightsServiceClient;
import sernet.verinice.iso27k.rcp.ComboModel;
import sernet.verinice.iso27k.rcp.IComboModelLabelProvider;
import sernet.verinice.model.auth.Auth;
import sernet.verinice.model.auth.ConfigurationType;
import sernet.verinice.model.auth.OriginType;
import sernet.verinice.model.auth.Profile;
import sernet.verinice.model.auth.ProfileRef;
import sernet.verinice.model.auth.Userprofile;
import sernet.verinice.model.common.configuration.Configuration;
import sernet.verinice.rcp.Messages;
import sernet.verinice.rcp.ProfileDialog;
import sernet.verinice.rcp.ProfileLabelProvider;
import sernet.verinice.rcp.ProfileTableComparator;
import sernet.verinice.service.account.AccountLoader;
import sernet.verinice.service.commands.LoadVisibleAccounts;

public class UserprofileDialog
extends TitleAreaDialog {
    private static final Logger LOG = Logger.getLogger(UserprofileDialog.class);
    private Combo comboLogin;
    private ComboModel<String> comboModel;
    private TableViewer tableSelected;
    private TableViewer table;
    private TableViewer tableAction;
    private ProfileLabelProvider profileLabelProvider = new ProfileLabelProvider();
    private ProfileTableComparator profileTableComparator = new ProfileTableComparator();
    private Button addAllButton;
    private Button removeAllButton;
    private Auth auth;
    private Userprofile userprofile;
    private List<ProfileRef> selectedProfiles = new ArrayList<ProfileRef>();
    private List<ProfileRef> unselectedProfiles;
    private List<Profile> allProfiles;
    private ProfileRef selectedProfileRef;
    private IRightsServiceClient rightsService;
    private ICommandService commandService;

    public UserprofileDialog(Shell parent) {
        super(parent);
        this.auth = this.getRightService().getConfiguration();
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
        this.allProfiles = this.auth.getProfiles().getProfile();
        this.unselectedProfiles = new ArrayList<ProfileRef>(this.allProfiles.size());
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.UserprofileDialog_0);
    }

    protected Control createDialogArea(Composite parent) {
        int fourColCompCharHeight = 20;
        int fourColCompNumColumns = 4;
        int leftCompCharHeight = 40;
        int rightCompCharHeight = 40;
        int rightButtonCompositeWidthHint = 40;
        this.setTitle(Messages.UserprofileDialog_1);
        String message = Messages.UserprofileDialog_2;
        if (this.auth.getType().equals((Object)ConfigurationType.BLACKLIST)) {
            message = String.valueOf(message) + Messages.UserprofileDialog_19;
        }
        if (this.auth.getType().equals((Object)ConfigurationType.WHITELIST)) {
            message = String.valueOf(message) + Messages.UserprofileDialog_20;
        }
        this.setMessage(message);
        this.setTitleImage(ImageCache.getInstance().getImage("userprofile_64.png"));
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 4);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        Composite comboComposite = new Composite(composite, 0);
        GridData gridData = new GridData(4, 0, true, false);
        comboComposite.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        comboComposite.setLayout((Layout)gridLayout);
        Label label = new Label(comboComposite, 64);
        label.setText(Messages.UserprofileDialog_3);
        this.comboLogin = new Combo(comboComposite, 12);
        this.comboLogin.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UserprofileDialog.this.comboModel.setSelectedIndex(UserprofileDialog.this.comboLogin.getSelectionIndex());
                UserprofileDialog.this.loadProfiles();
            }
        });
        this.comboModel = new ComboModel(new IComboModelLabelProvider(){

            public String getLabel(Object label) {
                return (String)label;
            }
        });
        Composite fourColumnComposite = new Composite(composite, 0);
        gridData = new GridData(4, 4, true, true);
        gridData.heightHint = this.convertHeightInCharsToPixels(20);
        fourColumnComposite.setLayoutData((Object)gridData);
        gridLayout = new GridLayout(4, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        fourColumnComposite.setLayout((Layout)gridLayout);
        Composite leftComposite = new Composite(fourColumnComposite, 0);
        gridData = new GridData(4, 4, true, true);
        gridData.widthHint = this.convertWidthInCharsToPixels(40);
        leftComposite.setLayoutData((Object)gridData);
        gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        leftComposite.setLayout((Layout)gridLayout);
        Composite centerComposite = new Composite(fourColumnComposite, 0);
        gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        centerComposite.setLayout((Layout)gridLayout);
        centerComposite.setLayoutData((Object)new GridData(0x1000000, 128, false, false));
        Composite rightComposite = new Composite(fourColumnComposite, 0);
        gridData = new GridData(4, 4, false, true);
        gridData.widthHint = this.convertWidthInCharsToPixels(40);
        rightComposite.setLayoutData((Object)gridData);
        gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        rightComposite.setLayout((Layout)gridLayout);
        Composite rightButtonComposite = new Composite(fourColumnComposite, 0);
        gridData = new GridData(0x1000000, 4, false, true);
        gridData.widthHint = this.convertWidthInCharsToPixels(40);
        rightButtonComposite.setLayoutData((Object)gridData);
        gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        rightButtonComposite.setLayout((Layout)gridLayout);
        this.tableSelected = this.createTable(leftComposite, Messages.UserprofileDialog_4);
        this.tableSelected.setLabelProvider((IBaseLabelProvider)this.profileLabelProvider);
        this.tableSelected.setComparator((ViewerComparator)this.profileTableComparator);
        this.tableSelected.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.tableSelected.refresh(true);
        this.table = this.createTable(rightComposite, Messages.UserprofileDialog_5);
        this.table.setLabelProvider((IBaseLabelProvider)this.profileLabelProvider);
        this.table.setComparator((ViewerComparator)this.profileTableComparator);
        this.table.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.table.refresh(true);
        this.createButtons(centerComposite);
        this.createProfileButtons(rightButtonComposite);
        this.tableAction = this.createTable(rightButtonComposite, Messages.UserprofileDialog_6);
        this.tableAction.setLabelProvider((IBaseLabelProvider)this.profileLabelProvider);
        this.tableAction.setComparator((ViewerComparator)this.profileTableComparator);
        this.tableAction.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.tableAction.refresh(true);
        this.initializeContent();
        String username = ((IAuthService)VeriniceContext.get((String)"authService")).getUsername();
        this.loadProfiles(username);
        this.comboModel.setSelectedObject(username);
        this.comboLogin.select(this.comboModel.getSelectedIndex());
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    private void initializeContent() {
        this.tableSelected.setInput(this.selectedProfiles);
        this.setUnselected();
        this.table.setInput(this.unselectedProfiles);
        HashSet<String> nameSet = new HashSet<String>();
        try {
            nameSet.addAll(this.loadUserNames());
            boolean isLocalAdmin = this.getAuthService().currentUserHasRole(new String[]{"ROLE_LOCAL_ADMIN"});
            if (isLocalAdmin) {
                nameSet.addAll(AccountLoader.loadGroupNamesForLocalAdmin());
            } else {
                List groupNames = this.getRightService().getGroupnames();
                for (String groupname : groupNames) {
                    if (groupname == null || groupname.isEmpty()) continue;
                    nameSet.add(groupname);
                }
            }
        }
        catch (Exception ex) {
            LOG.error((Object)"account groups loading failed", (Throwable)ex);
        }
        this.comboModel.addAll(nameSet);
        this.comboModel.sort();
        this.comboLogin.setItems(this.comboModel.getLabelArray());
    }

    private Collection<String> loadUserNames() throws CommandException {
        LoadVisibleAccounts command = new LoadVisibleAccounts();
        command = (LoadVisibleAccounts)this.getCommandService().executeCommand((ICommand)command);
        List accountList = command.getAccountList();
        HashSet<String> userNames = new HashSet<String>();
        for (Configuration account : accountList) {
            userNames.add(account.getUser());
        }
        return userNames;
    }

    private void setUnselected() {
        this.unselectedProfiles.clear();
        for (Profile profile : this.allProfiles) {
            if (!this.isLocalAdminCreator(profile) || this.containsProfileRef(this.selectedProfiles, profile.getName())) continue;
            ProfileRef profileRef = new ProfileRef();
            profileRef.setName(profile.getName());
            this.unselectedProfiles.add(profileRef);
        }
    }

    private boolean isLocalAdminCreator(Profile profile) {
        boolean isLocalAdmin = this.getAuthService().currentUserHasRole(new String[]{"ROLE_LOCAL_ADMIN"});
        return !isLocalAdmin || isLocalAdmin && AccountLoader.isLocalAdminCreator((Profile)profile);
    }

    private boolean containsProfileRef(List<ProfileRef> profileRefs, String profileName) {
        boolean contains = false;
        for (ProfileRef profileRef : profileRefs) {
            if (!profileRef.getName().equals(profileName)) continue;
            contains = true;
            break;
        }
        return contains;
    }

    protected void loadProfiles() {
        String selected = this.comboModel.getSelectedObject();
        this.loadProfiles(selected);
    }

    private void loadProfiles(String username) {
        this.allProfiles = this.auth.getProfiles().getProfile();
        this.table.remove(this.unselectedProfiles);
        this.tableSelected.remove(this.selectedProfiles);
        boolean profileFound = false;
        for (Userprofile internalUserprofile : this.auth.getUserprofiles().getUserprofile()) {
            if (!username.equals(internalUserprofile.getLogin())) continue;
            this.userprofile = internalUserprofile;
            this.selectedProfiles = internalUserprofile.getProfileRef();
            profileFound = true;
            break;
        }
        if (!profileFound) {
            Userprofile internalUserprofile;
            internalUserprofile = new Userprofile();
            internalUserprofile.setLogin(username);
            this.auth.getUserprofiles().getUserprofile().add(internalUserprofile);
            this.userprofile = internalUserprofile;
            this.selectedProfiles = internalUserprofile.getProfileRef();
        }
        this.setUnselected();
        boolean isLocalAdmin = this.getAuthService().currentUserHasRole(new String[]{"ROLE_LOCAL_ADMIN"});
        if (isLocalAdmin) {
            ArrayList<ProfileRef> selectedLocalAdminProfileRefs = new ArrayList<ProfileRef>(this.selectedProfiles.size());
            for (ProfileRef profileRef : this.selectedProfiles) {
                if (!AccountLoader.isLocalAdminCreator((Profile)this.getProfil(profileRef))) continue;
                selectedLocalAdminProfileRefs.add(profileRef);
            }
            this.tableSelected.setInput(selectedLocalAdminProfileRefs);
        } else {
            this.tableSelected.setInput(this.selectedProfiles);
        }
        this.table.setInput(this.unselectedProfiles);
        this.table.refresh(true);
        this.tableSelected.refresh(true);
        this.removeAllButton.setEnabled(!this.selectedProfiles.isEmpty());
        this.addAllButton.setEnabled(!this.unselectedProfiles.isEmpty());
    }

    private Profile getProfil(ProfileRef profileRef) {
        for (Profile profile : this.allProfiles) {
            if (!profile.getName().equals(profileRef.getName())) continue;
            return profile;
        }
        return null;
    }

    protected void okPressed() {
        try {
            try {
                this.getRightService().updateConfiguration(this.auth);
            }
            catch (Exception e) {
                String message = "Error while saving userprofiles.";
                LOG.error((Object)"Error while saving userprofiles.", (Throwable)e);
                MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)"Error while saving userprofiles.");
                super.okPressed();
            }
        }
        finally {
            super.okPressed();
        }
    }

    protected void cancelPressed() {
        this.getRightService().reload();
        super.cancelPressed();
    }

    private TableViewer createTable(Composite parent, String title) {
        Label label = new Label(parent, 64);
        label.setText(title);
        label.setLayoutData((Object)new GridData(16384, 128, false, false));
        int style = 2816;
        TableViewer internalTable = new TableViewer(parent, style | 2);
        GridData gd = new GridData(4, 4, true, true);
        internalTable.getControl().setLayoutData((Object)gd);
        internalTable.setUseHashlookup(true);
        return internalTable;
    }

    private void createButtons(Composite parent) {
        Label spacer = new Label(parent, 0);
        spacer.setLayoutData((Object)new GridData(4, 128, true, false));
        Button addButton = new Button(parent, 8);
        addButton.setLayoutData((Object)new GridData(4, 128, true, false));
        addButton.setText(Messages.UserprofileDialog_7);
        addButton.setEnabled(!this.table.getSelection().isEmpty());
        this.addAllButton = new Button(parent, 8);
        this.addAllButton.setLayoutData((Object)new GridData(4, 128, true, false));
        this.addAllButton.setText(Messages.UserprofileDialog_8);
        this.addAllButton.setEnabled(!this.unselectedProfiles.isEmpty());
        Button removeButton = new Button(parent, 8);
        removeButton.setLayoutData((Object)new GridData(4, 128, true, false));
        removeButton.setText(Messages.UserprofileDialog_9);
        removeButton.setEnabled(!this.table.getSelection().isEmpty());
        this.removeAllButton = new Button(parent, 8);
        this.removeAllButton.setLayoutData((Object)new GridData(0x1000000, 128, false, false));
        this.removeAllButton.setText(Messages.UserprofileDialog_10);
        this.removeAllButton.setEnabled(!this.selectedProfiles.isEmpty());
        this.table.addSelectionChangedListener(event -> {
            IStructuredSelection selection = (IStructuredSelection)this.table.getSelection();
            List selectionList = selection.toList();
            addButton.setEnabled(!selectionList.isEmpty());
            if (!selectionList.isEmpty()) {
                ProfileRef profileRef = (ProfileRef)selectionList.get(0);
                this.loadActions(profileRef.getName());
            } else {
                this.loadActions(null);
            }
        });
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UserprofileDialog.this.addSelection();
                UserprofileDialog.this.removeAllButton.setEnabled(true);
                UserprofileDialog.this.addAllButton.setEnabled(!UserprofileDialog.this.table.getSelection().isEmpty());
            }
        });
        this.table.addDoubleClickListener(event -> {
            this.addSelection();
            this.removeAllButton.setEnabled(true);
            this.addAllButton.setEnabled(!this.table.getSelection().isEmpty());
        });
        this.tableSelected.addSelectionChangedListener(event -> {
            IStructuredSelection selection = (IStructuredSelection)this.tableSelected.getSelection();
            List selectionList = selection.toList();
            removeButton.setEnabled(!selectionList.isEmpty());
            if (!selectionList.isEmpty()) {
                ProfileRef profileRef = (ProfileRef)selectionList.get(0);
                this.loadActions(profileRef.getName());
            } else {
                this.loadActions(null);
            }
        });
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UserprofileDialog.this.removeSelection();
                UserprofileDialog.this.addAllButton.setEnabled(true);
                UserprofileDialog.this.removeAllButton.setEnabled(!UserprofileDialog.this.selectedProfiles.isEmpty());
            }
        });
        this.tableSelected.addDoubleClickListener(event -> {
            this.removeSelection();
            this.addAllButton.setEnabled(true);
            this.removeAllButton.setEnabled(!this.selectedProfiles.isEmpty());
        });
        this.addAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UserprofileDialog.this.selectedProfiles.addAll(UserprofileDialog.this.unselectedProfiles);
                UserprofileDialog.this.unselectedProfiles.clear();
                UserprofileDialog.this.table.refresh();
                UserprofileDialog.this.tableSelected.refresh();
                UserprofileDialog.this.addAllButton.setEnabled(false);
                UserprofileDialog.this.removeAllButton.setEnabled(true);
                UserprofileDialog.this.userprofile.setOrigin(null);
            }
        });
        this.removeAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UserprofileDialog.this.unselectedProfiles.addAll(UserprofileDialog.this.selectedProfiles);
                UserprofileDialog.this.selectedProfiles.clear();
                UserprofileDialog.this.table.refresh();
                UserprofileDialog.this.tableSelected.refresh();
                UserprofileDialog.this.removeAllButton.setEnabled(false);
                UserprofileDialog.this.addAllButton.setEnabled(true);
                UserprofileDialog.this.userprofile.setOrigin(null);
            }
        });
    }

    protected void loadActions(String name) {
        if (name != null) {
            for (Profile profile : this.allProfiles) {
                if (!profile.getName().equals(name)) continue;
                this.tableAction.setInput((Object)profile.getAction());
                break;
            }
        } else {
            this.tableAction.setInput(Collections.emptyList());
        }
    }

    private void createProfileButtons(Composite parent) {
        Label spacer = new Label(parent, 0);
        spacer.setLayoutData((Object)new GridData(0x1000000, 128, false, false));
        Button newButton = new Button(parent, 8);
        newButton.setLayoutData((Object)new GridData(4, 128, true, false));
        newButton.setText(Messages.UserprofileDialog_11);
        Button editButton = new Button(parent, 8);
        editButton.setLayoutData((Object)new GridData(4, 128, true, false));
        editButton.setText(Messages.UserprofileDialog_12);
        editButton.setEnabled(!this.table.getSelection().isEmpty());
        Button removeButton = new Button(parent, 8);
        removeButton.setLayoutData((Object)new GridData(4, 128, true, false));
        removeButton.setText(Messages.UserprofileDialog_13);
        removeButton.setEnabled(!this.table.getSelection().isEmpty());
        this.table.addSelectionChangedListener(event -> {
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            List selectionList = selection.toList();
            if (selectionList != null && selectionList.size() == 1 && selectionList.get(0) instanceof ProfileRef) {
                this.selectedProfileRef = (ProfileRef)selectionList.get(0);
            }
            editButton.setEnabled(selectionList != null && !selectionList.isEmpty());
            removeButton.setEnabled(selectionList != null && !selectionList.isEmpty());
        });
        this.tableSelected.addSelectionChangedListener(event -> {
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            List selectionList = selection.toList();
            if (selectionList != null && selectionList.size() == 1 && selectionList.get(0) instanceof ProfileRef) {
                this.selectedProfileRef = (ProfileRef)selectionList.get(0);
            }
            editButton.setEnabled(selectionList != null && !selectionList.isEmpty());
            removeButton.setEnabled(selectionList != null && !selectionList.isEmpty());
        });
        newButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UserprofileDialog.this.newProfile();
            }
        });
        editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UserprofileDialog.this.editProfile();
            }
        });
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                UserprofileDialog.this.deleteProfile();
            }
        });
    }

    protected void editProfile() {
        ProfileDialog profiledialog;
        if (this.selectedProfileRef != null && (profiledialog = new ProfileDialog(this.getShell(), this.auth, this.selectedProfileRef.getName())).open() == 0) {
            this.auth = profiledialog.getAuth();
            this.loadProfiles();
            return;
        }
    }

    protected void deleteProfile() {
        if (this.selectedProfileRef != null) {
            for (Profile p : this.auth.getProfiles().getProfile()) {
                if (!p.getName().equals(this.selectedProfileRef.getName()) || !p.getOrigin().equals((Object)OriginType.DEFAULT)) continue;
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.UserprofileDialog_15, (String)Messages.UserprofileDialog_16);
                return;
            }
            if (MessageDialog.openConfirm((Shell)this.getShell(), (String)Messages.UserprofileDialog_14, (String)NLS.bind((String)Messages.UserprofileDialog_18, (Object)this.selectedProfileRef.getName()))) {
                Profile profile = new Profile();
                profile.setName(this.selectedProfileRef.getName());
                this.auth.getProfiles().getProfile().remove(profile);
                for (Userprofile internalUserprofile : this.auth.getUserprofiles().getUserprofile()) {
                    internalUserprofile.getProfileRef().remove(this.selectedProfileRef);
                }
                this.loadProfiles();
            }
        }
    }

    protected void newProfile() {
        ProfileDialog profiledialog = new ProfileDialog(this.getShell(), this.auth, null);
        if (profiledialog.open() == 0) {
            this.auth = profiledialog.getAuth();
            this.loadProfiles();
            return;
        }
    }

    private void addSelection() {
        IStructuredSelection selection = (IStructuredSelection)this.table.getSelection();
        List selectionList = selection.toList();
        this.selectedProfiles.addAll(selectionList);
        this.unselectedProfiles.removeAll(selectionList);
        Object[] selectedElements = selection.toArray();
        this.tableSelected.add(selectedElements);
        this.table.remove(selectedElements);
        this.tableSelected.setSelection((ISelection)selection);
        this.table.getControl().setFocus();
        this.userprofile.setOrigin(null);
    }

    private void removeSelection() {
        IStructuredSelection selection = (IStructuredSelection)this.tableSelected.getSelection();
        List selectionList = selection.toList();
        this.selectedProfiles.removeAll(selectionList);
        this.unselectedProfiles.addAll(selectionList);
        Object[] selectedElements = selection.toArray();
        this.table.add(selectedElements);
        this.tableSelected.remove(selectedElements);
        this.table.setSelection((ISelection)selection);
        this.tableSelected.getControl().setFocus();
        this.userprofile.setOrigin(null);
    }

    IRightsServiceClient getRightService() {
        if (this.rightsService == null) {
            this.rightsService = (IRightsServiceClient)VeriniceContext.get((String)"rightsService");
        }
        return this.rightsService;
    }

    private ICommandService getCommandService() {
        if (this.commandService == null) {
            this.commandService = (ICommandService)VeriniceContext.get((String)"commandService");
        }
        return this.commandService;
    }

    private IAuthService getAuthService() {
        return ServiceFactory.lookupAuthService();
    }
}

