/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.rcp;

import java.util.Map;
import java.util.Optional;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.menus.UIElement;
import sernet.gs.ui.rcp.main.Activator;
import sernet.gs.ui.rcp.main.ImageCache;
import sernet.gs.ui.rcp.main.common.model.CnAElementHome;
import sernet.verinice.model.common.CnATreeElement;
import sernet.verinice.model.iso27k.Asset;
import sernet.verinice.model.iso27k.Audit;
import sernet.verinice.model.iso27k.Group;
import sernet.verinice.rcp.AddGroupHandler;
import sernet.verinice.rcp.AddGroupMessageHelper;
import sernet.verinice.rcp.Messages;

public abstract class UpdatingAddGroupHandler
extends AddGroupHandler
implements IElementUpdater {
    public void updateElement(UIElement menu, Map arg1) {
        CnATreeElement selectedElement = this.getSelectedElement();
        if (selectedElement != null) {
            this.configureMenu(menu, selectedElement);
        }
    }

    private void configureMenu(UIElement menu, CnATreeElement selectedElement) {
        boolean allowed = CnAElementHome.getInstance().isNewChildAllowed(selectedElement);
        boolean enabled = false;
        if (selectedElement instanceof Audit) {
            menu.setText(Messages.AddGroupHandler_new_group);
        } else if (selectedElement instanceof Group) {
            enabled = true;
            Group group = (Group)selectedElement;
            String childTypeId = group.getChildTypes()[0];
            if (selectedElement instanceof Asset) {
                childTypeId = "control";
            }
            String imageUrl = ImageCache.getInstance().getImageURL(childTypeId);
            ImageDescriptor imageDescriptor = ImageCache.getInstance().getImageDescriptor(imageUrl);
            menu.setIcon(imageDescriptor);
            menu.setText(Optional.ofNullable(AddGroupMessageHelper.getMessageForAddGroup(group.getTypeId())).orElse(Messages.AddGroupHandler_new_group));
        }
        if (this.isEnabled()) {
            this.setEnabled(allowed && enabled);
        }
    }

    private CnATreeElement getSelectedElement() {
        Object sel;
        CnATreeElement element = null;
        ISelection selection = this.getSelection();
        if (selection instanceof IStructuredSelection && (sel = ((IStructuredSelection)selection).getFirstElement()) instanceof CnATreeElement) {
            element = (CnATreeElement)sel;
        }
        return element;
    }

    private ISelection getSelection() {
        Activator activator = Activator.getDefault();
        IWorkbench workbench = activator.getWorkbench();
        IWorkbenchWindow workbenchWindow = workbench.getActiveWorkbenchWindow();
        ISelectionService selectionService = workbenchWindow.getSelectionService();
        return selectionService.getSelection();
    }
}

