/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.rcp;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.equinox.internal.p2.ui.ProvUIActivator;
import org.eclipse.equinox.p2.operations.ProvisioningJob;
import org.eclipse.equinox.p2.operations.ProvisioningSession;
import org.eclipse.equinox.p2.operations.UpdateOperation;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import sernet.gs.ui.rcp.main.Activator;
import sernet.gs.ui.rcp.main.bsi.views.listeners.DisableContextMenuListener;
import sernet.verinice.rcp.Messages;

public class UpdateNewsDialog
extends Dialog {
    private static final String SHOP_URL = "https://shop.verinice.com/";
    private String message;
    private URL updateSite;
    private static final Logger LOG = Logger.getLogger(UpdateNewsDialog.class);

    public UpdateNewsDialog(Shell parent, String text, URL updateSite) {
        super(parent);
        this.message = text;
        this.updateSite = updateSite;
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        container.setLayout((Layout)new GridLayout(1, false));
        GridData gridData = new GridData(1808);
        gridData.heightHint = 300;
        container.setLayoutData((Object)gridData);
        this.createContent(container);
        return container;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.UpdateNewsDialog_1);
        Point cursorLocation = Display.getCurrent().getCursorLocation();
        int shellLocationXSubtrahend = 200;
        int shellLocationYSubtrahend = 400;
        newShell.setLocation(new Point(cursorLocation.x - 200, cursorLocation.y - 400));
    }

    protected Button createButton(Composite arg0, int arg1, String arg2, boolean arg3) {
        return null;
    }

    private void createContent(final Composite parent) {
        Composite dialogComposite = new Composite(parent, 2064);
        GridData gridData = new GridData(1808);
        dialogComposite.setLayout((Layout)new GridLayout(4, false));
        gridData.verticalIndent = 1;
        dialogComposite.setLayoutData((Object)gridData);
        Browser browser = new Browser(dialogComposite, 16);
        browser.setJavascriptEnabled(false);
        browser.addMenuDetectListener((MenuDetectListener)new DisableContextMenuListener());
        gridData = new GridData(1808);
        gridData.horizontalSpan = 4;
        gridData.verticalSpan = 4;
        gridData.minimumHeight = parent.getClientArea().height / 2;
        browser.setLayoutData((Object)gridData);
        browser.setText(this.message);
        browser.addLocationListener(new LocationListener(){

            public void changing(LocationEvent event) {
                try {
                    if (!event.location.startsWith("about")) {
                        PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser().openURL(new URL(event.location));
                    }
                }
                catch (MalformedURLException | PartInitException e) {
                    LOG.error((Object)"Error opening Link in external Browser", e);
                }
            }

            public void changed(LocationEvent event) {
            }
        });
        Button showAgainCheck = new Button(dialogComposite, 32);
        showAgainCheck.setText(Messages.UpdateNewsDialog_0);
        showAgainCheck.setEnabled(true);
        showAgainCheck.setSelection(this.getShowAgainProperty());
        showAgainCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                UpdateNewsDialog.this.setShowAgainProperty(((Button)event.getSource()).getSelection());
            }
        });
        gridData = new GridData(1, 1, false, false);
        gridData.horizontalSpan = 4;
        showAgainCheck.setLayoutData((Object)gridData);
        Composite buttonComposite = new Composite(dialogComposite, 0);
        buttonComposite.setLayout((Layout)new GridLayout(3, false));
        gridData = new GridData(3, 3, true, false);
        gridData.horizontalSpan = 4;
        buttonComposite.setLayoutData((Object)gridData);
        Button openShop = new Button(buttonComposite, 8);
        openShop.setText(Messages.UpdateNewsDialog_13);
        gridData = new GridData();
        openShop.setLayoutData((Object)gridData);
        openShop.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                try {
                    Program.launch((String)UpdateNewsDialog.SHOP_URL);
                }
                catch (Exception e) {
                    LOG.error((Object)"Error while loading shop", (Throwable)e);
                }
            }
        });
        Button updateLater = new Button(buttonComposite, 8);
        updateLater.setText(Messages.UpdateNewsDialog_2);
        gridData = new GridData();
        updateLater.setLayoutData((Object)gridData);
        updateLater.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                parent.getShell().close();
            }
        });
        Button updateNow = new Button(buttonComposite, 8);
        updateNow.setText(Messages.UpdateNewsDialog_3);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        updateLater.setLayoutData((Object)gridData);
        updateNow.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                try {
                    UpdateNewsDialog.this.triggerUpdate(UpdateNewsDialog.this.updateSite);
                    parent.getShell().close();
                }
                catch (URISyntaxException e) {
                    LOG.error((Object)"URL of given Updatesite is not valid", (Throwable)e);
                }
            }
        });
    }

    private void setShowAgainProperty(boolean showAgain) {
        Activator.getDefault().getPluginPreferences().setValue("show_update_news_dialog", showAgain);
    }

    private boolean getShowAgainProperty() {
        return Activator.getDefault().getPluginPreferences().getBoolean("show_update_news_dialog");
    }

    private void triggerUpdate(URL updateSiteURL) throws URISyntaxException {
        ProvisioningSession session = ProvUIActivator.getDefault().getProvisioningUI().getSession();
        UpdateOperation operation = new UpdateOperation(session);
        operation.getProvisioningContext().setArtifactRepositories(new URI[]{updateSiteURL.toURI()});
        operation.getProvisioningContext().setMetadataRepositories(new URI[]{updateSiteURL.toURI()});
        IStatus status = operation.resolveModal(null);
        if (status.getCode() == 10000) {
            LOG.debug((Object)"detected there is nothing to update");
            MessageDialog.openInformation(null, (String)Messages.UpdateNewsDialog_5, (String)Messages.UpdateNewsDialog_4);
            return;
        }
        this.createAndExecuteUpdateJob(operation);
    }

    private void restartApplication() {
        this.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                boolean restart = MessageDialog.openQuestion(null, (String)Messages.UpdateNewsDialog_6, (String)Messages.UpdateNewsDialog_7);
                if (restart) {
                    LOG.debug((Object)"Restarting application manually requested after update");
                    PlatformUI.getWorkbench().restart();
                }
            }
        });
    }

    private void createAndExecuteUpdateJob(UpdateOperation operation) {
        try {
            LOG.debug((Object)"creating provisioningJob from p2-api");
            ProvisioningJob provisioningJob = operation.getProvisioningJob(null);
            if (provisioningJob != null) {
                LOG.debug((Object)"performing update using provisioning job");
                this.performUpdate(provisioningJob);
            } else {
                LOG.debug((Object)"provisioning job was null");
                this.handleUpdateError(operation);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error executing update", (Throwable)e);
        }
    }

    private void handleUpdateError(UpdateOperation operation) {
        if (operation.hasResolved()) {
            MessageDialog.openError(null, (String)Messages.UpdateNewsDialog_8, (String)(String.valueOf(Messages.UpdateNewsDialog_9) + ":\t" + operation.getResolutionResult()));
        } else {
            MessageDialog.openError(null, (String)Messages.UpdateNewsDialog_8, (String)Messages.UpdateNewsDialog_9);
        }
    }

    private void performUpdate(final ProvisioningJob provisioningJob) {
        this.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                boolean performUpdate = MessageDialog.openQuestion(null, (String)Messages.UpdateNewsDialog_10, (String)Messages.UpdateNewsDialog_11);
                if (performUpdate) {
                    LOG.debug((Object)"Running update job modal");
                    provisioningJob.addJobChangeListener(new IJobChangeListener(){

                        public void sleeping(IJobChangeEvent arg0) {
                            LOG.debug((Object)"Update-Job sleeping");
                        }

                        public void scheduled(IJobChangeEvent arg0) {
                            LOG.debug((Object)"Update-Job scheduled");
                        }

                        public void running(IJobChangeEvent arg0) {
                            LOG.debug((Object)"Update-Job running");
                        }

                        public void done(IJobChangeEvent arg0) {
                            LOG.debug((Object)"Update-Job done");
                            UpdateNewsDialog.this.restartApplication();
                        }

                        public void awake(IJobChangeEvent arg0) {
                            LOG.debug((Object)"Update-Job awake");
                        }

                        public void aboutToRun(IJobChangeEvent arg0) {
                            LOG.debug((Object)"Update-Job about to run");
                        }
                    });
                    provisioningJob.schedule();
                }
            }
        });
    }

    private Display getDisplay() {
        if (Display.getCurrent() == null) {
            return Display.getDefault();
        }
        return Display.getCurrent();
    }
}

