/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.rcp;

import java.io.File;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import sernet.gs.ui.rcp.main.Activator;
import sernet.gs.ui.rcp.main.CnAWorkspace;
import sernet.gs.ui.rcp.main.common.model.CnAElementFactory;
import sernet.gs.ui.rcp.main.common.model.IModelLoadListener;
import sernet.gs.ui.rcp.main.service.ServiceFactory;
import sernet.hui.common.VeriniceContext;
import sernet.verinice.interfaces.ICommand;
import sernet.verinice.interfaces.ICommandService;
import sernet.verinice.interfaces.IRightsServiceClient;
import sernet.verinice.iso27k.rcp.JobScheduler;
import sernet.verinice.model.bp.elements.BpModel;
import sernet.verinice.model.bsi.BSIModel;
import sernet.verinice.model.catalog.CatalogModel;
import sernet.verinice.model.iso27k.ISO27KModel;
import sernet.verinice.rcp.Messages;
import sernet.verinice.service.commands.SyncCommand;
import sernet.verinice.service.commands.SyncParameter;

public abstract class StartupImporter {
    private static final Logger LOG = Logger.getLogger(StartupImporter.class);
    public static final String SERVER_TRANSPORT_BASENAME = "client-server-transport";
    private static volatile IModelLoadListener modelLoadListener;

    public static synchronized void importVna() {
        if (!StartupImporter.isRestart()) {
            StartupImporter.deleteFiles();
            return;
        }
        if (CnAElementFactory.isModelLoaded()) {
            StartupImporter.startImportJob();
        } else if (modelLoadListener == null) {
            modelLoadListener = new IModelLoadListener(){

                @Override
                public void closed(BSIModel model) {
                }

                @Override
                public void loaded(BSIModel model) {
                }

                @Override
                public void loaded(ISO27KModel model) {
                    StartupImporter.startImportJob();
                }

                @Override
                public void loaded(BpModel model) {
                }

                @Override
                public void loaded(CatalogModel model) {
                }
            };
            CnAElementFactory.getInstance().addLoadListener(modelLoadListener);
        }
    }

    private static boolean isRestart() {
        IPreferenceStore prefs = Activator.getDefault().getPreferenceStore();
        return StartupImporter.getImportFile(0).exists() && prefs.getBoolean("is_restart");
    }

    protected static void startImportJob() {
        if (!StartupImporter.getRightsService().isEnabled("xmlimport")) {
            StartupImporter.deleteFiles();
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)"Import", (String)"Data transfer failed. You are are not allowed to import data.");
                }
            });
            return;
        }
        WorkspaceJob initDataJob = new WorkspaceJob(Messages.StartupImporter_0){

            public IStatus runInWorkspace(IProgressMonitor monitor) {
                IStatus status = Status.OK_STATUS;
                try {
                    try {
                        monitor.beginTask(Messages.StartupImporter_1, -1);
                        StartupImporter.doImport();
                    }
                    catch (Exception e) {
                        LOG.error((Object)"Error while loading data.", (Throwable)e);
                        status = new Status(4, "sernet.gs.ui.rcp.main", Messages.StartupImporter_2, (Throwable)e);
                        monitor.done();
                    }
                }
                finally {
                    monitor.done();
                }
                return status;
            }
        };
        JobScheduler.scheduleInitJob(initDataJob);
    }

    protected static void doImport() {
        try {
            boolean fileExists = true;
            int i = 0;
            while (fileExists) {
                File archive = StartupImporter.getImportFile(i);
                fileExists = archive.exists();
                if (fileExists) {
                    StartupImporter.doImport(archive);
                }
                ++i;
            }
        }
        finally {
            CnAElementFactory.getInstance().removeLoadListener(modelLoadListener);
            IPreferenceStore prefs = Activator.getDefault().getPreferenceStore();
            prefs.setValue("is_restart", false);
        }
    }

    private static void doImport(File archive) {
        try {
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Starting import of file: " + archive.getAbsolutePath()));
                }
                byte[] fileData = FileUtils.readFileToByteArray((File)archive);
                Activator.inheritVeriniceContextState();
                SyncCommand command = new SyncCommand(new SyncParameter(true, true, false, false, SyncParameter.EXPORT_FORMAT_VERINICE_ARCHIV), fileData);
                StartupImporter.getCommandService().executeCommand((ICommand)command);
            }
            catch (Exception e) {
                LOG.error((Object)"Error while importing.", (Throwable)e);
                if (archive != null && archive.exists()) {
                    FileUtils.deleteQuietly((File)archive);
                }
            }
        }
        finally {
            if (archive != null && archive.exists()) {
                FileUtils.deleteQuietly((File)archive);
            }
        }
    }

    private static File getImportFile(int i) {
        StringBuilder sb = new StringBuilder();
        sb.append(CnAWorkspace.getInstance().getConfDir()).append(File.separatorChar).append(SERVER_TRANSPORT_BASENAME);
        sb.append("-").append(i).append(".vna");
        File archive = new File(sb.toString());
        return archive;
    }

    private static void deleteFiles() {
        boolean fileExists = true;
        int i = 0;
        while (fileExists) {
            File archive = StartupImporter.getImportFile(i);
            fileExists = archive.exists();
            if (fileExists) {
                FileUtils.deleteQuietly((File)archive);
            }
            ++i;
        }
    }

    private static ICommandService getCommandService() {
        return ServiceFactory.lookupCommandService();
    }

    private static IRightsServiceClient getRightsService() {
        return (IRightsServiceClient)VeriniceContext.get((String)"rightsService");
    }
}

