/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.rcp;

import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import sernet.verinice.interfaces.CommandException;
import sernet.verinice.iso27k.rcp.ScopeMultiselectWidget;
import sernet.verinice.model.common.CnATreeElement;
import sernet.verinice.rcp.Messages;
import sernet.verinice.rcp.MultiselectWidget;
import sernet.verinice.rcp.Preferences;

public class ServerConnectionToggleDialog
extends TitleAreaDialog {
    private static final Logger LOG = Logger.getLogger(ServerConnectionToggleDialog.class);
    private MultiselectWidget organizationWidget = null;
    private String serverUrl;

    protected ServerConnectionToggleDialog(Shell shell) {
        super(shell);
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        int layoutMarginWidth = 10;
        int layoutMarginHeight = 10;
        int layoutVerticalSpacing = 10;
        int urlTextMinimumWidth = 150;
        if (Preferences.isServerMode()) {
            this.setTitle(Messages.ServerConnectionToggleDialog_0);
            this.setMessage(Messages.ServerConnectionToggleDialog_1, 1);
        } else {
            this.setTitle(Messages.ServerConnectionToggleDialog_2);
            this.setMessage(Messages.ServerConnectionToggleDialog_3, 1);
        }
        GridLayout layout = (GridLayout)composite.getLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.verticalSpacing = 10;
        GridData gd = new GridData(4, 4, true, true);
        composite.setLayoutData((Object)gd);
        Label urlLabel = new Label(composite, 0);
        urlLabel.setText(Messages.ServerConnectionToggleDialog_4);
        final Text urlText = new Text(composite, 2048);
        gd = new GridData(4, 1024, true, false);
        gd.minimumWidth = 150;
        urlText.setLayoutData((Object)gd);
        urlText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ServerConnectionToggleDialog.this.serverUrl = urlText.getText();
            }
        });
        String url = Preferences.getServerUrl();
        if (url != null) {
            urlText.setText(url);
        }
        if (Preferences.isServerMode()) {
            urlText.setEnabled(false);
        }
        try {
            this.organizationWidget = new ScopeMultiselectWidget(composite);
        }
        catch (CommandException ex) {
            LOG.error((Object)"Error while loading organizations", (Throwable)ex);
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.ServerConnectionToggleDialog_5, (String)Messages.ServerConnectionToggleDialog_6);
            return null;
        }
        SelectionAdapter organizationListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
            }
        };
        this.organizationWidget.addSelectionListener((SelectionListener)organizationListener);
        composite.pack();
        return composite;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        if (Preferences.isServerMode()) {
            newShell.setText(Messages.ServerConnectionToggleDialog_7);
        } else {
            newShell.setText(Messages.ServerConnectionToggleDialog_8);
        }
    }

    public Set<CnATreeElement> getSelectedElementSet() {
        return this.organizationWidget.getSelectedElementSet();
    }

    public String getServerUrl() {
        return this.serverUrl;
    }
}

