/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.rcp;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.internal.Workbench;
import sernet.gs.ui.rcp.main.Activator;
import sernet.gs.ui.rcp.main.CnAWorkspace;
import sernet.gs.ui.rcp.main.actions.RightsEnabledAction;
import sernet.gs.ui.rcp.main.service.ServiceFactory;
import sernet.verinice.interfaces.CommandException;
import sernet.verinice.interfaces.ICommand;
import sernet.verinice.iso27k.rcp.JobScheduler;
import sernet.verinice.iso27k.rcp.Mutex;
import sernet.verinice.model.common.CnATreeElement;
import sernet.verinice.rcp.Messages;
import sernet.verinice.rcp.Preferences;
import sernet.verinice.rcp.ServerConnectionToggleDialog;
import sernet.verinice.service.commands.ExportCommand;
import sernet.verinice.service.commands.SyncParameter;

public class ServerConnectionToggleAction
extends RightsEnabledAction {
    private static final Logger LOG = Logger.getLogger(ServerConnectionToggleAction.class);
    public static final String SOURCE_ID = "transfer";
    public static final String ID = "sernet.verinice.rcp.ServerConnectionToggleAction";
    private static ISchedulingRule iSchedulingRule = new Mutex();
    private String filePathBase;
    private ServerConnectionToggleDialog dialog;

    public ServerConnectionToggleAction() {
        super("xmlexport", Preferences.isServerMode() ? Messages.ServerConnectionToggleAction_0 : Messages.ServerConnectionToggleAction_1);
        this.setId(ID);
        StringBuilder sb = new StringBuilder();
        sb.append(CnAWorkspace.getInstance().getConfDir()).append(File.separatorChar).append("client-server-transport");
        this.filePathBase = sb.toString();
    }

    @Override
    public void doRun() {
        this.dialog = new ServerConnectionToggleDialog(Display.getCurrent().getActiveShell());
        if (this.dialog.open() == 0) {
            String title = Messages.ServerConnectionToggleAction_2;
            if (Preferences.isStandalone()) {
                title = Messages.ServerConnectionToggleAction_3;
            }
            WorkspaceJob exportJob = new WorkspaceJob(title){

                public IStatus runInWorkspace(IProgressMonitor monitor) {
                    IStatus status = Status.OK_STATUS;
                    try {
                        try {
                            monitor.beginTask(Messages.ServerConnectionToggleAction_4, -1);
                            ServerConnectionToggleAction.this.export();
                        }
                        catch (Exception e) {
                            LOG.error((Object)"Error while exporting data.", (Throwable)e);
                            status = new Status(4, "sernet.verinice.samt.rcp", Messages.ServerConnectionToggleAction_6, (Throwable)e);
                            monitor.done();
                            this.done(status);
                        }
                    }
                    finally {
                        monitor.done();
                        this.done(status);
                    }
                    return status;
                }
            };
            exportJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    if (Status.OK_STATUS.equals(event.getResult())) {
                        ServerConnectionToggleAction.this.restart();
                    }
                }
            });
            JobScheduler.scheduleJob(exportJob, iSchedulingRule);
        }
    }

    private void export() throws CommandException, IOException {
        this.export(new ArrayList<CnATreeElement>(this.dialog.getSelectedElementSet()), 0);
    }

    private void export(List<CnATreeElement> elementList, int i) throws CommandException, IOException {
        String sourceId = this.readSourceId(elementList);
        if (sourceId == null) {
            sourceId = SOURCE_ID;
        }
        Activator.inheritVeriniceContextState();
        ExportCommand exportCommand = new ExportCommand(elementList, sourceId, true, SyncParameter.EXPORT_FORMAT_VERINICE_ARCHIV);
        exportCommand = (ExportCommand)ServiceFactory.lookupCommandService().executeCommand((ICommand)exportCommand);
        FileUtils.writeByteArrayToFile((File)new File(this.createFilePath(i)), (byte[])exportCommand.getResult());
    }

    private String readSourceId(List<CnATreeElement> elementList) {
        String sourceId = null;
        Hashtable<String, Integer> sourceIdMap = new Hashtable<String, Integer>();
        for (CnATreeElement element : elementList) {
            String cur = element.getSourceId();
            if (cur == null) continue;
            Integer n = (Integer)sourceIdMap.get(cur);
            if (n == null) {
                n = 0;
            }
            n = n + 1;
            sourceIdMap.put(cur, n);
        }
        int max = 0;
        for (String cur : sourceIdMap.keySet()) {
            int n = (Integer)sourceIdMap.get(cur);
            if (n <= max) continue;
            max = n;
            sourceId = cur;
        }
        return sourceId;
    }

    private String createFilePath(int i) {
        StringBuilder sb = new StringBuilder(this.filePathBase);
        return sb.append("-").append(i).append(".vna").toString();
    }

    private void restart() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                IPreferenceStore prefs = Activator.getDefault().getPreferenceStore();
                if (Preferences.isStandalone()) {
                    prefs.setValue("gs_cna_vnserver_uri", ServerConnectionToggleAction.this.dialog.getServerUrl());
                }
                String newMode = "gs_cna_operationmode_standalone";
                if (prefs.getString("gs_cna_operationmode").equals("gs_cna_operationmode_standalone")) {
                    newMode = "gs_cna_operationmode_withserver";
                }
                prefs.setValue("gs_cna_operationmode", newMode);
                prefs.setValue("is_restart", true);
                Workbench.getInstance().restart();
            }
        });
    }
}

