/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.rcp;

import org.apache.commons.lang.math.NumberUtils;
import org.apache.log4j.Logger;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelProvider;
import sernet.gs.ui.rcp.main.Activator;
import sernet.gs.ui.rcp.main.ImageCache;
import sernet.hui.common.connect.Entity;
import sernet.verinice.model.common.CnATreeElement;

public class RiskAnalysisDecorator
extends LabelProvider
implements ILightweightLabelDecorator {
    private static final Logger LOG = Logger.getLogger(RiskAnalysisDecorator.class);
    private static final int NO_RISK_VALUE = -1;
    private static final int COMBINED_RISK_VALUE_LOW = 0;
    private static final int COMBINED_RISK_VALUE_MEDIUM = 1;
    private static final int COMBINED_RISK_VALUE_HIGH = 2;
    private static final int RISK_THRESHOLD_MEDIUM = 2;
    private static final int RISK_THRESHOLD_HIGH = 5;
    private static final int RISK_THRESHOLD_MEDIUM_THREAT = 1;
    private static final int RISK_THRESHOLD_HIGH_THREAT = 3;
    private static final int RISK_THRESHOLD_MEDIUM_VULNERABILITY = 0;
    private static final int RISK_THRESHOLD_HIGH_VULNERABILITY = 1;
    private static final String IMAGE_PATH_GREEN = "overlays/dot_green.png";
    private static final String IMAGE_PATH_YELLOW = "overlays/dot_yellow.png";
    private static final String IMAGE_PATH_RED = "overlays/dot_red.png";
    private static final String IMAGE_PATH_EMPTY = "overlays/empty.png";

    public void decorate(Object element, IDecoration decoration) {
        Activator.inheritVeriniceContextState();
        CnATreeElement treeElement = null;
        if (element instanceof CnATreeElement) {
            int riskLevel;
            treeElement = (CnATreeElement)element;
            if (this.prefEnabled() && this.isApplicable(treeElement) && (riskLevel = this.getRiskLevel(treeElement)) != -1) {
                decoration.addOverlay(ImageCache.getInstance().getImageDescriptor(this.getImagePath(riskLevel)));
            }
        }
    }

    private boolean prefEnabled() {
        return Activator.getDefault().getPreferenceStore().getBoolean("show_risk_analysis_decorator");
    }

    private boolean isApplicable(CnATreeElement element) {
        return "asset".equals(element.getTypeId()) || "incident_scenario".equals(element.getTypeId()) || "threat".equals(element.getTypeId()) || "vulnerability".equals(element.getTypeId());
    }

    private int getRiskLevel(CnATreeElement element) {
        try {
            if ("asset".equals(element.getTypeId())) {
                return this.getRiskLevelForAsset(element);
            }
            if ("incident_scenario".equals(element.getTypeId())) {
                return this.getRiskLevelForIncidentScenario(element);
            }
            if ("threat".equals(element.getTypeId())) {
                return this.getRiskLevelForThreat(element);
            }
            if ("vulnerability".equals(element.getTypeId())) {
                return this.getRiskLevelForVulnerability(element);
            }
        }
        catch (NumberFormatException e) {
            LOG.warn((Object)("Error on parsing risklevel for element" + element.getUuid()), (Throwable)e);
        }
        return -1;
    }

    private int getRiskLevelForAsset(CnATreeElement element) throws NumberFormatException {
        Entity treeElementEntity = element.getEntity();
        int riskValueConfidentiality = Integer.parseInt(treeElementEntity.getPropertyValue("asset_riskvalue_c"));
        int riskValueIntegrity = Integer.parseInt(treeElementEntity.getPropertyValue("asset_riskvalue_i"));
        int riskValueAvailability = Integer.parseInt(treeElementEntity.getPropertyValue("asset_riskvalue_a"));
        int riskValueMax = NumberUtils.max((int)riskValueConfidentiality, (int)riskValueIntegrity, (int)riskValueAvailability);
        return this.getRiskLevelForAssetOrIncidentScenario(riskValueMax);
    }

    private int getRiskLevelForIncidentScenario(CnATreeElement element) throws NumberFormatException {
        int riskValueIncidentScenario = Integer.parseInt(element.getEntity().getPropertyValue("incscen_likelihood"));
        return this.getRiskLevelForAssetOrIncidentScenario(riskValueIncidentScenario);
    }

    private int getRiskLevelForAssetOrIncidentScenario(int riskValue) {
        if (riskValue > 5) {
            return 2;
        }
        if (riskValue > 2) {
            return 1;
        }
        return 0;
    }

    private int getRiskLevelForThreat(CnATreeElement element) throws NumberFormatException {
        int riskValue;
        block4: {
            int riskValueThreatLikelihood = Integer.parseInt(element.getEntity().getPropertyValue("threat_likelihood"));
            int riskValueThreatImpact = Integer.parseInt(element.getEntity().getPropertyValue("threat_impact"));
            riskValue = Math.max(riskValueThreatLikelihood, riskValueThreatImpact);
            if (riskValue <= 3) break block4;
            return 2;
        }
        if (riskValue > 1) {
            return 1;
        }
        return 0;
    }

    private int getRiskLevelForVulnerability(CnATreeElement element) throws NumberFormatException {
        int riskValue;
        block4: {
            riskValue = Integer.parseInt(element.getEntity().getPropertyValue("vulnerability_level"));
            if (riskValue <= 1) break block4;
            return 2;
        }
        if (riskValue > 0) {
            return 1;
        }
        return 0;
    }

    private String getImagePath(int riskLevel) {
        switch (riskLevel) {
            case 2: {
                return IMAGE_PATH_RED;
            }
            case 1: {
                return IMAGE_PATH_YELLOW;
            }
            case 0: {
                return IMAGE_PATH_GREEN;
            }
        }
        return IMAGE_PATH_EMPTY;
    }
}

