/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.rcp;

import java.util.stream.Stream;
import org.apache.log4j.Logger;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import sernet.gs.ui.rcp.main.Activator;
import sernet.hui.common.VeriniceContext;
import sernet.springclient.RightsServiceClient;
import sernet.verinice.rcp.PartListenerAdapter;

public abstract class RightsEnabledView
extends ViewPart {
    private static final Logger LOG = Logger.getLogger(RightsEnabledView.class);
    private boolean openingDeclined = false;

    protected void openingDeclined() {
        if (this.openingDeclined) {
            return;
        }
        this.openingDeclined = true;
        LOG.error((Object)("Opening of view is not allowed, view-id: " + this.getViewId() + ", action-id: " + this.getRightID()));
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Stacktrace: ", (Throwable)new RuntimeException());
        }
        RightsEnabledView.closeAllViews(((Object)((Object)this)).getClass());
        this.dispose();
    }

    public void createPartControl(Composite parent) {
        if (!Activator.getDefault().isStandalone() && !this.checkRights()) {
            IWorkbenchWindow workbenchWindow = this.getSite().getWorkbenchWindow();
            workbenchWindow.getPartService().addPartListener((IPartListener2)new CheckPermissonListener());
        }
    }

    private boolean checkRights() {
        Activator.inheritVeriniceContextState();
        RightsServiceClient service = (RightsServiceClient)VeriniceContext.get((String)"rightsService");
        return service.isEnabled(this.getRightID());
    }

    public abstract String getRightID();

    public abstract String getViewId();

    private static void closeAllViews(Class<? extends RightsEnabledView> viewType) {
        Stream.of(PlatformUI.getWorkbench().getWorkbenchWindows()).forEach(window -> Stream.of(window.getPages()).forEach(page -> Stream.of(page.getViewReferences()).forEach(viewRef -> {
            Class<?> partType;
            IWorkbenchPart viewPart = viewRef.getPart(false);
            Class<?> clazz2 = partType = viewPart != null ? viewPart.getClass() : null;
            if (viewType == null || viewType.equals(partType)) {
                RightsEnabledView.safeHideView(page, viewRef);
            }
        })));
    }

    private static void safeHideView(IWorkbenchPage page, IViewReference viewRef) {
        block2: {
            try {
                page.hideView(viewRef);
            }
            catch (Exception e) {
                LOG.warn((Object)"Exception while closing view.");
                if (!LOG.isDebugEnabled()) break block2;
                LOG.debug((Object)"Stacktrace: ", (Throwable)e);
            }
        }
    }

    public void setFocus() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"setFocus...");
        }
    }

    protected boolean isServerRunning() {
        return !Activator.getDefault().isStandalone() || Activator.getDefault().getInternalServer().isRunning();
    }

    private final class CheckPermissonListener
    extends PartListenerAdapter {
        private CheckPermissonListener() {
        }

        @Override
        public void partVisible(IWorkbenchPartReference partRef) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("partVisible: " + partRef.getId()));
            }
            if (RightsEnabledView.this.getViewId().equals(partRef.getId())) {
                if (!RightsEnabledView.this.isServerRunning()) {
                    Activator.getDefault().getInternalServer().addInternalServerStatusListener(e -> {
                        if (e.isStarted()) {
                            this.checkAndDecline();
                        }
                    });
                } else {
                    this.checkAndDecline();
                }
            }
        }

        private void checkAndDecline() {
            if (!RightsEnabledView.this.checkRights()) {
                RightsEnabledView.this.openingDeclined();
            }
        }
    }
}

