/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.rcp;

import org.eclipse.core.commands.AbstractHandler;
import sernet.gs.ui.rcp.main.Activator;
import sernet.hui.common.VeriniceContext;
import sernet.springclient.RightsServiceClient;
import sernet.verinice.interfaces.IInternalServerStartListener;
import sernet.verinice.interfaces.InternalServerEvent;
import sernet.verinice.interfaces.RightEnabledUserInteraction;

public abstract class RightsEnabledHandler
extends AbstractHandler
implements RightEnabledUserInteraction {
    public RightsEnabledHandler() {
        this(true);
    }

    public RightsEnabledHandler(boolean enable) {
        if (enable) {
            this.enableAccordingToUserRights();
        }
    }

    private void enableAccordingToUserRights() {
        if (Activator.getDefault().isStandalone() && !Activator.getDefault().getInternalServer().isRunning()) {
            IInternalServerStartListener listener = new IInternalServerStartListener(){

                public void statusChanged(InternalServerEvent e) {
                    if (e.isStarted()) {
                        RightsEnabledHandler.this.setBaseEnabled(RightsEnabledHandler.this.checkRights());
                    }
                }
            };
            Activator.getDefault().getInternalServer().addInternalServerStatusListener(listener);
        } else {
            this.setBaseEnabled(this.checkRights());
        }
    }

    public boolean checkRights() {
        Activator.inheritVeriniceContextState();
        RightsServiceClient service = (RightsServiceClient)VeriniceContext.get((String)"rightsService");
        return service.isEnabled(this.getRightID());
    }
}

