/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.rcp;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.ActionDelegate;
import sernet.gs.ui.rcp.main.Activator;
import sernet.hui.common.VeriniceContext;
import sernet.springclient.RightsServiceClient;
import sernet.verinice.interfaces.IInternalServerStartListener;
import sernet.verinice.interfaces.InternalServerEvent;
import sernet.verinice.interfaces.RightEnabledUserInteraction;
import sernet.verinice.rcp.Messages;

public abstract class RightsEnabledActionDelegate
extends ActionDelegate
implements RightEnabledUserInteraction {
    public void init(final IAction action) {
        if (!this.isServerRunning()) {
            IInternalServerStartListener listener = new IInternalServerStartListener(){

                public void statusChanged(InternalServerEvent e) {
                    if (e.isStarted()) {
                        action.setEnabled(RightsEnabledActionDelegate.this.checkRights());
                    }
                }
            };
            Activator.getDefault().getInternalServer().addInternalServerStatusListener(listener);
        } else {
            action.setEnabled(this.checkRights());
        }
    }

    public final void run(IAction action) {
        if (this.checkRights()) {
            this.doRun(action);
        } else {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)Messages.RightsEnabledActionDelegate_0, (String)Messages.RightsEnabledActionDelegate_1);
        }
    }

    public abstract void doRun(IAction var1);

    public boolean checkRights() {
        Activator.inheritVeriniceContextState();
        RightsServiceClient service = (RightsServiceClient)VeriniceContext.get((String)"rightsService");
        return service.isEnabled(this.getRightID());
    }

    protected boolean isServerRunning() {
        return !Activator.getDefault().isStandalone() || Activator.getDefault().getInternalServer().isRunning();
    }
}

