/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.rcp;

import java.io.File;
import java.io.IOException;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import sernet.gs.ui.rcp.main.Activator;
import sernet.gs.ui.rcp.main.CnAWorkspace;
import sernet.gs.ui.rcp.main.common.model.CnAElementFactory;
import sernet.gs.ui.rcp.main.common.model.IModelLoadListener;
import sernet.gs.ui.rcp.main.reports.ReportDepositCache;
import sernet.gs.ui.rcp.main.service.ServiceFactory;
import sernet.verinice.interfaces.IReportDepositService;
import sernet.verinice.interfaces.IReportTemplateService;
import sernet.verinice.interfaces.ReportDepositException;
import sernet.verinice.interfaces.ReportTemplateServiceException;
import sernet.verinice.iso27k.rcp.JobScheduler;
import sernet.verinice.model.bp.elements.BpModel;
import sernet.verinice.model.bsi.BSIModel;
import sernet.verinice.model.catalog.CatalogModel;
import sernet.verinice.model.iso27k.ISO27KModel;
import sernet.verinice.model.report.FileMetaData;
import sernet.verinice.rcp.Preferences;

public class ReportTemplateSyncer
extends WorkspaceJob
implements IModelLoadListener {
    private static volatile IModelLoadListener modelLoadListener;
    private static final Logger LOG;
    private IReportTemplateService localReportDeposit = new ReportDepositCache();

    static {
        LOG = Logger.getLogger(ReportTemplateSyncer.class);
    }

    private ReportTemplateSyncer() {
        super("sync reports");
    }

    public static void sync() {
        if (CnAElementFactory.isModelLoaded()) {
            ReportTemplateSyncer.startSync();
        } else if (modelLoadListener == null) {
            CnAElementFactory.getInstance().addLoadListener(new ReportTemplateSyncer());
        }
    }

    private static void startSync() {
        Activator.inheritVeriniceContextState();
        ReportTemplateSyncer syncReportsJob = new ReportTemplateSyncer();
        JobScheduler.scheduleInitJob(syncReportsJob);
    }

    private void syncReportFiles(Locale locale) throws ReportTemplateServiceException, ReportDepositException, IOException {
        Set localFiles = this.localReportDeposit.getAllResources();
        Set remoteFiles = this.getRemoteReportDeposit().getAllResources(locale);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Found\t" + localFiles.size() + "\tfiles in local repo (" + CnAWorkspace.getInstance().getRemoteReportTemplateDir() + ") (server mirror) before the sync"));
            LOG.debug((Object)("Found\t" + remoteFiles.size() + "\tfiles in server repo, which need to be synced"));
            LOG.debug((Object)("Syncing will take place with following locale:\t" + locale));
        }
        this.sync(localFiles, remoteFiles);
        if (Preferences.isServerMode()) {
            this.cleanupLocalFiles(this.localReportDeposit.getAllResources(), remoteFiles);
        }
    }

    private void sync(Set<FileMetaData> localFiles, Set<FileMetaData> remoteFiles) throws ReportTemplateServiceException, ReportDepositException, IOException {
        for (FileMetaData file : remoteFiles) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Syncing:\t" + file.getFilename()));
            }
            if (!localFiles.contains(file)) {
                this.download(file.getFilename());
                continue;
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)("File\t" + file.getFilename() + "\twill not be synced, since it's already existant on client"));
        }
    }

    private void cleanupLocalFiles(Set<FileMetaData> localFiles, Set<FileMetaData> remoteFiles) throws ReportTemplateServiceException {
        for (FileMetaData file : localFiles) {
            if (remoteFiles.contains(file)) continue;
            this.deleteLocalFile(file.getFilename());
        }
    }

    private IReportDepositService getRemoteReportDeposit() {
        return ServiceFactory.lookupReportDepositService();
    }

    private void download(String filename) throws ReportDepositException, ReportTemplateServiceException, IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Syncing:\t" + filename));
        }
        this.deleteLocalFile(filename);
        byte[] content = this.getRemoteReportDeposit().readResource(filename);
        File directory = CnAWorkspace.getInstance().getRemoteReportTemplateDir();
        File rptdesignTemplate = new File(directory, filename);
        FileUtils.writeByteArrayToFile((File)rptdesignTemplate, (byte[])content);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Template:\t" + filename + " written to:\t" + rptdesignTemplate.getAbsolutePath()));
        }
    }

    private void deleteLocalFile(String fileName) {
        File filePath = CnAWorkspace.getInstance().getRemoteReportTemplateDir();
        File file = new File(filePath, fileName);
        if (file.exists()) {
            file.delete();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("TemplateFile:\t" + file.getAbsolutePath() + "\tdeleted"));
            }
        }
    }

    public IStatus runInWorkspace(IProgressMonitor arg0) throws CoreException {
        IStatus status = Status.OK_STATUS;
        try {
            Activator.inheritVeriniceContextState();
            this.syncReportFiles(Locale.getDefault());
        }
        catch (ReportDepositException e) {
            status = this.errorHandler((Exception)((Object)e));
        }
        catch (IOException e) {
            status = this.errorHandler(e);
        }
        catch (ReportTemplateServiceException e) {
            status = this.errorHandler((Exception)((Object)e));
        }
        return status;
    }

    private IStatus errorHandler(Exception e) {
        String msg = "error while syncing report templates:\t" + e.getLocalizedMessage() + e.getStackTrace();
        LOG.error((Object)msg, (Throwable)e);
        Status status = new Status(4, "sernet.gs.ui.rcp.main", msg);
        return status;
    }

    @Override
    public void loaded(BSIModel model) {
    }

    @Override
    public void loaded(ISO27KModel model) {
        ReportTemplateSyncer.sync();
    }

    @Override
    public void closed(BSIModel model) {
    }

    @Override
    public void loaded(BpModel model) {
    }

    @Override
    public void loaded(CatalogModel model) {
    }
}

