/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.rcp;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import sernet.gs.ui.rcp.main.ImageCache;
import sernet.hui.common.VeriniceContext;
import sernet.verinice.interfaces.ActionRightIDs;
import sernet.verinice.interfaces.IAuthService;
import sernet.verinice.interfaces.IRightsServiceClient;
import sernet.verinice.model.auth.Action;
import sernet.verinice.model.auth.Auth;
import sernet.verinice.model.auth.Profile;
import sernet.verinice.model.auth.ProfileRef;
import sernet.verinice.model.auth.Userprofile;
import sernet.verinice.rcp.ActionLabelProvider;
import sernet.verinice.rcp.Messages;

public class ProfileDialog
extends TitleAreaDialog {
    private static final Logger LOG = Logger.getLogger(ProfileDialog.class);
    private Text textName;
    private Label translated;
    private TableViewer tableSelected;
    private TableViewer table;
    private ActionLabelProvider labelProvider = new ActionLabelProvider();
    private Button addAllButton;
    private Button removeAllButton;
    private Auth auth;
    private String profileName;
    private String profileNameOld;
    private Profile profile;
    private List<Action> selectedActions = new ArrayList<Action>();
    private List<Action> selectedActionsOld = new ArrayList<Action>();
    private List<Action> unselectedActions;
    private List<String> allActions;
    private IRightsServiceClient rightsService;
    private IAuthService authService;

    public ProfileDialog(Shell parent) {
        super(parent);
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
        this.auth = this.getRightService().getConfiguration();
        this.loadAllActions();
        this.unselectedActions = new ArrayList<Action>(this.allActions.size());
    }

    public ProfileDialog(Shell parent, Auth auth, String profileName) {
        super(parent);
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
        this.auth = auth;
        this.profileName = profileName;
        this.loadAllActions();
        this.unselectedActions = new ArrayList<Action>(this.allActions.size());
    }

    private void loadAllActions() {
        boolean isLocalAdmin = this.getAuthService().currentUserHasRole(new String[]{"ROLE_LOCAL_ADMIN"});
        if (isLocalAdmin) {
            this.loadAllLocalAdminActions();
        } else {
            this.allActions = Arrays.asList(ActionRightIDs.getAllRightIDs());
        }
    }

    private void loadAllLocalAdminActions() {
        List<String> allRightIds = Arrays.asList(ActionRightIDs.getAllRightIDs());
        this.allActions = new ArrayList<String>(allRightIds.size());
        for (String rightId : allRightIds) {
            if (!this.getRightService().isEnabled(rightId)) continue;
            this.allActions.add(rightId);
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.ProfileDialog_0);
    }

    protected Control createDialogArea(Composite parent) {
        int numColumnsCombo = 4;
        int numColumns4ColComposite = 3;
        int minWidthGridLayout = 200;
        int gridDataHeightCharacterAmount = 20;
        int gridDataWidthCharacterAmount = 40;
        this.setTitle(Messages.ProfileDialog_1);
        this.setMessage(Messages.ProfileDialog_2);
        this.setTitleImage(ImageCache.getInstance().getImage("profile_64.png"));
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 4);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        Composite comboComposite = new Composite(composite, 0);
        GridData gridData = new GridData(4, 0, true, false);
        gridData.horizontalAlignment = 256;
        comboComposite.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout(4, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        comboComposite.setLayout((Layout)gridLayout);
        Label label = new Label(comboComposite, 64);
        label.setText(Messages.ProfileDialog_3);
        this.textName = new Text(comboComposite, 2048);
        gridData = new GridData(512);
        gridData.minimumWidth = 200;
        this.textName.setLayoutData((Object)gridData);
        Label labelTranslated = new Label(comboComposite, 64);
        labelTranslated.setText(Messages.ProfileDialog_4);
        this.translated = new Label(comboComposite, 64);
        Composite fourColumnComposite = new Composite(composite, 0);
        gridData = new GridData(4, 4, true, true);
        gridData.heightHint = this.convertHeightInCharsToPixels(20);
        fourColumnComposite.setLayoutData((Object)gridData);
        gridLayout = new GridLayout(3, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        fourColumnComposite.setLayout((Layout)gridLayout);
        Composite leftComposite = new Composite(fourColumnComposite, 0);
        gridData = new GridData(4, 4, true, true);
        gridData.widthHint = this.convertWidthInCharsToPixels(40);
        leftComposite.setLayoutData((Object)gridData);
        gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        leftComposite.setLayout((Layout)gridLayout);
        Composite centerComposite = new Composite(fourColumnComposite, 0);
        gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        centerComposite.setLayout((Layout)gridLayout);
        centerComposite.setLayoutData((Object)new GridData(0x1000000, 128, false, false));
        Composite rightComposite = new Composite(fourColumnComposite, 0);
        gridData = new GridData(4, 4, true, true);
        gridData.widthHint = this.convertWidthInCharsToPixels(40);
        rightComposite.setLayoutData((Object)gridData);
        gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        rightComposite.setLayout((Layout)gridLayout);
        this.tableSelected = this.createTable(leftComposite, Messages.ProfileDialog_5);
        this.tableSelected.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.tableSelected.setComparator((ViewerComparator)new ActionTableComparator());
        this.tableSelected.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.tableSelected.refresh(true);
        this.table = this.createTable(rightComposite, Messages.ProfileDialog_6);
        this.table.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.table.setComparator((ViewerComparator)new ActionTableComparator());
        this.table.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.table.refresh(true);
        this.createButtons(centerComposite);
        this.initializeContent();
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    private void initializeContent() {
        this.loadProfiles(this.profileName);
        this.tableSelected.setInput(this.selectedActions);
        this.setUnselected();
        this.table.setInput(this.unselectedActions);
    }

    private void loadProfiles(String profileName) {
        this.table.remove(this.unselectedActions);
        this.tableSelected.remove(this.selectedActions);
        if (profileName != null) {
            for (Profile prf : this.auth.getProfiles().getProfile()) {
                if (!profileName.equals(prf.getName())) continue;
                this.profile = prf;
                this.selectedActions = prf.getAction();
                this.selectedActionsOld = new ArrayList<Action>(this.selectedActions);
                this.textName.setText(prf.getName());
                this.profileNameOld = prf.getName();
                this.translated.setText(this.getRightService().getMessage(prf.getName()));
                break;
            }
        } else {
            this.profile = new Profile();
            this.selectedActions = this.profile.getAction();
        }
        this.setUnselected();
        this.table.setInput(this.unselectedActions);
        this.tableSelected.setInput(this.selectedActions);
        this.table.refresh(true);
        this.tableSelected.refresh(true);
        this.removeAllButton.setEnabled(!this.selectedActions.isEmpty());
        this.addAllButton.setEnabled(!this.unselectedActions.isEmpty());
    }

    private void setUnselected() {
        HashMap<String, String> mapSelected = new HashMap<String, String>(this.allActions.size());
        for (Action action : this.selectedActions) {
            mapSelected.put(action.getId(), action.getId());
        }
        this.unselectedActions.clear();
        for (String name : this.allActions) {
            if (mapSelected.containsKey(name)) continue;
            Action action = new Action();
            action.setId(name);
            this.unselectedActions.add(action);
        }
    }

    protected void okPressed() {
        if (this.validateInput()) {
            this.saveProfile();
        } else {
            this.showValidationWarning();
        }
    }

    private void saveProfile() {
        try {
            if (this.profile != null) {
                this.profile.setName(this.textName.getText());
            }
            if (this.isNewProfile()) {
                this.profile.setCreator(this.getAuthService().getUsername());
                this.auth.getProfiles().getProfile().add(this.profile);
            } else if (!this.profile.getName().equals(this.profileName)) {
                this.updateProfileRefs();
            }
            this.getRightService().updateConfiguration(this.auth);
            super.okPressed();
        }
        catch (Exception e) {
            String message = "Error while saving profiles.";
            LOG.error((Object)"Error while saving profiles.", (Throwable)e);
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)"Error while saving profiles.");
        }
    }

    private boolean isNewProfile() {
        return this.profileName == null;
    }

    private void showValidationWarning() {
        MessageDialog.openWarning((Shell)this.getShell(), (String)Messages.ProfileDialog_12, (String)Messages.ProfileDialog_13);
        this.textName.selectAll();
        this.textName.setFocus();
    }

    private boolean validateInput() {
        String input = this.textName.getText();
        String trimmedInput = null;
        if (input != null) {
            trimmedInput = input.trim();
        }
        return StringUtils.isNotEmpty(trimmedInput);
    }

    protected void cancelPressed() {
        if (this.profile != null && this.profileNameOld != null) {
            this.profile.setName(this.profileNameOld);
            this.profile.getAction().clear();
            for (Action action : this.selectedActionsOld) {
                this.profile.getAction().add(action);
            }
        }
        super.cancelPressed();
    }

    private void updateProfileRefs() {
        for (Userprofile userprofile : this.auth.getUserprofiles().getUserprofile()) {
            for (ProfileRef profileRef : userprofile.getProfileRef()) {
                if (!profileRef.getName().equals(this.profileName)) continue;
                profileRef.setName(this.profile.getName());
            }
        }
    }

    private TableViewer createTable(Composite parent, String title) {
        Label label = new Label(parent, 64);
        label.setText(title);
        label.setLayoutData((Object)new GridData(4, 128, true, false));
        TableViewer table0 = new TableViewer(parent, 2818);
        GridData gd = new GridData(4, 4, true, true);
        table0.getControl().setLayoutData((Object)gd);
        table0.setUseHashlookup(true);
        return table0;
    }

    private void createButtons(Composite parent) {
        Label spacer = new Label(parent, 0);
        spacer.setLayoutData((Object)new GridData(4, 128, true, false));
        final Button addButton = new Button(parent, 8);
        addButton.setLayoutData((Object)new GridData(4, 128, true, false));
        addButton.setText(Messages.ProfileDialog_7);
        addButton.setEnabled(!this.table.getSelection().isEmpty());
        this.addAllButton = new Button(parent, 8);
        this.addAllButton.setLayoutData((Object)new GridData(4, 128, true, false));
        this.addAllButton.setText(Messages.ProfileDialog_8);
        this.addAllButton.setEnabled(!this.unselectedActions.isEmpty());
        final Button removeButton = new Button(parent, 8);
        removeButton.setLayoutData((Object)new GridData(4, 128, true, false));
        removeButton.setText(Messages.ProfileDialog_9);
        removeButton.setEnabled(!this.table.getSelection().isEmpty());
        this.removeAllButton = new Button(parent, 8);
        this.removeAllButton.setLayoutData((Object)new GridData(0x1000000, 128, false, false));
        this.removeAllButton.setText(Messages.ProfileDialog_10);
        this.removeAllButton.setEnabled(!this.selectedActions.isEmpty());
        this.table.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                addButton.setEnabled(!event.getSelection().isEmpty());
            }
        });
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProfileDialog.this.addSelection();
                ProfileDialog.this.removeAllButton.setEnabled(true);
                ProfileDialog.this.addAllButton.setEnabled(!ProfileDialog.this.table.getSelection().isEmpty());
            }
        });
        this.table.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ProfileDialog.this.addSelection();
                ProfileDialog.this.removeAllButton.setEnabled(true);
                ProfileDialog.this.addAllButton.setEnabled(!ProfileDialog.this.table.getSelection().isEmpty());
            }
        });
        this.tableSelected.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                removeButton.setEnabled(!event.getSelection().isEmpty());
            }
        });
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProfileDialog.this.removeSelection();
                ProfileDialog.this.addAllButton.setEnabled(true);
                ProfileDialog.this.removeAllButton.setEnabled(!ProfileDialog.this.selectedActions.isEmpty());
            }
        });
        this.tableSelected.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ProfileDialog.this.removeSelection();
                ProfileDialog.this.addAllButton.setEnabled(true);
                ProfileDialog.this.removeAllButton.setEnabled(!ProfileDialog.this.selectedActions.isEmpty());
            }
        });
        this.addAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProfileDialog.this.selectedActions.addAll(ProfileDialog.this.unselectedActions);
                ProfileDialog.this.unselectedActions.clear();
                ProfileDialog.this.table.refresh();
                ProfileDialog.this.tableSelected.refresh();
                ProfileDialog.this.addAllButton.setEnabled(false);
                ProfileDialog.this.removeAllButton.setEnabled(true);
                ProfileDialog.this.profile.setOrigin(null);
            }
        });
        this.removeAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProfileDialog.this.unselectedActions.addAll(ProfileDialog.this.selectedActions);
                ProfileDialog.this.selectedActions.clear();
                ProfileDialog.this.table.refresh();
                ProfileDialog.this.tableSelected.refresh();
                ProfileDialog.this.removeAllButton.setEnabled(false);
                ProfileDialog.this.addAllButton.setEnabled(true);
                ProfileDialog.this.profile.setOrigin(null);
            }
        });
    }

    private void addSelection() {
        IStructuredSelection selection = (IStructuredSelection)this.table.getSelection();
        List selectionList = selection.toList();
        this.selectedActions.addAll(selectionList);
        this.unselectedActions.removeAll(selectionList);
        Object[] selectedElements = selection.toArray();
        this.tableSelected.add(selectedElements);
        this.table.remove(selectedElements);
        this.tableSelected.setSelection((ISelection)selection);
        this.table.getControl().setFocus();
        this.profile.setOrigin(null);
    }

    private void removeSelection() {
        IStructuredSelection selection = (IStructuredSelection)this.tableSelected.getSelection();
        List selectionList = selection.toList();
        this.selectedActions.removeAll(selectionList);
        this.unselectedActions.addAll(selectionList);
        Object[] selectedElements = selection.toArray();
        this.table.add(selectedElements);
        this.tableSelected.remove(selectedElements);
        this.table.setSelection((ISelection)selection);
        this.tableSelected.getControl().setFocus();
        this.profile.setOrigin(null);
    }

    public Auth getAuth() {
        return this.auth;
    }

    IRightsServiceClient getRightService() {
        if (this.rightsService == null) {
            this.rightsService = (IRightsServiceClient)VeriniceContext.get((String)"rightsService");
        }
        return this.rightsService;
    }

    IAuthService getAuthService() {
        if (this.authService == null) {
            this.authService = (IAuthService)VeriniceContext.get((String)"authService");
        }
        return this.authService;
    }

    class ActionTableComparator
    extends ViewerComparator {
        private int propertyIndex = 0;
        private static final int ASCENDING = 0;
        private static final int DESCENDING = 1;
        private int direction = 0;
        private Collator collator = Collator.getInstance();

        public int getDirection() {
            return this.direction == 1 ? 1024 : 128;
        }

        public void setColumn(int column) {
            if (column == this.propertyIndex) {
                this.direction = 1 - this.direction;
            } else {
                this.propertyIndex = column;
                this.direction = 1;
            }
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            Action p1 = (Action)e1;
            Action p2 = (Action)e2;
            int rc = 0;
            switch (this.propertyIndex) {
                case 0: {
                    rc = this.collator.compare(ProfileDialog.this.getRightService().getMessage(p1.getId()), ProfileDialog.this.getRightService().getMessage(p2.getId()));
                    break;
                }
                default: {
                    rc = 0;
                }
            }
            if (this.direction == 1) {
                rc = -rc;
            }
            return rc;
        }
    }
}

