/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.rcp;

import java.io.File;
import java.net.MalformedURLException;
import java.util.Collection;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.jface.preference.IPreferenceStore;
import sernet.gs.ui.rcp.main.Activator;
import sernet.hui.common.connect.HitroUtil;
import sernet.snutils.TagHelper;

public final class Preferences {
    private static final Logger LOG = Logger.getLogger(Preferences.class);

    private Preferences() {
    }

    public static boolean isStandalone() {
        return "gs_cna_operationmode_standalone".equals(Preferences.getPreferenceStore().getString("gs_cna_operationmode"));
    }

    public static boolean isServerMode() {
        return "gs_cna_operationmode_withserver".equals(Preferences.getPreferenceStore().getString("gs_cna_operationmode"));
    }

    public static boolean isBpCatalogLoadedFromZipFile() {
        return Preferences.getPreferenceStore().getString("cna_gsaccess").equals("cna_gsaccess_zip");
    }

    public static String getBpCatalogFilePath() {
        String bpCatalogFilePath = null;
        if (Preferences.isBpCatalogLoadedFromZipFile()) {
            bpCatalogFilePath = Preferences.getPreferenceStore().getString("cna_bsizipfile");
        } else {
            bpCatalogFilePath = Preferences.getPreferenceStore().getString("cna_bsiurl");
            try {
                bpCatalogFilePath = new File(bpCatalogFilePath).toURI().toURL().toString();
            }
            catch (MalformedURLException e) {
                LOG.error((Object)"Error while getting base protection catalog file path.", (Throwable)e);
            }
        }
        return bpCatalogFilePath;
    }

    public static boolean isModelSafeguardsActive() {
        return Preferences.getPreferenceStore().getBoolean("bp_model_safeguards");
    }

    public static boolean isModelDummySafeguardsActive() {
        return Preferences.getPreferenceStore().getBoolean("bp_model_dummy_safeguards");
    }

    public static String getServerUrl() {
        return Preferences.getPreferenceStore().getString("gs_cna_vnserver_uri");
    }

    private static IPreferenceStore getPreferenceStore() {
        return Activator.getDefault().getPreferenceStore();
    }

    public static final String[] getEditorTags() {
        String tagString = Preferences.getPreferenceStore().getString("hui_tags");
        String[] tags = null;
        if ("hui_tags_all".equals(tagString)) {
            Set allTagsSet = HitroUtil.getInstance().getTypeFactory().getAllTags();
            Collection tagsExcludedByDefault = TagHelper.getTags((String)Preferences.getPreferenceStore().getString("hui_tags_default_excluded"));
            tags = (String[])allTagsSet.stream().filter(tag -> !tagsExcludedByDefault.contains(tag)).toArray(String[]::new);
        } else {
            tags = (String[])TagHelper.getTags((String)tagString).stream().toArray(String[]::new);
        }
        return tags;
    }
}

