/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.rcp;

import org.apache.log4j.Logger;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.WorkbenchException;
import sernet.gs.ui.rcp.main.Activator;
import sernet.gs.ui.rcp.main.preferences.PreferenceConstants;
import sernet.verinice.rcp.IAttachedToPerspective;
import sernet.verinice.rcp.Messages;

public class PerspectiveSwitcher
implements IStartup,
IPartListener {
    private static final Logger LOG = Logger.getLogger(PerspectiveSwitcher.class);

    public void earlyStartup() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().addPartListener((IPartListener)new PerspectiveSwitcher());
                }
                catch (Exception e) {
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        });
    }

    public void partActivated(IWorkbenchPart part) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("partActivated: " + part.getTitle()));
        }
    }

    public void partBroughtToTop(IWorkbenchPart part) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("partBroughtToTop: " + part.getTitle()));
        }
    }

    public void partClosed(IWorkbenchPart part) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("partClosed: " + part.getTitle()));
        }
    }

    public void partDeactivated(IWorkbenchPart part) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("partDeactivated: " + part.getTitle()));
        }
    }

    public void partOpened(final IWorkbenchPart part) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("partOpened: " + part.getTitle()));
        }
        if (part instanceof IAttachedToPerspective && ((IAttachedToPerspective)part).getPerspectiveId() != null) {
            final IWorkbenchWindow workbenchWindow = part.getSite().getPage().getWorkbenchWindow();
            final String attachedPerspectiveId = ((IAttachedToPerspective)part).getPerspectiveId();
            IPerspectiveDescriptor activePerspective = workbenchWindow.getActivePage().getPerspective();
            if (activePerspective == null || !activePerspective.getId().equals(attachedPerspectiveId)) {
                Display.getCurrent().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (PerspectiveSwitcher.this.reallySwitch(part.getClass())) {
                            try {
                                workbenchWindow.getWorkbench().showPerspective(attachedPerspectiveId, workbenchWindow);
                            }
                            catch (WorkbenchException e) {
                                LOG.error((Object)(String.valueOf(Messages.PerspectiveSwitcher_5) + attachedPerspectiveId), (Throwable)e);
                            }
                        }
                    }
                });
            }
        }
    }

    private boolean reallySwitch(Class<? extends IWorkbenchPart> clazz) {
        IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();
        boolean askNot = preferenceStore.getBoolean(PreferenceConstants.getDontAskBeforeSwitch(clazz));
        boolean doSwitch = "always".equals(preferenceStore.getString(PreferenceConstants.getSwitch(clazz)));
        if (!askNot) {
            MessageDialogWithToggle dialog = MessageDialogWithToggle.openYesNoCancelQuestion((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)Messages.PerspectiveSwitcher_6, (String)Messages.PerspectiveSwitcher_7, (String)Messages.PerspectiveSwitcher_8, (boolean)false, (IPreferenceStore)Activator.getDefault().getPreferenceStore(), (String)PreferenceConstants.getSwitch(clazz));
            boolean bl = doSwitch = dialog.getReturnCode() == 0 || dialog.getReturnCode() == 2;
            if (dialog.getToggleState()) {
                preferenceStore.setValue(PreferenceConstants.getDontAskBeforeSwitch(clazz), true);
                if (dialog.getReturnCode() == 3) {
                    preferenceStore.setValue(PreferenceConstants.getSwitch(clazz), "never");
                }
            }
        }
        return doSwitch;
    }
}

