/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.rcp;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import sernet.verinice.interfaces.CommandException;
import sernet.verinice.rcp.Messages;

public abstract class MultiselectWidget<T> {
    private static final Logger LOG = Logger.getLogger(MultiselectWidget.class);
    protected List<T> itemList;
    private ITreeSelection selection;
    private T selectedElement;
    protected Set<T> selectedElementSet = new HashSet<T>();
    protected Set<T> preSelectedElements = new HashSet<T>(10);
    protected boolean showOnlySelected = true;
    protected boolean showOnlySelectedCheckbox = true;
    protected boolean showFilterTextfield = true;
    protected boolean showSelectAllCheckbox = false;
    protected boolean showDeselectAllCheckbox = false;
    protected String filterString = null;
    protected Text filter;
    protected Group group;
    protected ScrolledComposite scrolledComposite;
    protected Composite innerComposite;
    private Map<T, Button> checkboxMap;
    private Button checkboxOnlySelected;
    private Button buttonSelectAll;
    private Button buttonDeselectAll;
    private SelectionListener organizationListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            Button checkbox = (Button)e.getSource();
            MultiselectWidget.this.selectedElement = checkbox.getData();
            if (checkbox.getSelection()) {
                MultiselectWidget.this.selectedElementSet.add(MultiselectWidget.this.selectedElement);
                MultiselectWidget.this.preSelectedElements.add(MultiselectWidget.this.selectedElement);
            } else {
                MultiselectWidget.this.selectedElementSet.remove(MultiselectWidget.this.selectedElement);
                MultiselectWidget.this.preSelectedElements.remove(MultiselectWidget.this.selectedElement);
            }
            super.widgetSelected(e);
        }
    };
    private String title;

    protected MultiselectWidget() {
    }

    public MultiselectWidget(Composite parent) {
        try {
            this.initData();
            this.initGui(parent);
        }
        catch (CommandException e) {
            String message = "Error while creating widget.";
            LOG.error((Object)message, (Throwable)e);
            throw new RuntimeException(message, e);
        }
    }

    public MultiselectWidget(Composite parent, ITreeSelection selection) throws CommandException {
        this.selection = selection;
        this.initData();
        this.initGui(parent);
    }

    public MultiselectWidget(Composite parent, T selectedElement) throws CommandException {
        this.selectedElement = selectedElement;
        this.initData();
        this.initGui(parent);
    }

    public MultiselectWidget(Composite parent, ITreeSelection selection, T selectedElement) throws CommandException {
        this.selection = selection;
        this.selectedElement = selectedElement;
        this.initData();
        this.initGui(parent);
    }

    protected void initGui(Composite parent) {
        int gdMinimumWidth = 550;
        int gdHeightHint = 200;
        this.createFilterPanel(parent);
        this.group = new Group(parent, 0);
        if (this.getTitle() != null) {
            this.group.setText(this.getTitle());
        }
        GridLayout groupOrganizationLayout = new GridLayout(1, true);
        this.group.setLayout((Layout)groupOrganizationLayout);
        GridData gd = new GridData(4, 4, true, true);
        gd.minimumWidth = 550;
        gd.heightHint = 200;
        this.group.setLayoutData((Object)gd);
        this.scrolledComposite = new ScrolledComposite((Composite)this.group, 512);
        this.scrolledComposite.setLayoutData((Object)new GridData(1808));
        this.scrolledComposite.setExpandHorizontal(true);
        this.innerComposite = new Composite((Composite)this.scrolledComposite, 0);
        this.scrolledComposite.setContent((Control)this.innerComposite);
        this.innerComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        this.innerComposite.setLayout((Layout)new GridLayout(1, false));
        if (this.selection != null && !this.selection.isEmpty()) {
            Iterator iter = this.selection.iterator();
            while (iter.hasNext()) {
                this.preSelectedElements.add(iter.next());
            }
        } else if (this.selectedElement != null) {
            this.preSelectedElements.add(this.selectedElement);
        }
        this.checkboxMap = new HashMap<T, Button>();
        this.addCheckboxes();
    }

    private void createFilterPanel(Composite parent) {
        if (this.isToolbarVisible()) {
            Composite filterComp = this.createFilterComposite(parent);
            if (this.isShowFilterTextfield()) {
                this.createFilterTextfield(filterComp);
            }
            if (this.isShowOnlySelectedCheckbox()) {
                this.createSelectedCheckbox(filterComp);
            }
            if (this.isShowDeselectAllCheckbox()) {
                this.createDeselectAllButton(filterComp);
            }
            if (this.isShowSelectAllCheckbox()) {
                this.createSelectAllButton(filterComp);
            }
        }
    }

    private boolean isToolbarVisible() {
        return this.isShowFilterTextfield() || this.isShowOnlySelectedCheckbox() || this.isShowSelectAllCheckbox();
    }

    private void createFilterTextfield(Composite filterComp) {
        Label label = new Label(filterComp, 0);
        label.setText(Messages.MultiselectWidget_1);
        this.filter = new Text(filterComp, 2048);
        GridData gridData = new GridData(4, 0, true, false);
        this.filter.setLayoutData((Object)gridData);
        this.filter.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                MultiselectWidget.this.filterString = MultiselectWidget.this.filter.getText();
                if (MultiselectWidget.this.filterString != null) {
                    MultiselectWidget.this.filterString = MultiselectWidget.this.filterString.trim();
                    if (MultiselectWidget.this.filterString.isEmpty()) {
                        MultiselectWidget.this.filterString = null;
                    }
                }
                MultiselectWidget.this.removeCheckboxes();
                MultiselectWidget.this.addCheckboxes();
            }

            public void keyPressed(KeyEvent e) {
            }
        });
    }

    private void createSelectedCheckbox(Composite filterComp) {
        this.checkboxOnlySelected = new Button(filterComp, 32);
        this.checkboxOnlySelected.setText(Messages.MultiselectWidget_3);
        this.checkboxOnlySelected.setSelection(this.showOnlySelected);
        this.checkboxOnlySelected.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MultiselectWidget.this.showOnlySelected = MultiselectWidget.this.checkboxOnlySelected.getSelection();
                MultiselectWidget.this.removeCheckboxes();
                MultiselectWidget.this.addCheckboxes();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void createSelectAllButton(Composite composite) {
        this.buttonSelectAll = new Button(composite, 8);
        this.configureToggleButton(composite, this.buttonSelectAll, Messages.MultiselectWidget_SelectAll);
        this.buttonSelectAll.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                for (Object item : MultiselectWidget.this.checkboxMap.keySet()) {
                    Button checkbox = MultiselectWidget.this.checkboxMap.get(item);
                    checkbox.setSelection(true);
                    MultiselectWidget.this.selectedElement = item;
                    MultiselectWidget.this.selectedElementSet.add(item);
                    MultiselectWidget.this.preSelectedElements.add(item);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void createDeselectAllButton(Composite composite) {
        this.buttonDeselectAll = new Button(composite, 8);
        this.configureToggleButton(composite, this.buttonDeselectAll, Messages.MultiselectWidget_Deselect_All);
        this.buttonDeselectAll.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                for (Object item : MultiselectWidget.this.checkboxMap.keySet()) {
                    Button checkbox = MultiselectWidget.this.checkboxMap.get(item);
                    checkbox.setSelection(false);
                }
                MultiselectWidget.this.selectedElement = null;
                MultiselectWidget.this.selectedElementSet.clear();
                MultiselectWidget.this.preSelectedElements.clear();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void configureToggleButton(Composite composite, Button button, String text) {
        button.setText(text);
        GridData gridData = new GridData();
        gridData.widthHint = 120;
        button.setLayoutData((Object)gridData);
    }

    protected void addCheckboxes() {
        for (T item : this.itemList) {
            if (!this.isItemVisible(item)) continue;
            boolean selected = this.preSelectedElements.contains(item);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(String.valueOf(item.toString()) + " is visible, select state is: " + selected));
            }
            Button checkbox = new Button(this.innerComposite, 32);
            checkbox.setText(this.getLabel(item));
            checkbox.setData(item);
            checkbox.addSelectionListener(this.organizationListener);
            if (selected) {
                checkbox.setSelection(true);
                this.selectedElement = item;
                this.selectedElementSet.add(item);
            }
            if (this.itemList.size() == 1) {
                checkbox.setSelection(true);
                this.selectedElement = item;
                this.selectedElementSet.add(item);
            }
            this.checkboxMap.put(item, checkbox);
        }
        this.scrolledComposite.setVisible(true);
        Point size = this.innerComposite.computeSize(-1, -1);
        size.y += this.itemList.size() * 2;
        this.innerComposite.setSize(size);
        this.group.layout();
    }

    protected boolean isItemVisible(T item) {
        boolean containsFilter;
        boolean selected = this.preSelectedElements.contains(item);
        String itemLabel = this.getLabel(item);
        boolean bl = containsFilter = this.filterString == null || itemLabel.toLowerCase().contains(this.filterString.toLowerCase());
        return (!this.isShowOnlySelected() || selected) && containsFilter;
    }

    protected void removeCheckboxes() {
        this.removeListenerFromCheckboxes(this.organizationListener);
        for (Button checkbox : this.checkboxMap.values()) {
            checkbox.dispose();
        }
        this.checkboxMap.clear();
    }

    protected void removeListenerFromCheckboxes(SelectionListener listener) {
        for (Button checkbox : this.checkboxMap.values()) {
            checkbox.removeSelectionListener(listener);
        }
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    protected abstract String getLabel(T var1);

    protected abstract void initData() throws CommandException;

    private Composite createFilterComposite(Composite composite) {
        Composite comboComposite = new Composite(composite, 0);
        GridData gridData = new GridData(4, 0, true, false);
        comboComposite.setLayoutData((Object)gridData);
        GridLayout gridLayout = new GridLayout(4, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        comboComposite.setLayout((Layout)gridLayout);
        return comboComposite;
    }

    public void setShowOnlySelected(boolean showOnlySelected) {
        this.showOnlySelected = showOnlySelected;
    }

    public void setShowOnlySelectedCheckbox(boolean showOnlySelectedCheckbox) {
        this.showOnlySelectedCheckbox = showOnlySelectedCheckbox;
    }

    public boolean isShowOnlySelected() {
        return this.showOnlySelected;
    }

    public boolean isShowOnlySelectedCheckbox() {
        return this.showOnlySelectedCheckbox;
    }

    public boolean isShowFilterTextfield() {
        return this.showFilterTextfield;
    }

    public boolean isShowSelectAllCheckbox() {
        return this.showSelectAllCheckbox;
    }

    public void setShowSelectAllButton(boolean showSelectAllCheckbox) {
        this.showSelectAllCheckbox = showSelectAllCheckbox;
    }

    public boolean isShowDeselectAllCheckbox() {
        return this.showDeselectAllCheckbox;
    }

    public void setShowDeselectAllButton(boolean showDeselectAllCheckbox) {
        this.showDeselectAllCheckbox = showDeselectAllCheckbox;
    }

    public void addSelectionListener(SelectionListener listener) {
        if (listener == null) {
            return;
        }
        if (this.checkboxMap != null) {
            for (Button checkbox : this.checkboxMap.values()) {
                checkbox.addSelectionListener(listener);
            }
        }
        if (this.buttonSelectAll != null) {
            this.buttonSelectAll.addSelectionListener(listener);
        }
        if (this.buttonDeselectAll != null) {
            this.buttonDeselectAll.addSelectionListener(listener);
        }
    }

    public void removeSelectionListener(SelectionListener listener) {
        if (listener == null) {
            return;
        }
        if (this.checkboxMap != null) {
            for (Button checkbox : this.checkboxMap.values()) {
                checkbox.removeSelectionListener(listener);
            }
        }
        if (this.buttonSelectAll != null) {
            this.buttonSelectAll.removeSelectionListener(listener);
        }
        if (this.buttonDeselectAll != null) {
            this.buttonDeselectAll.removeSelectionListener(listener);
        }
    }

    protected abstract List<T> sortItems(List<T> var1);

    public T getSelectedElement() {
        return this.selectedElement;
    }

    public void setSelectedElement(T selectedElement) {
        this.selectedElement = selectedElement;
    }

    public Set<T> getSelectedElementSet() {
        return this.selectedElementSet;
    }

    public void deselectCheckboxForElement(T element) {
        this.setSelectionForElement(element, false);
    }

    public void selectCheckboxForElement(T element) {
        this.setSelectionForElement(element, false);
    }

    private void setSelectionForElement(T element, boolean selection) {
        Button checkbox = this.checkboxMap.get(element);
        if (checkbox != null) {
            checkbox.setSelection(selection);
        }
    }
}

