/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.rcp;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Arrays;
import org.apache.log4j.Logger;
import org.eclipse.jface.viewers.OwnerDrawLabelProvider;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TableItem;
import sernet.gs.ui.rcp.main.ExceptionUtil;
import sernet.gs.ui.rcp.main.bsi.views.FileView;
import sernet.gs.ui.rcp.main.service.ServiceFactory;
import sernet.verinice.interfaces.ICommand;
import sernet.verinice.interfaces.ICommandService;
import sernet.verinice.model.bsi.Attachment;
import sernet.verinice.model.bsi.AttachmentFile;
import sernet.verinice.service.commands.LoadAttachmentFile;

public abstract class ImageCellProvider
extends OwnerDrawLabelProvider {
    private static final Logger LOG = Logger.getLogger(ImageCellProvider.class);
    public static final Object EMPTY_CACHE_ELEMENT = new Object();
    private int thumbSize;
    private ICommandService commandService;

    protected ImageCellProvider(int thumbnailSize) {
        this.thumbSize = thumbnailSize;
    }

    protected void paint(Event event, Object element) {
        long start = System.currentTimeMillis();
        if (this.thumbSize > 0) {
            Image img = this.getImage(element);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("get image: " + (System.currentTimeMillis() - start)));
            }
            if (img != null) {
                int imgWidth = img.getBounds().width;
                int imgHeight = img.getBounds().height;
                Rectangle tableItemBounds = ((TableItem)event.item).getBounds(event.index);
                int cellWidth = tableItemBounds.width;
                int cellHeight = tableItemBounds.height;
                cellWidth /= 2;
                cellHeight /= 2;
                int x = (cellWidth -= imgWidth / 2) > 0 ? tableItemBounds.x + cellWidth : tableItemBounds.x;
                int y = cellHeight > 0 ? tableItemBounds.y + (cellHeight -= imgHeight / 2) : tableItemBounds.y;
                event.gc.drawImage(img, 0, 0, imgWidth, imgHeight, x, y, imgWidth, imgHeight);
                img.dispose();
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("paint: " + (System.currentTimeMillis() - start)));
        }
    }

    protected void measure(Event arg0, Object arg1) {
    }

    protected abstract Image getImage(Object var1);

    protected byte[] loadFileData(Attachment attachment) {
        if (Arrays.asList(Attachment.getImageMimeTypes()).contains(attachment.getMimeType())) {
            try {
                LoadAttachmentFile command = new LoadAttachmentFile(attachment.getDbId(), Integer.valueOf(this.thumbSize));
                command = (LoadAttachmentFile)this.getCommandService().executeCommand((ICommand)command);
                AttachmentFile attachmentFile = command.getAttachmentFile();
                if (attachmentFile != null) {
                    return attachmentFile.getFileData();
                }
            }
            catch (Exception e) {
                LOG.error((Object)"Error while loading attachment", (Throwable)e);
                ExceptionUtil.log(e, "Error while loading attachment");
            }
        }
        return null;
    }

    protected Image createImage(byte[] fileData) {
        if (fileData == null) {
            return null;
        }
        try {
            return new Image((Device)FileView.getDisplay(), (InputStream)new ByteArrayInputStream(fileData));
        }
        catch (Exception e) {
            LOG.error((Object)"Error while creating SWT image", (Throwable)e);
            return null;
        }
    }

    public int getThumbSize() {
        return this.thumbSize;
    }

    public void setThumbSize(int thumbSize) {
        this.thumbSize = thumbSize;
    }

    public ICommandService getCommandService() {
        if (this.commandService == null) {
            this.commandService = this.createCommandServive();
        }
        return this.commandService;
    }

    private ICommandService createCommandServive() {
        return ServiceFactory.lookupCommandService();
    }

    public void dispose() {
        super.dispose();
    }
}

