/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.rcp;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.nebula.widgets.gallery.AbstractGalleryGroupRenderer;
import org.eclipse.nebula.widgets.gallery.AbstractGalleryItemRenderer;
import org.eclipse.nebula.widgets.gallery.DefaultGalleryItemRenderer;
import org.eclipse.nebula.widgets.gallery.Gallery;
import org.eclipse.nebula.widgets.gallery.GalleryItem;
import org.eclipse.nebula.widgets.gallery.NoGroupRenderer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.Bundle;
import sernet.verinice.iso27k.rcp.ComboModel;
import sernet.verinice.rcp.IconFileFilter;
import sernet.verinice.rcp.IconPathDescriptor;
import sernet.verinice.rcp.Messages;

public class IconSelectDialog
extends Dialog {
    private static final Logger LOG = Logger.getLogger(IconSelectDialog.class);
    public static final String ICON_DIRECTORY = "tree-icons";
    private static final DirectoryStream.Filter<java.nio.file.Path> ICON_FILE_FILTER = new IconFileFilter();
    private static final int ICON_SPACING = 6;
    private static final int THUMBNAIL_SIZE = 25;
    private Combo dirCombo;
    private ComboModel<IconPathDescriptor> dirComboModel;
    private IconPathDescriptor directory;
    private String selectedPath;
    private boolean defaultIcon = false;

    protected IconSelectDialog(Shell parentShell) {
        super(parentShell);
        this.initComboValues();
    }

    private void initComboValues() {
        this.dirComboModel = new ComboModel<IconPathDescriptor>(IconPathDescriptor::getName);
        URL[] inconUrlArray = FileLocator.findEntries((Bundle)Platform.getBundle((String)"sernet.gs.ui.rcp.main"), (IPath)new Path(ICON_DIRECTORY), null);
        try {
            URL[] uRLArray = inconUrlArray;
            int n = inconUrlArray.length;
            int n2 = 0;
            while (n2 < n) {
                String[] directories;
                URL inconUrl = uRLArray[n2];
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Icon dir: " + inconUrl));
                }
                URL realFileUrl = FileLocator.toFileURL((URL)inconUrl);
                String urlString = realFileUrl.toExternalForm();
                urlString = urlString.replace(" ", "%20");
                File baseDir = new File(URI.create(urlString));
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Icon dir (file system): " + baseDir.getPath()));
                }
                String[] stringArray = directories = baseDir.list((FilenameFilter)DirectoryFileFilter.INSTANCE);
                int n3 = directories.length;
                int n4 = 0;
                while (n4 < n3) {
                    String dir = stringArray[n4];
                    if (!dir.startsWith(".")) {
                        this.dirComboModel.add(new IconPathDescriptor(dir, String.valueOf(baseDir.getPath()) + File.separator + dir));
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error while reading icon directory: tree-icons", (Throwable)e);
            return;
        }
        if (!this.dirComboModel.isEmpty()) {
            this.dirComboModel.sort();
        }
    }

    public void showComboValues() {
        this.dirCombo.setItems(this.dirComboModel.getLabelArray());
        if (this.dirComboModel.isEmpty()) {
            this.dirCombo.setEnabled(false);
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite comp = (Composite)super.createDialogArea(parent);
        Label dirLabel = new Label(comp, 0);
        dirLabel.setText(Messages.IconSelectDialog_5);
        this.dirCombo = new Combo(comp, 2572);
        GridData gd = new GridData(4, 128, true, false);
        this.dirCombo.setLayoutData((Object)gd);
        this.showComboValues();
        Group group = new Group(comp, 0);
        group.setText(Messages.IconSelectDialog_6);
        GridLayout groupOrganizationLayout = new GridLayout(1, true);
        group.setLayout((Layout)groupOrganizationLayout);
        gd = new GridData(4, 4, true, true);
        group.setLayoutData((Object)gd);
        final Gallery gallery = new Gallery((Composite)group, 512);
        GridData gd2 = new GridData(4, 4, true, true);
        gd2.widthHint = 316;
        gd2.heightHint = 285;
        gallery.setLayoutData((Object)gd2);
        NoGroupRenderer gr = new NoGroupRenderer();
        gr.setItemSize(25, 25);
        gr.setMinMargin(6);
        gallery.setGroupRenderer((AbstractGalleryGroupRenderer)gr);
        DefaultGalleryItemRenderer ir = new DefaultGalleryItemRenderer();
        ir.setShowRoundedSelectionCorners(false);
        gallery.setItemRenderer((AbstractGalleryItemRenderer)ir);
        this.dirCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IconSelectDialog.this.dirComboModel.setSelectedIndex(IconSelectDialog.this.dirCombo.getSelectionIndex());
                IconSelectDialog.this.directory = IconSelectDialog.this.dirComboModel.getSelectedObject();
                IconSelectDialog.this.loadIcons(gallery, IconSelectDialog.this.directory.getPath());
            }
        });
        gallery.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IconSelectDialog.this.selectedPath = (String)e.data;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Icon: " + IconSelectDialog.this.selectedPath));
                }
            }
        });
        if (!this.dirComboModel.isEmpty()) {
            this.dirComboModel.setSelectedIndex(2);
            this.dirCombo.select(2);
            this.directory = this.dirComboModel.getSelectedObject();
            this.loadIcons(gallery, this.directory.getPath());
        } else {
            this.loadIcons(gallery, "tree-iconssilk");
        }
        group.layout();
        final Button defaultCheckbox = new Button(comp, 32);
        defaultCheckbox.setText(Messages.IconSelectDialog_7);
        defaultCheckbox.setSelection(false);
        defaultCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IconSelectDialog.this.defaultIcon = defaultCheckbox.isEnabled();
            }
        });
        comp.pack();
        return comp;
    }

    private void loadIcons(Gallery gallery, String path) {
        java.nio.file.Path internalDirectory = Paths.get(path, new String[0]);
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (DirectoryStream<java.nio.file.Path> directoryStream = Files.newDirectoryStream(internalDirectory, ICON_FILE_FILTER);){
                Stream icons = StreamSupport.stream(directoryStream.spliterator(), false);
                gallery.removeAll();
                GalleryItem galleryGroup = new GalleryItem(gallery, 0);
                icons.sorted().forEach(icon -> {
                    try {
                        Image image = ImageDescriptor.createFromURL((URL)icon.toUri().toURL()).createImage();
                        GalleryItem item = new GalleryItem(galleryGroup, 0);
                        item.addDisposeListener(e -> image.dispose());
                        item.setData((Object)IconSelectDialog.getRelativePath(icon.toString()));
                        item.setImage(image);
                    }
                    catch (MalformedURLException e2) {
                        LOG.error((Object)("Error creating gallery item for " + icon), (Throwable)e2);
                    }
                });
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to load icons from " + path, e);
        }
    }

    private static String getRelativePath(String path) {
        String relative = path;
        if (path.contains(ICON_DIRECTORY)) {
            relative = path.substring(path.indexOf(ICON_DIRECTORY));
        }
        if (relative.contains("\\")) {
            relative = relative.replace('\\', '/');
        }
        return relative;
    }

    public String getSelectedPath() {
        return this.selectedPath;
    }

    public boolean isDefaultIcon() {
        return this.defaultIcon;
    }

    public boolean isSomethingSelected() {
        return this.defaultIcon || this.getSelectedPath() != null;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.IconSelectDialog_11);
    }
}

