/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.rcp;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import sernet.gs.ui.rcp.main.Activator;
import sernet.gs.ui.rcp.main.common.model.CnAElementFactory;
import sernet.hui.common.VeriniceContext;
import sernet.springclient.RightsServiceClient;
import sernet.verinice.interfaces.ICommand;
import sernet.verinice.interfaces.ICommandService;
import sernet.verinice.interfaces.RightEnabledUserInteraction;
import sernet.verinice.iso27k.rcp.JobScheduler;
import sernet.verinice.iso27k.rcp.Mutex;
import sernet.verinice.model.common.ChangeLogEntry;
import sernet.verinice.model.common.CnATreeElement;
import sernet.verinice.rcp.IconSelectDialog;
import sernet.verinice.rcp.Messages;
import sernet.verinice.service.commands.UpdateIcon;

public class IconSelectAction
implements IWorkbenchWindowActionDelegate,
RightEnabledUserInteraction {
    private static final Logger LOG = Logger.getLogger(IconSelectAction.class);
    private Shell shell;
    private List<CnATreeElement> selectedElments;
    private static ISchedulingRule iSchedulingRule = new Mutex();

    public void init(IWorkbenchWindow window) {
        this.shell = window.getShell();
    }

    public void run(IAction arg0) {
        try {
            final IconSelectDialog dialog = new IconSelectDialog(this.shell);
            if (dialog.open() == 0 && dialog.isSomethingSelected()) {
                WorkspaceJob updateIconJob = new WorkspaceJob(Messages.IconSelectAction_0){

                    public IStatus runInWorkspace(IProgressMonitor monitor) {
                        IStatus status = Status.OK_STATUS;
                        try {
                            monitor.setTaskName(Messages.IconSelectAction_1);
                            String iconPath = dialog.isDefaultIcon() ? null : dialog.getSelectedPath();
                            Activator.inheritVeriniceContextState();
                            IconSelectAction.this.selectedElments.forEach(el -> el.setIconPath(iconPath));
                            UpdateIcon updateIcon = new UpdateIcon(IconSelectAction.this.selectedElments.stream().map(CnATreeElement::getUuid).collect(Collectors.toSet()), iconPath, ChangeLogEntry.STATION_ID);
                            updateIcon = (UpdateIcon)IconSelectAction.this.getCommandService().executeCommand((ICommand)updateIcon);
                            for (CnATreeElement element : updateIcon.getChangedElements()) {
                                CnAElementFactory.getModel(element).childChanged(element);
                            }
                        }
                        catch (Exception e) {
                            LOG.error((Object)"Error while changing icons.", (Throwable)e);
                            status = new Status(4, "sernet.verinice.rcp", Messages.IconSelectAction_3, (Throwable)e);
                        }
                        return status;
                    }
                };
                JobScheduler.scheduleJob(updateIconJob, iSchedulingRule);
            }
        }
        catch (Exception e) {
            LOG.error((Object)Messages.IconSelectAction_4, (Throwable)e);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (action.isEnabled()) {
            action.setEnabled(this.checkRights());
        }
        if (selection instanceof ITreeSelection) {
            ITreeSelection treeSelection = (ITreeSelection)selection;
            List selectionList = treeSelection.toList();
            this.selectedElments = new ArrayList<CnATreeElement>(selectionList.size());
            for (Object object : selectionList) {
                if (!(object instanceof CnATreeElement)) continue;
                this.selectedElments.add((CnATreeElement)object);
            }
        }
    }

    public void dispose() {
    }

    public boolean checkRights() {
        Activator.inheritVeriniceContextState();
        RightsServiceClient service = (RightsServiceClient)VeriniceContext.get((String)"rightsService");
        return service.isEnabled(this.getRightID());
    }

    public String getRightID() {
        return "changeicon";
    }

    private ICommandService getCommandService() {
        return (ICommandService)VeriniceContext.get((String)"commandService");
    }
}

