/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.rcp;

import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelProvider;
import sernet.gs.ui.rcp.main.Activator;
import sernet.gs.ui.rcp.main.ImageCache;
import sernet.verinice.model.common.CnATreeElement;

public class GsmIsmDecorator
extends LabelProvider
implements ILightweightLabelDecorator {
    private static final String GSM_ISM_LEVEL_LOW = "low";
    private static final String GSM_ISM_LEVEL_MEDIUM = "medium";
    private static final String GSM_ISM_LEVEL_HIGH = "high";
    private static final String IMAGE_PATH_BLUE = "overlays/dot_blue.png";
    private static final String IMAGE_PATH_YELLOW = "overlays/dot_yellow.png";
    private static final String IMAGE_PATH_RED = "overlays/dot_red.png";
    private static final String IMAGE_PATH_EMPTY = "overlays/empty.png";

    public void decorate(Object element, IDecoration decoration) {
        Activator.inheritVeriniceContextState();
        if (element instanceof CnATreeElement && this.prefEnabled() && this.isApplicable((CnATreeElement)element)) {
            decoration.addOverlay(ImageCache.getInstance().getImageDescriptor(this.getImagePath(this.getGsmIsmLevel((CnATreeElement)element))));
        }
    }

    private boolean prefEnabled() {
        return Activator.getDefault().getPreferenceStore().getBoolean("show_gsmism_decorator");
    }

    private boolean isApplicable(CnATreeElement treeElement) {
        return "incident_scenario".equals(treeElement.getTypeId()) || "vulnerability".equals(treeElement.getTypeId());
    }

    private String getGsmIsmLevel(CnATreeElement treeElement) {
        if ("incident_scenario".equals(treeElement.getTypeId())) {
            return treeElement.getEntity().getPropertyValue("gsm_ism_scenario_level").toLowerCase();
        }
        if ("vulnerability".equals(treeElement.getTypeId())) {
            return treeElement.getEntity().getPropertyValue("gsm_ism_vulnerability_level").toLowerCase();
        }
        return "";
    }

    private String getImagePath(String gsmIsmLvl) {
        if (GSM_ISM_LEVEL_LOW.equals(gsmIsmLvl)) {
            return IMAGE_PATH_BLUE;
        }
        if (GSM_ISM_LEVEL_MEDIUM.equals(gsmIsmLvl)) {
            return IMAGE_PATH_YELLOW;
        }
        if (GSM_ISM_LEVEL_HIGH.equals(gsmIsmLvl)) {
            return IMAGE_PATH_RED;
        }
        return IMAGE_PATH_EMPTY;
    }
}

