/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.rcp;

import org.apache.log4j.Logger;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import sernet.gs.ui.rcp.main.Activator;

public class FileDialogUtil {
    private static final Logger LOG = Logger.getLogger(FileDialogUtil.class);
    private int style;
    private String title;
    private String fileSuffix;
    private String fileTypeLabel;
    private String defaultFolderPreference;

    private FileDialogUtil(Builder builder) {
        this.setDefaultFolderPreference(builder.getDefaultFolderPreference());
        this.setFileSuffix(builder.getFileSuffix());
        this.setFileTypeLabel(builder.getFileTypeLabel());
        this.setStyle(builder.getStyle());
        this.setTitle(builder.getTitle());
    }

    public String open() {
        FileDialog dialog = new FileDialog(Display.getCurrent().getActiveShell(), this.style);
        dialog.setText(this.title);
        try {
            dialog.setFilterPath(this.getDirectory());
        }
        catch (Exception e1) {
            LOG.debug((Object)("Error with file path: " + this.getDirectory()), (Throwable)e1);
            dialog.setFileName("");
        }
        if (this.fileSuffix != null) {
            dialog.setFilterExtensions(new String[]{"*" + this.fileSuffix});
        }
        if (this.fileTypeLabel != null) {
            dialog.setFilterNames(new String[]{this.fileTypeLabel});
            dialog.setFilterIndex(0);
        }
        return dialog.open();
    }

    private String getDirectory() {
        IPreferenceStore prefs = Activator.getDefault().getPreferenceStore();
        String dir = prefs.getString(this.defaultFolderPreference);
        if (dir == null || dir.isEmpty()) {
            dir = System.getProperty("user.home");
        }
        if (!dir.endsWith(System.getProperty("file.separator"))) {
            dir = String.valueOf(dir) + System.getProperty("file.separator");
        }
        return dir;
    }

    public int getStyle() {
        return this.style;
    }

    public void setStyle(int style) {
        this.style = style;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getFileSuffix() {
        return this.fileSuffix;
    }

    public void setFileSuffix(String fileSuffix) {
        this.fileSuffix = fileSuffix;
    }

    public String getFileTypeLabel() {
        return this.fileTypeLabel;
    }

    public void setFileTypeLabel(String fileTypeLabel) {
        this.fileTypeLabel = fileTypeLabel;
    }

    public String getDefaultFolderPreference() {
        return this.defaultFolderPreference;
    }

    public void setDefaultFolderPreference(String defaultFolderPreference) {
        this.defaultFolderPreference = defaultFolderPreference;
    }

    public static class Builder {
        private int style = 4096;
        private String title = "Select File";
        private String fileSuffix = ".txt";
        private String fileTypeLabel = "Text file (*.txt)";
        private String defaultFolderPreference = "default_folder_dialog";

        public Builder(int style, String title) {
            this.style = style;
            this.title = title;
        }

        public FileDialogUtil build() {
            return new FileDialogUtil(this);
        }

        public String open() {
            FileDialogUtil dialogUtil = new FileDialogUtil(this);
            return dialogUtil.open();
        }

        public int getStyle() {
            return this.style;
        }

        public Builder setStyle(int style) {
            this.style = style;
            return this;
        }

        public String getTitle() {
            return this.title;
        }

        public Builder setTitle(String title) {
            this.title = title;
            return this;
        }

        public String getFileSuffix() {
            return this.fileSuffix;
        }

        public Builder setFileSuffix(String fileSuffix) {
            this.fileSuffix = fileSuffix;
            return this;
        }

        public String getFileTypeLabel() {
            return this.fileTypeLabel;
        }

        public Builder setFileTypeLabel(String fileTypeLabel) {
            this.fileTypeLabel = fileTypeLabel;
            return this;
        }

        public String getDefaultFolderPreference() {
            return this.defaultFolderPreference;
        }

        public Builder setDefaultFolderPreference(String defaultFolderPreference) {
            this.defaultFolderPreference = defaultFolderPreference;
            return this;
        }
    }
}

