/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.rcp;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import sernet.gs.ui.rcp.main.Activator;
import sernet.gs.ui.rcp.main.common.model.CnAElementFactory;
import sernet.gs.ui.rcp.main.service.ServiceFactory;
import sernet.verinice.interfaces.CommandException;
import sernet.verinice.interfaces.ICommand;
import sernet.verinice.model.bp.IBpModelListener;
import sernet.verinice.model.bp.elements.BpModel;
import sernet.verinice.model.bsi.BSIModel;
import sernet.verinice.model.bsi.IBSIModelListener;
import sernet.verinice.model.common.ChangeLogEntry;
import sernet.verinice.model.common.CnALink;
import sernet.verinice.model.common.CnATreeElement;
import sernet.verinice.model.iso27k.IISO27KModelListener;
import sernet.verinice.model.iso27k.ISO27KModel;
import sernet.verinice.model.validation.CnAValidation;
import sernet.verinice.service.commands.LoadElementTitles;

public class ElementTitleCache
implements IBSIModelListener,
IISO27KModelListener,
IBpModelListener {
    private static final Logger LOG = Logger.getLogger(ElementTitleCache.class);
    private HashMap<Integer, String> titleMap = new HashMap();
    private static ElementTitleCache instance;
    private Set<String> typeIdSet = new HashSet<String>();
    private static final Object mutex;

    static {
        mutex = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ElementTitleCache getInstance() {
        if (instance == null) {
            Object object = mutex;
            synchronized (object) {
                if (instance == null) {
                    ElementTitleCache.createInstance();
                }
            }
        }
        return instance;
    }

    private static ElementTitleCache createInstance() {
        instance = new ElementTitleCache();
        CnAElementFactory.getLoadedModel().addBSIModelListener((IBSIModelListener)instance);
        CnAElementFactory.getInstance().getISO27kModel().addISO27KModelListener((IISO27KModelListener)instance);
        CnAElementFactory.getInstance().getBpModel().addModITBOModelListener((IBpModelListener)instance);
        instance.load(new String[]{"it-verbund", "org", "bp_itnetwork", "persongroup", "personen-kategorie", "bp_person_group"});
        return instance;
    }

    public String get(Integer dbId) {
        return this.titleMap.get(dbId);
    }

    private void load(String[] typeIds) {
        try {
            Activator.inheritVeriniceContextState();
            LoadElementTitles scopeCommand = new LoadElementTitles(typeIds);
            scopeCommand = (LoadElementTitles)ServiceFactory.lookupCommandService().executeCommand((ICommand)scopeCommand);
            this.titleMap = scopeCommand.getElements();
            this.typeIdSet.addAll(Arrays.asList(typeIds));
        }
        catch (CommandException e) {
            LOG.error((Object)"Error while loading element titles.", (Throwable)e);
        }
    }

    private void updateElement(CnATreeElement element) {
        if (element == null) {
            return;
        }
        if (this.typeIdSet.contains(element.getTypeId())) {
            this.titleMap.put(element.getDbId(), element.getTitle());
        }
    }

    private void reload() {
        this.titleMap.clear();
        this.load(this.typeIdSet.toArray(new String[this.typeIdSet.size()]));
    }

    public void modelReload(ISO27KModel newModel) {
        this.reload();
    }

    public void childAdded(CnATreeElement category, CnATreeElement child) {
        this.updateElement(child);
    }

    public void childRemoved(CnATreeElement category, CnATreeElement child) {
    }

    public void childChanged(CnATreeElement child) {
        this.updateElement(child);
    }

    public void modelRefresh() {
        this.reload();
    }

    public void modelRefresh(Object source) {
    }

    public void linkChanged(CnALink oldLink, CnALink newLink, Object source) {
    }

    public void linkRemoved(CnALink link) {
    }

    public void linkAdded(CnALink link) {
    }

    public void databaseChildAdded(CnATreeElement child) {
        this.updateElement(child);
    }

    public void databaseChildRemoved(CnATreeElement child) {
    }

    public void databaseChildRemoved(ChangeLogEntry entry) {
    }

    public void databaseChildChanged(CnATreeElement child) {
        this.updateElement(child);
    }

    public void modelReload(BSIModel newModel) {
        this.reload();
    }

    public void validationAdded(Integer scopeId) {
    }

    public void validationRemoved(Integer scopeId) {
    }

    public void validationChanged(CnAValidation oldValidation, CnAValidation newValidation) {
    }

    public void modelReload(BpModel newModel) {
        this.reload();
    }
}

