/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.rcp;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import sernet.gs.service.RuntimeCommandException;
import sernet.gs.ui.rcp.main.Activator;
import sernet.gs.ui.rcp.main.ExceptionUtil;
import sernet.gs.ui.rcp.main.bsi.dialogs.Messages;
import sernet.gs.ui.rcp.main.bsi.filter.TextFilter;
import sernet.gs.ui.rcp.main.bsi.views.CnAImageProvider;
import sernet.gs.ui.rcp.main.common.model.PlaceHolder;
import sernet.gs.ui.rcp.main.service.ServiceFactory;
import sernet.hui.common.connect.IAbbreviatedElement;
import sernet.hui.common.connect.IIdentifiableElement;
import sernet.verinice.interfaces.CommandException;
import sernet.verinice.interfaces.ICommand;
import sernet.verinice.model.common.CnATreeElement;
import sernet.verinice.model.common.CnATreeElementLabelGenerator;
import sernet.verinice.rcp.SWTElementFactory;
import sernet.verinice.service.commands.LoadCnAElementByEntityTypeId;
import sernet.verinice.service.commands.LoadContainingObjects;
import sernet.verinice.service.commands.LoadElementTitles;

public class ElementSelectionComponent {
    private static final Logger log = Logger.getLogger(ElementSelectionComponent.class);
    private Composite container;
    private TableViewer viewer;
    private Text text;
    private Button checkbox;
    private CnATreeElementTitleFilter filter;
    private List<CnATreeElement> elementList;
    private Integer scopeId;
    private Integer groupId;
    private Set<String> typeIDs;
    private boolean scopeOnly;
    private boolean showScopeCheckbox;
    private static final String COLUMN_IMG = "_img";
    private static final String COLUMN_SCOPE_ID = "_scope_id";
    private static final String COLUMN_LABEL = "_label";
    private static Map<Integer, String> titleMap = new HashMap<Integer, String>();
    private static final Comparator<CnATreeElement> BY_NAME = (elmt1, elmt2) -> {
        if (titleMap != null) {
            String title1 = titleMap.get(elmt1.getScopeId());
            String title2 = titleMap.get(elmt2.getScopeId());
            if (title1 != null && title2 != null) {
                int allScopeTitles = title1.compareTo(title2);
                if (allScopeTitles == 0) {
                    return ElementSelectionComponent.makeTitle(elmt1).compareTo(ElementSelectionComponent.makeTitle(elmt2));
                }
                return title1.compareTo(title2);
            }
            if (title1 == null && title2 == null) {
                return ElementSelectionComponent.makeTitle(elmt1).compareTo(ElementSelectionComponent.makeTitle(elmt2));
            }
            if (title1 == null) {
                return 1;
            }
            return -1;
        }
        return ElementSelectionComponent.makeTitle(elmt1).compareTo(ElementSelectionComponent.makeTitle(elmt2));
    };
    private static final Comparator<CnATreeElement> BY_SCOPE = (elmt1, elmt2) -> ElementSelectionComponent.getScopeTitle(elmt1).compareTo(ElementSelectionComponent.getScopeTitle(elmt2));
    private Map<Integer, CnATreeElement> containingObjectsByElementId;
    private final Comparator<CnATreeElement> byContainingObject = (elmt1, elmt2) -> {
        String text1 = this.getContainingObjectTitle((CnATreeElement)elmt1).orElse(null);
        String text2 = this.getContainingObjectTitle((CnATreeElement)elmt2).orElse(null);
        if (text1 != null && text2 != null) {
            return text1.compareTo(text2);
        }
        if (text1 == null) {
            return 1;
        }
        return -1;
    };
    private List<CnATreeElement> selectedElements = new ArrayList<CnATreeElement>();
    private Integer height;
    private boolean includeCompendiumElements;
    private boolean showContainingObject;

    public ElementSelectionComponent(Composite container, String type, Integer scopeId) {
        this(container, type, scopeId, null);
    }

    public ElementSelectionComponent(Composite container, String type, Integer scopeId, Integer groupId) {
        this(container, Collections.singleton(type), scopeId, groupId);
    }

    public ElementSelectionComponent(Composite container, Set<String> typeIDs, Integer scopeId, Integer groupId) {
        this.container = container;
        this.typeIDs = typeIDs;
        this.scopeId = scopeId;
        this.groupId = groupId;
        this.scopeOnly = true;
        this.showScopeCheckbox = true;
    }

    public void init() {
        int formAttachmentDefaultOffset = 5;
        int column1Width = 25;
        int column2Width = 200;
        int column3Width = 150;
        int pathColomnWidth = 250;
        int formData2Numerator = 100;
        int formData3Numerator = 100;
        this.container.setLayout((Layout)new FormLayout());
        Label label1 = new Label(this.container, 0);
        label1.setText(Messages.CnATreeElementSelectionDialog_3);
        FormData formData = new FormData();
        formData.top = new FormAttachment(0, 5);
        formData.left = new FormAttachment(0, 5);
        label1.setLayoutData((Object)formData);
        label1.pack();
        this.text = new Text(this.container, 2048);
        FormData formData2 = new FormData();
        formData2.top = new FormAttachment(0, 5);
        formData2.left = new FormAttachment((Control)label1, 5);
        formData2.right = new FormAttachment(100, -5);
        this.text.setLayoutData((Object)formData2);
        this.text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                ElementSelectionComponent.this.filter.setPattern(ElementSelectionComponent.this.text.getText());
            }
        });
        if (this.isShowScopeCheckbox()) {
            SelectionAdapter listener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Button button;
                    Button button2 = button = e.getSource() instanceof Button ? (Button)e.getSource() : null;
                    if (button != null) {
                        ElementSelectionComponent.this.scopeOnly = button.getSelection();
                        ElementSelectionComponent.this.loadElements();
                    }
                }
            };
            this.checkbox = SWTElementFactory.generateCheckboxButton(this.container, Messages.CnATreeElementSelectionDialog_4, true, (SelectionListener)listener);
            FormData checkboxFD = new FormData();
            checkboxFD.top = new FormAttachment((Control)this.text, 5);
            checkboxFD.left = new FormAttachment(0, 5);
            this.checkbox.setLayoutData((Object)checkboxFD);
            this.checkbox.pack();
        }
        this.viewer = new TableViewer(this.container, 67586);
        FormData formData3 = new FormData();
        formData3.top = this.isShowScopeCheckbox() ? new FormAttachment((Control)this.checkbox, 5) : new FormAttachment((Control)this.text, 5);
        formData3.left = new FormAttachment(0, 5);
        formData3.right = new FormAttachment(100, -5);
        formData3.bottom = new FormAttachment(100, -5);
        if (this.getHeight() != null) {
            formData3.height = this.getHeight();
        }
        this.viewer.getTable().setLayoutData((Object)formData3);
        this.viewer.getTable().setHeaderVisible(true);
        this.viewer.getTable().setLinesVisible(true);
        TableViewerColumn column1 = new TableViewerColumn(this.viewer, 16384);
        column1.getColumn().setText("");
        column1.getColumn().setWidth(25);
        column1.getColumn().setResizable(false);
        column1.setLabelProvider((CellLabelProvider)new ImageColumnCellLabelProvider());
        TableViewerColumn column2 = new TableViewerColumn(this.viewer, 16384);
        column2.getColumn().setText(Messages.CnATreeElementSelectionDialog_9);
        column2.getColumn().setResizable(true);
        column2.getColumn().setWidth(200);
        column2.getColumn().setData(BY_NAME);
        column2.setLabelProvider((CellLabelProvider)new LabelColumnCellLabelProvider());
        TableViewerColumn column3 = new TableViewerColumn(this.viewer, 16384);
        column3.getColumn().setText(Messages.CnATreeElementSelectionDialog_10);
        column3.getColumn().setWidth(150);
        column3.getColumn().setResizable(true);
        column3.getColumn().setData(BY_SCOPE);
        column3.setLabelProvider((CellLabelProvider)new ScopeIdColumnCellLabelProvider());
        if (this.showContainingObject) {
            TableViewerColumn containingObject = new TableViewerColumn(this.viewer, 16384);
            containingObject.getColumn().setText(Messages.ContainingObject);
            containingObject.getColumn().setWidth(250);
            containingObject.getColumn().setResizable(true);
            containingObject.getColumn().setData(this.byContainingObject);
            containingObject.setLabelProvider((CellLabelProvider)new ContainingObjectLabelProvider());
        }
        Table table = this.viewer.getTable();
        TableColumn[] columns = table.getColumns();
        int i = 1;
        while (i < columns.length) {
            TableColumn column = columns[i];
            column.addListener(13, e -> {
                TableColumn sortColumn = table.getSortColumn();
                int direction = table.getSortDirection();
                if (column.equals(sortColumn)) {
                    direction = direction == 128 ? 1024 : 128;
                } else {
                    table.setSortColumn(column);
                    direction = 128;
                }
                table.setSortDirection(direction);
                this.viewer.refresh();
            });
            ++i;
        }
        table.setSortColumn(columns[1]);
        table.setSortDirection(1024);
        this.viewer.setColumnProperties(new String[]{COLUMN_IMG, COLUMN_SCOPE_ID, COLUMN_LABEL});
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.filter = new CnATreeElementTitleFilter(this.viewer);
        this.viewer.setComparator((ViewerComparator)new ElementTableViewerComparator());
        this.viewer.addSelectionChangedListener(event -> {
            List list = this.selectedElements = ((IStructuredSelection)this.viewer.getSelection()).toList();
        });
        this.viewer.addDoubleClickListener(event -> {
            List list = this.selectedElements = ((IStructuredSelection)this.viewer.getSelection()).toList();
        });
    }

    public void loadElements() {
        this.loadElementsAndSelect(null);
    }

    public void loadElementsAndSelect(final CnATreeElement selected) {
        if (this.typeIDs == null || this.typeIDs.isEmpty()) {
            return;
        }
        this.viewer.setInput(Collections.singletonList(new PlaceHolder(Messages.CnATreeElementSelectionDialog_6)));
        WorkspaceJob job = new WorkspaceJob(Messages.CnATreeElementSelectionDialog_7){

            public IStatus runInWorkspace(IProgressMonitor monitor) {
                Activator.inheritVeriniceContextState();
                try {
                    monitor.setTaskName(Messages.CnATreeElementSelectionDialog_8);
                    ElementSelectionComponent.this.loadElementsFromDb();
                    ElementSelectionComponent.this.setSelectedElement(selected);
                }
                catch (Exception e) {
                    ExceptionUtil.log(e, Messages.CnATreeElementSelectionDialog_0);
                }
                return Status.OK_STATUS;
            }
        };
        job.setUser(false);
        job.schedule();
    }

    protected void setSelection() {
        if (this.selectedElements != null && !this.selectedElements.isEmpty()) {
            this.getViewer().setSelection((ISelection)new StructuredSelection(this.selectedElements));
        }
    }

    private static String makeTitle(CnATreeElement elmt) {
        return CnATreeElementLabelGenerator.getElementTitle((CnATreeElement)elmt);
    }

    public List<CnATreeElement> getSelectedElements() {
        return this.selectedElements;
    }

    public Composite getContainer() {
        return this.container;
    }

    public TableViewer getViewer() {
        return this.viewer;
    }

    public boolean isScopeOnly() {
        return this.scopeOnly;
    }

    public void setScopeOnly(boolean scopeOnly) {
        this.scopeOnly = scopeOnly;
        if (this.checkbox != null) {
            this.checkbox.setSelection(scopeOnly);
        }
    }

    public boolean isShowScopeCheckbox() {
        return this.showScopeCheckbox;
    }

    public void setShowScopeCheckbox(boolean showScopeCheckbox) {
        this.showScopeCheckbox = showScopeCheckbox;
    }

    public void setIncludeCompendiumElements(boolean includeCompendiumElements) {
        this.includeCompendiumElements = includeCompendiumElements;
    }

    public void setShowContainingObject(boolean showContainingObject) {
        this.showContainingObject = showContainingObject;
    }

    private void loadElementsFromDb() {
        List<CnATreeElement> elements = this.typeIDs.stream().flatMap(typeId -> {
            LoadCnAElementByEntityTypeId command = this.scopeOnly ? new LoadCnAElementByEntityTypeId(typeId, this.getScopeId(), this.getGroupId()) : new LoadCnAElementByEntityTypeId(typeId, this.includeCompendiumElements);
            try {
                command = (LoadCnAElementByEntityTypeId)ServiceFactory.lookupCommandService().executeCommand((ICommand)command);
            }
            catch (CommandException e) {
                throw new RuntimeCommandException((Throwable)e);
            }
            return command.getElements().stream();
        }).collect(Collectors.toList());
        if (this.showContainingObject && !elements.isEmpty()) {
            try {
                LoadContainingObjects command = new LoadContainingObjects(elements);
                command = (LoadContainingObjects)ServiceFactory.lookupCommandService().executeCommand((ICommand)command);
                this.containingObjectsByElementId = command.getResult();
            }
            catch (CommandException e) {
                log.error((Object)"Error loading parent target object", (Throwable)e);
            }
        }
        this.showElementsInTable(elements);
    }

    private void showElementsInTable(List<CnATreeElement> list) {
        Display.getDefault().asyncExec(() -> {
            if (list != null) {
                this.viewer.setInput((Object)list);
            } else {
                this.viewer.setInput(Collections.emptyList());
            }
        });
        this.elementList = list;
    }

    public void deselectElements() {
        Display.getDefault().syncExec(() -> {
            this.getViewer().getTable().deselectAll();
            this.getViewer().setSelection((ISelection)new StructuredSelection());
            this.selectedElements.clear();
        });
    }

    public void setSelectedElement(CnATreeElement selectedElement) {
        int i;
        if (selectedElement != null && (i = this.elementList.indexOf(selectedElement)) != -1) {
            Display.getDefault().syncExec(() -> {
                this.getViewer().getTable().deselectAll();
                this.getViewer().setSelection((ISelection)new StructuredSelection((Object)selectedElement));
                this.selectedElements = ((IStructuredSelection)this.viewer.getSelection()).toList();
            });
        }
    }

    public Integer getScopeId() {
        return this.scopeId;
    }

    public void setScopeId(Integer scopeId) {
        this.scopeId = scopeId;
    }

    public Integer getGroupId() {
        return this.groupId;
    }

    public void setGroupId(Integer groupId) {
        this.groupId = groupId;
    }

    public void setTypeId(String typeId) {
        this.typeIDs = Collections.singleton(typeId);
    }

    public void setTypeIds(Set<String> typeIds) {
        this.typeIDs = typeIds;
    }

    public Integer getHeight() {
        return this.height;
    }

    public void setHeight(Integer height) {
        this.height = height;
    }

    private static String getScopeTitle(CnATreeElement elmt) {
        String title = "";
        try {
            title = !titleMap.containsKey(elmt.getScopeId()) ? ElementSelectionComponent.loadElementsTitles(elmt) : titleMap.get(elmt.getScopeId());
        }
        catch (CommandException e) {
            log.error((Object)"Error while getting element", (Throwable)e);
        }
        return title;
    }

    private Optional<String> getContainingObjectTitle(CnATreeElement elmt) {
        CnATreeElement containingObject = this.containingObjectsByElementId.get(elmt.getDbId());
        return Optional.ofNullable(containingObject).map(CnATreeElementLabelGenerator::getElementTitle);
    }

    private static String loadElementsTitles(CnATreeElement elmt) throws CommandException {
        LoadElementTitles scopeCommand = new LoadElementTitles();
        scopeCommand = (LoadElementTitles)ServiceFactory.lookupCommandService().executeCommand((ICommand)scopeCommand);
        titleMap = scopeCommand.getElements();
        return titleMap.get(elmt.getScopeId());
    }

    private class CnATreeElementTitleFilter
    extends TextFilter {
        public CnATreeElementTitleFilter(TableViewer viewer) {
            super((StructuredViewer)viewer);
        }

        @Override
        public boolean select(Viewer viewer, Object parentElement, Object element) {
            Optional<String> containingObjectTitle;
            if (!(element instanceof CnATreeElement) || this.getRegex() == null) {
                return true;
            }
            CnATreeElement elmt = (CnATreeElement)element;
            if (this.getRegex().matcher(elmt.getTitle()).find()) {
                return true;
            }
            if (elmt instanceof IAbbreviatedElement && this.getRegex().matcher(((IAbbreviatedElement)elmt).getAbbreviation()).find()) {
                return true;
            }
            if (elmt instanceof IIdentifiableElement && this.getRegex().matcher(((IIdentifiableElement)elmt).getIdentifier()).find()) {
                return true;
            }
            if (this.getRegex().matcher(ElementSelectionComponent.getScopeTitle(elmt)).find()) {
                return true;
            }
            return ElementSelectionComponent.this.showContainingObject && (containingObjectTitle = ElementSelectionComponent.this.getContainingObjectTitle(elmt)).isPresent() && this.getRegex().matcher(containingObjectTitle.get()).find();
        }
    }

    private final class ContainingObjectLabelProvider
    extends CellLabelProvider {
        private ContainingObjectLabelProvider() {
        }

        public void update(ViewerCell cell) {
            if (cell.getElement() instanceof PlaceHolder) {
                cell.setText(((PlaceHolder)cell.getElement()).getTitle());
                return;
            }
            CnATreeElement element = (CnATreeElement)cell.getElement();
            ElementSelectionComponent.this.getContainingObjectTitle(element).ifPresent(arg_0 -> ((ViewerCell)cell).setText(arg_0));
        }
    }

    private static final class ElementTableViewerComparator
    extends ViewerComparator {
        private ElementTableViewerComparator() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            Comparator<Object> comparator;
            Table table = ((TableViewer)viewer).getTable();
            TableColumn sortColumn = table.getSortColumn();
            Comparator<Object> comparator2 = comparator = sortColumn == null ? null : (Comparator<Object>)sortColumn.getData();
            if (comparator != null && table.getSortDirection() == 128) {
                comparator = comparator.reversed();
            }
            return comparator == null ? 0 : comparator.compare(e1, e2);
        }
    }

    private static final class ImageColumnCellLabelProvider
    extends CellLabelProvider {
        private ImageColumnCellLabelProvider() {
        }

        public void update(ViewerCell cell) {
            if (cell.getElement() instanceof PlaceHolder) {
                return;
            }
            CnATreeElement element = (CnATreeElement)cell.getElement();
            Image image = CnAImageProvider.getImage(element);
            cell.setImage(image);
        }
    }

    private static final class LabelColumnCellLabelProvider
    extends CellLabelProvider {
        private LabelColumnCellLabelProvider() {
        }

        public void update(ViewerCell cell) {
            if (cell.getElement() instanceof PlaceHolder) {
                cell.setText(((PlaceHolder)cell.getElement()).getTitle());
                return;
            }
            cell.setText(ElementSelectionComponent.makeTitle((CnATreeElement)cell.getElement()));
        }
    }

    private static final class ScopeIdColumnCellLabelProvider
    extends CellLabelProvider {
        private ScopeIdColumnCellLabelProvider() {
        }

        public void update(ViewerCell cell) {
            if (cell.getElement() instanceof PlaceHolder) {
                cell.setText(((PlaceHolder)cell.getElement()).getTitle());
                return;
            }
            CnATreeElement elmt = (CnATreeElement)cell.getElement();
            String title = ElementSelectionComponent.getScopeTitle(elmt);
            cell.setText(title);
        }
    }
}

