/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.rcp;

import org.apache.log4j.Logger;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;
import sernet.gs.ui.rcp.main.Activator;
import sernet.gs.ui.rcp.main.ExceptionUtil;
import sernet.gs.ui.rcp.main.bsi.editors.EditorFactory;
import sernet.gs.ui.rcp.main.common.model.CnAElementFactory;
import sernet.gs.ui.rcp.main.common.model.NotSufficientRightsException;
import sernet.hui.common.VeriniceContext;
import sernet.springclient.RightsServiceClient;
import sernet.verinice.interfaces.CnATreeElementBuildException;
import sernet.verinice.interfaces.CommandException;
import sernet.verinice.model.bp.IBpGroup;
import sernet.verinice.model.common.CnATreeElement;
import sernet.verinice.model.iso27k.Asset;
import sernet.verinice.model.iso27k.IISO27kGroup;
import sernet.verinice.rcp.Messages;
import sernet.verinice.rcp.RightsEnabledHandler;

public abstract class AddGroupHandler
extends RightsEnabledHandler {
    private static final Logger LOG = Logger.getLogger(AddGroupHandler.class);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        try {
            if (!this.checkRights()) {
                throw new NotSufficientRightsException("Action not allowed for user");
            }
            CnATreeElement parent = this.getSelectedElement(event);
            this.createGroup(parent);
        }
        catch (NotSufficientRightsException e) {
            LOG.error((Object)"Could not add element", (Throwable)e);
            ExceptionUtil.log(e, Messages.AddGroupHandler_permission_error);
        }
        catch (Exception e) {
            LOG.error((Object)"Could not add element group", (Throwable)e);
            ExceptionUtil.log(e, Messages.AddGroupHandler_error);
        }
        return null;
    }

    protected void createGroup(CnATreeElement parent) throws CommandException, CnATreeElementBuildException {
        CnATreeElement newGroup = null;
        if (parent != null) {
            String groupTypeId = this.getTypeIdForNewGroup(parent);
            boolean inheritIcon = Activator.getDefault().getPreferenceStore().getBoolean("inherit_special_group_icon");
            newGroup = CnAElementFactory.getInstance().saveNew(parent, groupTypeId, null, inheritIcon);
        }
        if (newGroup != null) {
            EditorFactory.getInstance().openEditor(newGroup);
        }
    }

    protected String getTypeIdForNewGroup(CnATreeElement parent) {
        if (parent instanceof Asset) {
            return "controlgroup";
        }
        return parent.getTypeId();
    }

    protected CnATreeElement getSelectedElement(ExecutionEvent event) {
        CnATreeElement element = null;
        IStructuredSelection selection = (IStructuredSelection)HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        Object sel = selection.getFirstElement();
        if (sel instanceof IISO27kGroup || sel instanceof IBpGroup) {
            element = (CnATreeElement)sel;
        }
        return element;
    }

    @Override
    public boolean checkRights() {
        RightsServiceClient service = (RightsServiceClient)VeriniceContext.get((String)"rightsService");
        return service.isEnabled(this.getRightID());
    }
}

