/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.iso27k.service;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import sernet.gs.service.Retriever;
import sernet.gs.ui.rcp.main.service.ServiceFactory;
import sernet.verinice.interfaces.ICommandService;
import sernet.verinice.interfaces.IPostProcessor;
import sernet.verinice.iso27k.rcp.RcpProgressObserver;
import sernet.verinice.iso27k.service.IProgressObserver;
import sernet.verinice.iso27k.service.IProgressTask;
import sernet.verinice.model.common.CnATreeElement;
import sernet.verinice.model.iso27k.IISO27kGroup;

public abstract class PasteService
implements IProgressTask {
    protected CnATreeElement selectedGroup;
    protected List<CnATreeElement> elements;
    protected int numberOfElements;
    private List<IPostProcessor> postProcessorList;
    protected IProgressObserver progressObserver;
    private ICommandService commandService;

    @Override
    public int getNumberOfElements() {
        return this.numberOfElements;
    }

    @Override
    public void setProgressObserver(RcpProgressObserver rcpProgressObserver) {
        this.progressObserver = rcpProgressObserver;
    }

    protected List<CnATreeElement> createInsertList(List<CnATreeElement> elementDragList) {
        ArrayList<CnATreeElement> tempList = new ArrayList<CnATreeElement>();
        ArrayList<CnATreeElement> insertList = new ArrayList<CnATreeElement>();
        int depth = 0;
        int removed = 0;
        for (CnATreeElement item : elementDragList) {
            this.createInsertList(item, tempList, insertList, depth, removed);
        }
        this.numberOfElements = tempList.size() - removed;
        return insertList;
    }

    private void createInsertList(CnATreeElement element, List<CnATreeElement> tempList, List<CnATreeElement> insertList, int depth, int removed) {
        if (!tempList.contains(element)) {
            tempList.add(element);
            if (depth == 0) {
                insertList.add(element);
            }
            if (element instanceof IISO27kGroup && element.getChildren() != null) {
                ++depth;
                element = Retriever.checkRetrieveChildren((CnATreeElement)element);
                for (CnATreeElement child : element.getChildren()) {
                    this.createInsertList(child, tempList, insertList, depth, removed);
                }
            }
        } else {
            insertList.remove(element);
            ++removed;
        }
    }

    protected List<IPostProcessor> getPostProcessorList() {
        if (this.postProcessorList == null) {
            this.postProcessorList = new LinkedList<IPostProcessor>();
        }
        return this.postProcessorList;
    }

    public void addPostProcessor(IPostProcessor task) {
        if (this.postProcessorList == null) {
            this.postProcessorList = new LinkedList<IPostProcessor>();
        }
        this.postProcessorList.add(task);
    }

    public ICommandService getCommandService() {
        if (this.commandService == null) {
            this.commandService = this.createCommandServive();
        }
        return this.commandService;
    }

    private ICommandService createCommandServive() {
        return ServiceFactory.lookupCommandService();
    }

    public CnATreeElement getGroup() {
        return this.selectedGroup;
    }
}

