/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.iso27k.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;
import sernet.gs.model.Baustein;
import sernet.gs.model.Gefaehrdung;
import sernet.gs.model.Massnahme;
import sernet.gs.service.GSServiceException;
import sernet.gs.service.RetrieveInfo;
import sernet.gs.ui.rcp.main.common.model.BuildInput;
import sernet.gs.ui.rcp.main.common.model.CnAElementFactory;
import sernet.gs.ui.rcp.main.common.model.CnAElementHome;
import sernet.gs.ui.rcp.main.service.ServiceFactory;
import sernet.hui.common.connect.ITypedElement;
import sernet.verinice.interfaces.CommandException;
import sernet.verinice.interfaces.IAuthService;
import sernet.verinice.interfaces.ICommand;
import sernet.verinice.interfaces.ICommandService;
import sernet.verinice.iso27k.service.IModelUpdater;
import sernet.verinice.iso27k.service.IProgressObserver;
import sernet.verinice.iso27k.service.Messages;
import sernet.verinice.model.common.CnATreeElement;
import sernet.verinice.model.common.Permission;
import sernet.verinice.model.iso27k.Control;
import sernet.verinice.model.iso27k.ControlGroup;
import sernet.verinice.model.iso27k.Group;
import sernet.verinice.model.iso27k.IncidentScenario;
import sernet.verinice.model.iso27k.IncidentScenarioGroup;
import sernet.verinice.service.commands.LoadElementById;
import sernet.verinice.service.commands.SaveElement;
import sernet.verinice.service.parser.GSScraperUtil;

public class GS2BSITransformService {
    private IProgressObserver progressObserver;
    private static final Logger log = Logger.getLogger(GS2BSITransformService.class);
    private int numberOfControls;
    private List<Object> itemList;
    private IModelUpdater modelUpdater;
    private Group<?> selectedGroup;
    private int numberProcessed;
    private IAuthService authService;
    private ICommandService commandService;
    private boolean isScenario = false;
    private ItemTransformer transformer = new ItemTransformer(){

        @Override
        public void transformElement(Group<?> group, Object item, List<CnATreeElement> elements) {
            GS2BSITransformService.this.transformGsElement(group, item, elements);
        }
    };

    public GS2BSITransformService(IProgressObserver progressObserver, IModelUpdater modelUpdater, Group<?> selectedGroup, Object data) {
        this.progressObserver = progressObserver;
        this.itemList = new ArrayList<Object>(20);
        if (data instanceof Object[]) {
            Object[] o;
            Object[] objectArray = o = (Object[])data;
            int n = o.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                this.itemList.add(object);
                ++n2;
            }
        } else if (data instanceof Collection) {
            Collection c = (Collection)data;
            this.itemList.addAll(c);
        } else {
            this.itemList.add(data);
        }
        this.modelUpdater = modelUpdater;
        this.selectedGroup = selectedGroup;
    }

    public GS2BSITransformService(IProgressObserver progressObserver, IModelUpdater modelUpdater, Group<?> selectedGroup, Object data, ItemTransformer transformer) {
        this(progressObserver, modelUpdater, selectedGroup, data);
        this.transformer = transformer;
    }

    public boolean isScenario() {
        return this.isScenario;
    }

    public void run() {
        try {
            this.numberOfControls = this.itemList.size();
            this.progressObserver.beginTask(Messages.getString("GS2BSITransformService.0", this.numberOfControls), -1);
            for (Object o : this.itemList) {
                this.insertItem(this.progressObserver, this.selectedGroup, o);
            }
        }
        catch (Exception e) {
            log.error((Object)"Error while transforming GS element to ISM element", (Throwable)e);
        }
    }

    private void insertItem(IProgressObserver monitor, Group<?> group, Object item) {
        if (monitor.isCanceled()) {
            log.warn((Object)("Transforming canceled. " + this.numberProcessed + " items transformed."));
            return;
        }
        ArrayList<CnATreeElement> elements = new ArrayList<CnATreeElement>();
        if (item != null) {
            this.transformer.transformElement(group, item, elements);
        }
        this.saveItems(elements, monitor);
    }

    private void transformGsElement(Group<?> group, Object item, List<CnATreeElement> elements) {
        if (item instanceof Massnahme) {
            Massnahme m = (Massnahme)item;
            elements.add((CnATreeElement)this.generateControl(m, (CnATreeElement)group));
        }
        if (item instanceof Gefaehrdung) {
            Gefaehrdung g = (Gefaehrdung)item;
            elements.add((CnATreeElement)this.generateScenario(g, group));
        }
        if (item instanceof Baustein) {
            try {
                Baustein b = (Baustein)item;
                if (group.canContain((Object)new IncidentScenario())) {
                    IncidentScenarioGroup newGroup = new IncidentScenarioGroup(group);
                    newGroup.setTitel(String.valueOf(b.getId()) + " " + b.getTitel());
                    CnATreeElement saveNew = null;
                    saveNew = CnAElementFactory.getInstance().saveNew((CnATreeElement)group, "incident_scenario_group", new BuildInput<IncidentScenarioGroup>(newGroup), false, false);
                    saveNew.setTitel(String.valueOf(b.getId()) + " " + b.getTitel());
                    CnAElementHome.getInstance().updateEntity(saveNew);
                    CnAElementFactory.getLoadedModel().childAdded(group, saveNew);
                    for (Gefaehrdung g : b.getGefaehrdungen()) {
                        IncidentScenario scen = this.generateScenario(g, (Group<?>)((IncidentScenarioGroup)saveNew));
                        elements.add((CnATreeElement)scen);
                    }
                } else if (group.canContain((Object)new Control())) {
                    ControlGroup newGroup = new ControlGroup(group);
                    newGroup.setTitel(b.getTitel());
                    CnATreeElement saveNew = null;
                    saveNew = CnAElementFactory.getInstance().saveNew((CnATreeElement)group, "controlgroup", new BuildInput<ControlGroup>(newGroup), false, false);
                    saveNew.setTitel(String.valueOf(b.getId()) + " " + b.getTitel());
                    CnAElementHome.getInstance().updateEntity(saveNew);
                    CnAElementFactory.getLoadedModel().childAdded(group, saveNew);
                    for (Massnahme m : b.getMassnahmen()) {
                        elements.add((CnATreeElement)this.generateControl(m, (CnATreeElement)((ControlGroup)saveNew)));
                    }
                }
            }
            catch (Exception e) {
                log.error((Object)"Error while transforming baustein", (Throwable)e);
            }
        }
    }

    private void saveItems(List<CnATreeElement> elements, IProgressObserver monitor) {
        SaveElement command = null;
        boolean errorOccured = false;
        if (elements.size() > 0) {
            for (CnATreeElement e : elements) {
                monitor.setTaskName(this.getText(this.numberProcessed, e.getTitle()));
                if (e.getParent().canContain((Object)e)) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Creating element,  UUID: " + e.getUuid() + ", title: " + e.getTitle()));
                    }
                } else {
                    log.warn((Object)"trying to drop an item into a group that is unable to accept this type of items");
                    errorOccured = true;
                }
                if (errorOccured) continue;
                try {
                    HashSet<Permission> newperms = new HashSet<Permission>();
                    newperms.add(Permission.createPermission((CnATreeElement)e, (String)this.getAuthService().getUsername(), (boolean)true, (boolean)true));
                    e.setPermissions(newperms);
                    command = new SaveElement((ITypedElement)e);
                    if (e instanceof IncidentScenario) {
                        this.isScenario = true;
                    }
                    command = (SaveElement)this.getCommandService().executeCommand((ICommand)command);
                }
                catch (CommandException ce) {
                    log.error((Object)"Error while inserting control", (Throwable)ce);
                    throw new RuntimeException("Error while inserting control", ce);
                }
                e = (CnATreeElement)command.getElement();
                RetrieveInfo info = new RetrieveInfo().setParent(true).setChildren(true).setProperties(true);
                LoadElementById c2 = new LoadElementById(e.getDbId(), info);
                try {
                    c2 = (LoadElementById)ServiceFactory.lookupCommandService().executeCommand((ICommand)c2);
                    e = c2.getElement();
                    c2 = new LoadElementById(e.getParent().getDbId(), info);
                    c2 = (LoadElementById)ServiceFactory.lookupCommandService().executeCommand((ICommand)c2);
                    e.setParent(c2.getElement());
                }
                catch (CommandException e1) {
                    log.error((Object)"Error while loading element", (Throwable)e1);
                }
                CnATreeElement parent = e.getParent();
                parent.addChild(e);
                e.setParentAndScope(parent);
                this.modelUpdater.childAdded((CnATreeElement)((Group)parent), e);
                monitor.processed(1);
                ++this.numberProcessed;
            }
        }
    }

    private String getText(int i, String title) {
        return Messages.getString("GS2BSITransformService.1", i, title);
    }

    private Control generateControl(Massnahme m, CnATreeElement parent) {
        Control c = new Control(parent);
        c.setTitel(String.valueOf(m.getId()) + " " + m.getTitel());
        try {
            String description = GSScraperUtil.getInstance().getModel().getMassnahmeHtml(m.getUrl(), m.getStand());
            c.setDescription(description);
        }
        catch (GSServiceException e) {
            log.error((Object)"Error while transforming massnahme into control", (Throwable)e);
        }
        return c;
    }

    private IncidentScenario generateScenario(Gefaehrdung g, Group<?> parent) {
        IncidentScenario s = new IncidentScenario(parent);
        if (g.getTitel() != null) {
            String title = String.valueOf(g.getId()) + " " + g.getTitel();
            s.setTitel(title);
        } else {
            s.setTitel("Dummy Scenario");
        }
        return s;
    }

    public int getNumberOfControls() {
        return this.numberOfControls;
    }

    public int getNumberProcessed() {
        return this.numberProcessed;
    }

    public IAuthService getAuthService() {
        if (this.authService == null) {
            this.authService = this.createAuthService();
        }
        return this.authService;
    }

    private IAuthService createAuthService() {
        return ServiceFactory.lookupAuthService();
    }

    public ICommandService getCommandService() {
        if (this.commandService == null) {
            this.commandService = this.createCommandServive();
        }
        return this.commandService;
    }

    private ICommandService createCommandServive() {
        return ServiceFactory.lookupCommandService();
    }

    public static interface ItemTransformer {
        public void transformElement(Group<?> var1, Object var2, List<CnATreeElement> var3);
    }
}

