/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.iso27k.service;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import sernet.gs.service.PermissionException;
import sernet.gs.ui.rcp.main.Activator;
import sernet.gs.ui.rcp.main.common.model.CnAElementFactory;
import sernet.gs.ui.rcp.main.common.model.CnAElementHome;
import sernet.verinice.interfaces.ElementChange;
import sernet.verinice.interfaces.ICommand;
import sernet.verinice.interfaces.IPostProcessor;
import sernet.verinice.iso27k.service.DummyProgressObserver;
import sernet.verinice.iso27k.service.IProgressObserver;
import sernet.verinice.iso27k.service.IProgressTask;
import sernet.verinice.iso27k.service.Messages;
import sernet.verinice.iso27k.service.PasteService;
import sernet.verinice.model.common.CnATreeElement;
import sernet.verinice.service.commands.CutCommand;

public class CutService
extends PasteService
implements IProgressTask {
    private final Logger log = Logger.getLogger(CutService.class);
    private List<ElementChange> elementChanges;
    private boolean inheritPermissions = false;

    public CutService(CnATreeElement group, List<CnATreeElement> elementList) {
        this.progressObserver = new DummyProgressObserver();
        this.selectedGroup = group;
        this.elements = elementList;
    }

    public CutService(IProgressObserver progressObserver, CnATreeElement group, List<CnATreeElement> elementList) {
        this.progressObserver = progressObserver;
        this.selectedGroup = group;
        this.elements = elementList;
    }

    @Override
    public void run() {
        try {
            try {
                Activator.inheritVeriniceContextState();
                this.checkPermissions(this.elements);
                ArrayList<String> uuidList = new ArrayList<String>(this.elements.size());
                for (CnATreeElement element : this.elements) {
                    uuidList.add(element.getUuid());
                }
                this.numberOfElements = uuidList.size();
                this.progressObserver.beginTask(Messages.getString("CutService.1", this.numberOfElements), this.numberOfElements);
                CutCommand cc = new CutCommand(this.selectedGroup.getUuid(), uuidList, this.getPostProcessorList());
                this.configurePermissions();
                cc = (CutCommand)this.getCommandService().executeCommand((ICommand)cc);
                this.numberOfElements = cc.getNumber();
                this.progressObserver.setTaskName(Messages.getString("CutService.3"));
                CnAElementFactory.getInstance().reloadAllModelsFromDatabase();
                this.elementChanges = cc.getChanges();
            }
            catch (PermissionException e) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)e);
                }
                throw e;
            }
            catch (RuntimeException e) {
                this.log.error((Object)"RuntimeException while copying element", (Throwable)e);
                throw e;
            }
            catch (Exception e) {
                this.log.error((Object)"Error while copying element", (Throwable)e);
                throw new RuntimeException("Error while copying element", e);
            }
        }
        finally {
            this.progressObserver.done();
        }
    }

    private void configurePermissions() {
        if (this.isInheritPermissions()) {
            CutCommand.InheritPermissions postProcessor = new CutCommand.InheritPermissions(this.selectedGroup);
            this.addPostProcessor((IPostProcessor)postProcessor);
        }
    }

    private boolean checkPermissions(List<CnATreeElement> elementList) {
        for (CnATreeElement element : elementList) {
            if (CnAElementHome.getInstance().isDeleteAllowed(element)) continue;
            throw new PermissionException(String.valueOf(Messages.getString("CutService.4")) + this.getTitle(element));
        }
        return true;
    }

    private String getTitle(CnATreeElement element) {
        String title = "unknown";
        try {
            title = element.getTitle();
        }
        catch (Exception t) {
            this.log.error((Object)"Error while reading title.", (Throwable)t);
        }
        return title;
    }

    public List<ElementChange> getElementChanges() {
        return this.elementChanges;
    }

    public boolean isInheritPermissions() {
        return this.inheritPermissions;
    }

    public void setInheritPermissions(boolean inheritPermissions) {
        this.inheritPermissions = inheritPermissions;
    }
}

