/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.iso27k.service;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import sernet.gs.ui.rcp.main.Activator;
import sernet.gs.ui.rcp.main.common.model.CnAElementFactory;
import sernet.verinice.interfaces.ICommand;
import sernet.verinice.interfaces.IPostProcessor;
import sernet.verinice.iso27k.service.DummyProgressObserver;
import sernet.verinice.iso27k.service.IProgressObserver;
import sernet.verinice.iso27k.service.IProgressTask;
import sernet.verinice.iso27k.service.Messages;
import sernet.verinice.iso27k.service.PasteService;
import sernet.verinice.model.common.CnATreeElement;
import sernet.verinice.service.commands.CopyCommand;
import sernet.verinice.service.commands.CopyLinks;
import sernet.verinice.service.commands.CopyLinksCommand;

public class CopyService
extends PasteService
implements IProgressTask {
    private final Logger log = Logger.getLogger(CopyService.class);
    private final List<CnATreeElement> elements;
    private List<String> newElements;
    private boolean copyAttachments = false;

    public CopyService(CnATreeElement group, List<CnATreeElement> elementList) {
        this.progressObserver = new DummyProgressObserver();
        this.selectedGroup = group;
        this.elements = elementList;
    }

    public CopyService(IProgressObserver progressObserver, CnATreeElement group, List<CnATreeElement> elementList, CopyLinksCommand.CopyLinksMode copyLinksMode) {
        this.progressObserver = progressObserver;
        this.selectedGroup = group;
        this.elements = elementList;
        if (copyLinksMode != CopyLinksCommand.CopyLinksMode.NONE) {
            this.addPostProcessor((IPostProcessor)new CopyLinks(copyLinksMode));
        }
    }

    @Override
    public void run() {
        try {
            try {
                Activator.inheritVeriniceContextState();
                ArrayList<String> uuidList = new ArrayList<String>(this.elements.size());
                for (CnATreeElement element : this.elements) {
                    uuidList.add(element.getUuid());
                }
                this.numberOfElements = uuidList.size();
                this.progressObserver.beginTask(Messages.getString("CopyService.1", this.numberOfElements), -1);
                CopyCommand cc = new CopyCommand(this.selectedGroup.getUuid(), uuidList, this.getPostProcessorList());
                cc.setCopyAttachments(this.isCopyAttachments());
                cc = (CopyCommand)this.getCommandService().executeCommand((ICommand)cc);
                this.numberOfElements = cc.getNumber();
                this.progressObserver.setTaskName(Messages.getString("CopyService.4"));
                CnAElementFactory.getInstance().reloadAllModelsFromDatabase();
                this.newElements = cc.getNewElements();
            }
            catch (Exception e) {
                this.log.error((Object)"Error while copying element", (Throwable)e);
                throw new RuntimeException("Error while copying element", e);
            }
        }
        finally {
            this.progressObserver.done();
        }
    }

    public List<String> getNewElements() {
        return this.newElements;
    }

    public boolean isCopyAttachments() {
        return this.copyAttachments;
    }

    public void setCopyAttachments(boolean copyAttachments) {
        this.copyAttachments = copyAttachments;
    }
}

