/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.iso27k.rcp.action;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.progress.IProgressService;
import sernet.gs.model.Baustein;
import sernet.gs.service.PermissionException;
import sernet.gs.service.RetrieveInfo;
import sernet.gs.service.Retriever;
import sernet.gs.ui.rcp.main.Activator;
import sernet.gs.ui.rcp.main.ExceptionUtil;
import sernet.gs.ui.rcp.main.bsi.dnd.CopyBausteine;
import sernet.gs.ui.rcp.main.common.model.CnAElementFactory;
import sernet.gs.ui.rcp.main.common.model.CnAElementHome;
import sernet.gs.ui.rcp.main.service.ServiceFactory;
import sernet.verinice.interfaces.CommandException;
import sernet.verinice.interfaces.ElementChange;
import sernet.verinice.interfaces.ICommand;
import sernet.verinice.iso27k.rcp.CnPItems;
import sernet.verinice.iso27k.rcp.CopyTreeElements;
import sernet.verinice.iso27k.rcp.CutOperation;
import sernet.verinice.iso27k.rcp.JobScheduler;
import sernet.verinice.iso27k.rcp.Mutex;
import sernet.verinice.iso27k.rcp.action.Messages;
import sernet.verinice.model.bp.elements.BpModel;
import sernet.verinice.model.bsi.BSIModel;
import sernet.verinice.model.bsi.IBSIStrukturKategorie;
import sernet.verinice.model.bsi.ImportBsiGroup;
import sernet.verinice.model.catalog.CatalogModel;
import sernet.verinice.model.common.CnATreeElement;
import sernet.verinice.model.iso27k.IISO27kGroup;
import sernet.verinice.model.iso27k.ISO27KModel;
import sernet.verinice.model.iso27k.ImportIsoGroup;
import sernet.verinice.rcp.IProgressRunnable;
import sernet.verinice.rcp.InfoDialogWithShowToggle;
import sernet.verinice.service.commands.CopyLinksCommand;
import sernet.verinice.service.commands.LoadElementByUuid;

public class PasteHandler
extends AbstractHandler {
    private static final Logger LOG = Logger.getLogger(PasteHandler.class);
    private List<String> newCopyElements;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        try {
            ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
            IViewPart part = (IViewPart)HandlerUtil.getActivePart((ExecutionEvent)event);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Avtive part: " + part.getViewSite().getId()));
            }
            if (selection instanceof IStructuredSelection) {
                CnATreeElement target = this.getTarget(part.getViewSite().getId(), (IStructuredSelection)selection);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Target - type: " + target.getTypeId() + ", title:" + target.getTitle()));
                }
                if (CnAElementHome.getInstance().isNewChildAllowed(target)) {
                    if (!CnPItems.getCopyItems().isEmpty()) {
                        CopyLinksCommand.CopyLinksMode copyLinksMode = this.getCopyLinksMode();
                        this.copy(target, CnPItems.getCopyItems(), copyLinksMode);
                    } else if (!CnPItems.getCutItems().isEmpty()) {
                        this.cut(target, CnPItems.getCutItems());
                    }
                } else if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"User is not allowed to add elements to this group");
                }
            }
        }
        catch (InvocationTargetException e) {
            LOG.error((Object)"Error while pasting", (Throwable)e);
            LOG.error((Object)"Error while pasting with target exception", e.getTargetException());
            ExceptionUtil.log(e, Messages.getString("PasteHandler.1"));
        }
        catch (PermissionException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)e);
            }
            this.handlePermissionException(e);
        }
        catch (Exception t) {
            if (t.getCause() instanceof PermissionException) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)t);
                }
                this.handlePermissionException((PermissionException)t.getCause());
            }
            LOG.error((Object)"Error while pasting", (Throwable)t);
            ExceptionUtil.log(t, Messages.getString("PasteHandler.1"));
        }
        return null;
    }

    private CopyLinksCommand.CopyLinksMode getCopyLinksMode() {
        if (CnPItems.isCopyLinks()) {
            if ("sernet.verinice.rcp.catalog.CatalogView".equals(CnPItems.getCopySourcePartId())) {
                return CopyLinksCommand.CopyLinksMode.FROM_COMPENDIUM_TO_MODEL;
            }
            return CopyLinksCommand.CopyLinksMode.ALL;
        }
        return CopyLinksCommand.CopyLinksMode.NONE;
    }

    private void handlePermissionException(PermissionException e) {
        MessageDialog.openError((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)Messages.getString("PasteHandler.2"), (String)e.getMessage());
    }

    private CnATreeElement getTarget(String id, IStructuredSelection sel) {
        ISO27KModel target = null;
        if (sel.size() == 1 && sel.getFirstElement() instanceof CnATreeElement) {
            target = (CnATreeElement)sel.getFirstElement();
        } else if ("sernet.verinice.iso27k.rcp.ISMView".equals(id)) {
            target = CnAElementFactory.getInstance().getISO27kModel();
        } else if ("sernet.verinice.bp.rcp.BaseProtectionView".equals(id)) {
            target = CnAElementFactory.getInstance().getBpModel();
        } else if ("sernet.gs.ui.rcp.main.views.bsimodelview".equals(id)) {
            target = CnAElementFactory.getLoadedModel();
        }
        return target;
    }

    private void copy(CnATreeElement target, List copyList, CopyLinksCommand.CopyLinksMode copyLinksMode) throws InvocationTargetException, InterruptedException {
        IProgressRunnable operation;
        if (copyList != null && !copyList.isEmpty() && (operation = this.createOperation(target, copyList, copyLinksMode)) != null) {
            IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
            progressService.run(true, true, (IRunnableWithProgress)operation);
            InfoDialogWithShowToggle.openInformation(Messages.getString("PasteHandler.2"), NLS.bind((String)Messages.getString("PasteHandler.3"), (Object)operation.getNumberOfElements()), Messages.getString("PasteHandler.0"), "info_elements_copied");
            if (Activator.getDefault().getPreferenceStore().getBoolean("use_automatic_validation")) {
                this.validate(target, operation);
            }
        }
    }

    protected void validate(CnATreeElement target, IProgressRunnable operation) {
        this.newCopyElements = ((CopyTreeElements)operation).getNewElements();
        if (this.newCopyElements != null) {
            this.validate(target);
        }
    }

    protected void validate(final CnATreeElement target) {
        final List<String> validationList = this.newCopyElements;
        WorkspaceJob validationCreationJob = new WorkspaceJob(Messages.getString("PasteHandler.5")){

            public IStatus runInWorkspace(IProgressMonitor monitor) {
                Activator.inheritVeriniceContextState();
                IStatus status = Status.OK_STATUS;
                CnATreeElement tmpTarget = target;
                try {
                    try {
                        tmpTarget = Retriever.retrieveElement((CnATreeElement)tmpTarget, (RetrieveInfo)new RetrieveInfo().setProperties(true));
                        if (!PasteHandler.this.isRootElement(tmpTarget) || validationList.size() == 1 && PasteHandler.this.isSubTreeElement(validationList.get(0))) {
                            String jobDescription = validationList.size() == 1 && PasteHandler.this.isSubTreeElement(validationList.get(0)) ? PasteHandler.this.loadElementByUuid((String)validationList.get(0)).getTitle() : (tmpTarget instanceof CnATreeElement ? tmpTarget.getTitle() : Messages.getString("PasteHandler.12"));
                            monitor.beginTask(NLS.bind((String)Messages.getString("PasteHandler.11"), (Object[])new Object[]{jobDescription}), -1);
                            String uuid = !PasteHandler.this.isRootElement(tmpTarget) ? tmpTarget.getUuid() : (String)validationList.get(0);
                            ServiceFactory.lookupValidationService().createValidationsForSubTreeByUuid(uuid);
                            CnAElementFactory.getModel(PasteHandler.this.loadElementByUuid(uuid)).validationAdded(PasteHandler.this.loadElementByUuid(uuid).getScopeId());
                        } else {
                            for (String uuid : validationList) {
                                monitor.beginTask(NLS.bind((String)Messages.getString("PasteHandler.11"), (Object[])new Object[]{PasteHandler.this.loadElementByUuid(uuid).getTitle()}), -1);
                                ServiceFactory.lookupValidationService().createValidationByUuid(uuid);
                                CnAElementFactory.getModel(PasteHandler.this.loadElementByUuid(uuid)).validationAdded(PasteHandler.this.loadElementByUuid(uuid).getScopeId());
                            }
                            if (validationList != null && !validationList.isEmpty()) {
                                CnAElementFactory.getModel(PasteHandler.this.loadElementByUuid((String)validationList.get(0))).validationAdded(PasteHandler.this.loadElementByUuid((String)validationList.get(0)).getScopeId());
                            }
                        }
                    }
                    catch (Exception e) {
                        LOG.error((Object)"Exception while executing createValidationsJob", (Throwable)e);
                        monitor.done();
                    }
                }
                finally {
                    monitor.done();
                }
                return status;
            }
        };
        JobScheduler.scheduleJob(validationCreationJob, new Mutex());
    }

    private void cut(final CnATreeElement target, List cutList) throws InvocationTargetException, InterruptedException {
        if (cutList.get(0) instanceof CnATreeElement && target != null) {
            CutOperation operation = new CutOperation(target, cutList);
            operation.setInheritPermissions(this.inheritPermissions());
            IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
            progressService.run(true, true, (IRunnableWithProgress)operation);
            InfoDialogWithShowToggle.openInformation(Messages.getString("PasteHandler.7"), NLS.bind((String)Messages.getString("PasteHandler.8"), (Object)operation.getNumberOfElements(), (Object)target.getTitle()), Messages.getString("PasteHandler.9"), "info_elements_cut");
            if (Activator.getDefault().getPreferenceStore().getBoolean("use_automatic_validation")) {
                final List<ElementChange> changes = operation.getChanges();
                WorkspaceJob validationCreationJob = new WorkspaceJob(Messages.getString("PasteHandler.5")){

                    public IStatus runInWorkspace(IProgressMonitor monitor) {
                        Activator.inheritVeriniceContextState();
                        IStatus status = Status.OK_STATUS;
                        try {
                            try {
                                String jobDescription;
                                String string = changes.size() == 1 && PasteHandler.this.isSubTreeElement(((ElementChange)changes.get(0)).getElement()) ? ((ElementChange)changes.get(0)).getElement().getTitle() : (jobDescription = target instanceof CnATreeElement ? target.getTitle() : Messages.getString("PasteHandler.12"));
                                if (!PasteHandler.this.isRootElement(target) || changes.size() == 1 && PasteHandler.this.isSubTreeElement(((ElementChange)changes.get(0)).getElement())) {
                                    monitor.beginTask(NLS.bind((String)Messages.getString("PasteHandler.11"), (Object[])new Object[]{jobDescription}), -1);
                                    CnATreeElement elmt = !PasteHandler.this.isRootElement(target) ? target : ((ElementChange)changes.get(0)).getElement();
                                    ServiceFactory.lookupValidationService().createValidationsForSubTreeByUuid(elmt.getUuid());
                                    CnAElementFactory.getModel(elmt).validationAdded(elmt.getScopeId());
                                } else {
                                    for (ElementChange ec : changes) {
                                        monitor.beginTask(NLS.bind((String)Messages.getString("PasteHandler.11"), (Object[])new Object[]{ec.getElement().getTitle()}), -1);
                                        ServiceFactory.lookupValidationService().createValidationByUuid(ec.getElement().getUuid());
                                    }
                                    if (changes != null && !changes.isEmpty()) {
                                        CnAElementFactory.getModel(((ElementChange)changes.get(0)).getElement()).validationAdded(((ElementChange)changes.get(0)).getElement().getScopeId());
                                    }
                                }
                            }
                            catch (Exception e) {
                                LOG.error((Object)"Exception while executing createValidationsJob", (Throwable)e);
                                monitor.done();
                            }
                        }
                        finally {
                            monitor.done();
                        }
                        return status;
                    }
                };
                JobScheduler.scheduleJob(validationCreationJob, new Mutex());
            }
        }
    }

    private IProgressRunnable createOperation(CnATreeElement target, List copyList, CopyLinksCommand.CopyLinksMode copyLinksMode) {
        IProgressRunnable operation = null;
        if (copyList != null && !copyList.isEmpty()) {
            if (copyList.get(0) instanceof CnATreeElement) {
                operation = new CopyTreeElements(target, copyList, copyLinksMode);
                operation.setCopyAttachments(Activator.getDefault().getPreferenceStore().getBoolean("copy_attachments_with_objects"));
            }
            if (copyList.get(0) instanceof Baustein) {
                operation = new CopyBausteine(target, (List<Baustein>)copyList);
            }
        }
        return operation;
    }

    private boolean isRootElement(CnATreeElement elmt) {
        return elmt instanceof BSIModel || elmt instanceof ISO27KModel || elmt instanceof BpModel || elmt instanceof CatalogModel || elmt instanceof ImportBsiGroup || elmt instanceof ImportIsoGroup;
    }

    private boolean isSubTreeElement(Object elmt) {
        if (elmt instanceof String) {
            elmt = this.loadElementByUuid((String)elmt);
        }
        return elmt instanceof IISO27kGroup || elmt instanceof IBSIStrukturKategorie || elmt instanceof CnATreeElement && ((CnATreeElement)elmt).isScope();
    }

    private CnATreeElement loadElementByUuid(String uuid) {
        LoadElementByUuid elementLoader = new LoadElementByUuid(uuid, new RetrieveInfo().setProperties(true));
        try {
            elementLoader = (LoadElementByUuid)ServiceFactory.lookupCommandService().executeCommand((ICommand)elementLoader);
        }
        catch (CommandException e) {
            LOG.error((Object)"Error while determing element by uuid", (Throwable)e);
        }
        return elementLoader.getElement();
    }

    private boolean inheritPermissions() {
        return Activator.getDefault().getPreferenceStore().getBoolean("cut_inherit_permissions");
    }
}

