/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.iso27k.rcp.action;

import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.swt.dnd.TransferData;
import sernet.verinice.iso27k.rcp.action.DropPerformer;

public class MetaDropAdapter
extends ViewerDropAdapter {
    private static final Logger LOG = Logger.getLogger(MetaDropAdapter.class);
    private Set<DropPerformer> performerSet = new HashSet<DropPerformer>();

    public MetaDropAdapter(Viewer viewer) {
        super(viewer);
    }

    public void addAdapter(DropPerformer adapter) {
        this.performerSet.add(adapter);
    }

    public void removeAdapter(DropPerformer adapter) {
        this.performerSet.remove(adapter);
    }

    public void clear() {
        this.performerSet.clear();
    }

    public boolean performDrop(Object data) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"performDrop...");
        }
        boolean success = false;
        try {
            for (DropPerformer adapter : this.performerSet) {
                if (adapter.isActive()) {
                    if (!adapter.performDrop(data, this.getCurrentTarget(), this.getViewer())) continue;
                    success = true;
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)("performDrop, success: " + adapter.getClass().getName()));
                    continue;
                }
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("performDrop, adapter is not active: " + adapter.getClass().getName()));
            }
        }
        catch (RuntimeException e) {
            LOG.error((Object)"Error while performing drop.", (Throwable)e);
            throw e;
        }
        return success;
    }

    public boolean validateDrop(Object target, int operation, TransferData transferType) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"validateDrop...");
        }
        boolean success = false;
        for (DropPerformer adapter : this.performerSet) {
            boolean valid = adapter.validateDrop(target, operation, transferType);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("\tAdapter: " + adapter.getClass().getCanonicalName()));
                LOG.debug((Object)("\tTarget: " + target.getClass().getCanonicalName() + ", Transfertype: " + transferType.toString()));
                LOG.debug((Object)("\tValid: " + String.valueOf(valid)));
            }
            if (!valid) continue;
            success = true;
        }
        return success;
    }
}

