/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.iso27k.rcp.action;

import org.apache.log4j.Logger;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import sernet.gs.ui.rcp.main.Activator;
import sernet.gs.ui.rcp.main.ExceptionUtil;
import sernet.gs.ui.rcp.main.Messages;
import sernet.gs.ui.rcp.main.bsi.editors.EditorUtil;
import sernet.gs.ui.rcp.main.common.model.CnAElementFactory;
import sernet.gs.ui.rcp.main.common.model.ProgressAdapter;
import sernet.verinice.interfaces.IInternalServer;
import sernet.verinice.iso27k.rcp.JobScheduler;
import sernet.verinice.rcp.StatusResult;

public class Initializer
implements IStartup {
    private static final Logger log = Logger.getLogger(Initializer.class);

    public void earlyStartup() {
        this.registerEditorCleaner();
        StatusResult result = Initializer.startServer();
        Initializer.createModel(JobScheduler.getInitMutex(), result);
    }

    public static StatusResult startServer() {
        return Initializer.startServer(new StatusResult());
    }

    private static StatusResult startServer(final StatusResult result) {
        final IInternalServer internalServer = Activator.getDefault().getInternalServer();
        if (!internalServer.isRunning()) {
            WorkspaceJob job = new WorkspaceJob(""){

                public IStatus runInWorkspace(IProgressMonitor monitor) {
                    block6: {
                        Activator.inheritVeriniceContextState();
                        try {
                            try {
                                if (!internalServer.isRunning()) {
                                    monitor.beginTask(Messages.Activator_1, -1);
                                    internalServer.start();
                                }
                                result.status = Status.OK_STATUS;
                            }
                            catch (Exception e) {
                                ExceptionUtil.log(e, Messages.Activator_2);
                                result.status = new Status(4, "sernet.gs.ui.rcp.main", Messages.Activator_3, (Throwable)e);
                                monitor.done();
                                break block6;
                            }
                        }
                        catch (Throwable throwable) {
                            monitor.done();
                            throw throwable;
                        }
                        monitor.done();
                    }
                    return result.status;
                }
            };
            JobScheduler.scheduleJob(job, JobScheduler.getInitMutex(), JobScheduler.getInitProgressMonitor());
        } else {
            result.status = Status.OK_STATUS;
        }
        return result;
    }

    public static void createModel() {
        Initializer.createModel(JobScheduler.getInitMutex(), new StatusResult());
    }

    public static void createModel(ISchedulingRule mutex, final StatusResult serverStartResult) {
        WorkspaceJob job = new WorkspaceJob(Messages.Activator_LoadModel){

            public IStatus runInWorkspace(IProgressMonitor monitor) {
                IStatus status = Status.OK_STATUS;
                try {
                    try {
                        if (serverStartResult.status == Status.CANCEL_STATUS) {
                            status = Status.CANCEL_STATUS;
                        }
                        Activator.inheritVeriniceContextState();
                        monitor.beginTask(Messages.Activator_LoadModel, -1);
                        monitor.setTaskName(Messages.Activator_LoadModel);
                        CnAElementFactory.getInstance().loadOrCreateModel(new ProgressAdapter(monitor));
                        CnAElementFactory.getInstance().getISO27kModel();
                        CnAElementFactory.getInstance().getBpModel();
                        CnAElementFactory.getInstance().getCatalogModel();
                    }
                    catch (Exception e) {
                        log.error((Object)"Error while loading model.", (Throwable)e);
                        if (e.getCause() != null && e.getCause().getLocalizedMessage() != null) {
                            this.setName(e.getCause().getLocalizedMessage());
                        }
                        status = new Status(4, "sernet.gs.ui.rcp.main", Messages.Activator_31, (Throwable)e);
                        monitor.done();
                    }
                }
                finally {
                    monitor.done();
                }
                return status;
            }
        };
        JobScheduler.scheduleJob(job, mutex, JobScheduler.getInitProgressMonitor());
    }

    private void registerEditorCleaner() {
        final IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        if (window != null) {
            EditorUtil.cleanOldEditors();
        } else {
            workbench.addWindowListener(new IWindowListener(){

                public void windowOpened(IWorkbenchWindow window) {
                }

                public void windowDeactivated(IWorkbenchWindow window) {
                }

                public void windowClosed(IWorkbenchWindow window) {
                }

                public void windowActivated(IWorkbenchWindow window) {
                    EditorUtil.cleanOldEditors();
                    workbench.removeWindowListener((IWindowListener)this);
                }
            });
        }
    }
}

