/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.iso27k.rcp.action;

import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import sernet.verinice.model.bp.IBpGroup;
import sernet.verinice.model.common.CnATreeElement;
import sernet.verinice.model.iso27k.Asset;
import sernet.verinice.model.iso27k.Audit;
import sernet.verinice.model.iso27k.IISO27kGroup;

public class HideEmptyFilter
extends ViewerFilter {
    private static final Logger LOG = Logger.getLogger(HideEmptyFilter.class);
    private StructuredViewer viewer;
    private boolean hideEmpty;

    public HideEmptyFilter(StructuredViewer viewer) {
        this.viewer = viewer;
    }

    public boolean select(Viewer viewer, Object parentElement, Object o) {
        boolean visible = true;
        try {
            boolean isIsoOrCnaTreeElement;
            boolean bl = isIsoOrCnaTreeElement = o instanceof IISO27kGroup && o instanceof CnATreeElement && !(o instanceof Audit) && !(o instanceof Asset);
            if (this.hideEmpty && (isIsoOrCnaTreeElement || o instanceof IBpGroup)) {
                CnATreeElement element = (CnATreeElement)o;
                Set children = element.getChildren();
                visible = children != null && !children.isEmpty();
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error", (Throwable)e);
        }
        return visible;
    }

    public void setHideEmpty(boolean hideEmpty) {
        if (this.hideEmpty != hideEmpty) {
            this.hideEmpty = hideEmpty;
            if (this.hideEmpty) {
                this.viewer.addFilter((ViewerFilter)this);
            } else {
                this.viewer.removeFilter((ViewerFilter)this);
            }
            this.viewer.refresh();
        }
    }

    public boolean isHideEmpty() {
        return this.hideEmpty;
    }

    public boolean isActive() {
        return this.isHideEmpty();
    }
}

