/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.iso27k.rcp.action;

import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.part.IDropActionDelegate;
import org.eclipse.ui.part.PluginDropAdapter;
import org.eclipse.ui.part.PluginTransferData;
import sernet.verinice.iso27k.rcp.action.DropPerformer;
import sernet.verinice.model.iso27k.Group;

public class FileDropPerformer
extends PluginDropAdapter
implements DropPerformer {
    private static final Logger LOG = Logger.getLogger(FileDropPerformer.class);
    private boolean isActive = false;
    private Group group = null;

    public FileDropPerformer(TreeViewer viewer) {
        super((StructuredViewer)viewer);
    }

    @Override
    public boolean performDrop(Object data, Object target, Viewer viewer) {
        return this.performDrop(data);
    }

    @Override
    public boolean validateDrop(Object target, int operation, TransferData data) {
        boolean bl = this.isActive = FileTransfer.getInstance().isSupportedType(data) && target instanceof Group;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Target: " + target));
            LOG.debug((Object)("validateDrop: " + this.isActive));
        }
        this.group = this.isActive ? (Group)target : null;
        return this.isActive;
    }

    @Override
    public boolean isActive() {
        return this.isActive;
    }

    public boolean performDrop(Object data) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"performDrop... ");
        }
        try {
            ByteArrayOutputStream bao = new ByteArrayOutputStream();
            ObjectOutputStream oo = new ObjectOutputStream(bao);
            oo.writeObject(data);
            PluginTransferData pluginData = new PluginTransferData("sernet.verinice.ismview.filedrop", bao.toByteArray());
            IDropActionDelegate delegate = FileDropPerformer.getPluginAdapter(pluginData);
            if (delegate != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Drop adapter found in plugin.xml: " + delegate.getClass().getName() + ", group: " + this.group));
                }
                delegate.run((Object)pluginData.getData(), (Object)this.group);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error while performing file drop", (Throwable)e);
        }
        return false;
    }

    protected static IDropActionDelegate getPluginAdapter(PluginTransferData data) throws CoreException {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        String adapterName = data.getExtensionId();
        IExtensionPoint xpt = registry.getExtensionPoint("org.eclipse.ui", "dropActions");
        IExtension[] extensions = xpt.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] configs = extensions[i].getConfigurationElements();
            if (configs != null && configs.length > 0) {
                int j = 0;
                while (j < configs.length) {
                    String id = configs[j].getAttribute("id");
                    if (id != null && id.equals(adapterName)) {
                        return (IDropActionDelegate)WorkbenchPlugin.createExtension((IConfigurationElement)configs[j], (String)"class");
                    }
                    ++j;
                }
            }
            ++i;
        }
        return null;
    }
}

