/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.iso27k.rcp.action;

import java.io.File;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import sernet.gs.ui.rcp.main.Activator;
import sernet.gs.ui.rcp.main.bsi.dialogs.EncryptionDialog;
import sernet.gs.ui.rcp.main.common.model.CnAElementFactory;
import sernet.gs.ui.rcp.main.service.ServiceFactory;
import sernet.verinice.interfaces.ICommand;
import sernet.verinice.interfaces.RightEnabledUserInteraction;
import sernet.verinice.interfaces.encryption.EncryptionException;
import sernet.verinice.interfaces.encryption.IEncryptionService;
import sernet.verinice.iso27k.rcp.ExportDialog;
import sernet.verinice.iso27k.rcp.JobScheduler;
import sernet.verinice.iso27k.rcp.Mutex;
import sernet.verinice.iso27k.rcp.action.ExportJobChangeListener;
import sernet.verinice.iso27k.rcp.action.Messages;
import sernet.verinice.model.common.CnATreeElement;
import sernet.verinice.rcp.RightsEnabledActionDelegate;
import sernet.verinice.service.commands.ExportCommand;

public class ExportAction
extends RightsEnabledActionDelegate
implements IViewActionDelegate,
IWorkbenchWindowActionDelegate,
RightEnabledUserInteraction {
    public static final String ID = "sernet.verinice.samt.rcp.ExportSelfAssessment";
    private static final Logger LOG = Logger.getLogger(ExportAction.class);
    public static final String EXTENSION_XML = ".xml";
    public static final String EXTENSION_PASSWORD_ENCRPTION = ".pcr";
    private ExportDialog dialog;
    private String filePath;
    private char[] password = null;
    private static ISchedulingRule iSchedulingRule = new Mutex();
    private ITreeSelection selection;

    public void init(IViewPart view) {
    }

    public void init(IWorkbenchWindow window) {
    }

    @Override
    public void doRun(IAction action) {
        Shell shell = Display.getCurrent().getActiveShell();
        this.dialog = new ExportDialog(shell, this.selection);
        if (this.dialog.open() == 0) {
            if (this.dialog.getEncryptOutput() && 1 == this.openEncryptionDialog()) {
                return;
            }
            this.filePath = this.dialog.getFilePath();
            this.filePath = ExportAction.addExtension(this.filePath, ExportDialog.getExtensionArray()[this.dialog.getFormat()]);
            if (this.password != null) {
                this.filePath = ExportAction.addExtension(this.filePath, EXTENSION_PASSWORD_ENCRPTION);
            }
            WorkspaceJob exportJob = new WorkspaceJob("Exporting..."){

                public IStatus runInWorkspace(IProgressMonitor monitor) {
                    IStatus status = Status.OK_STATUS;
                    try {
                        try {
                            monitor.beginTask(NLS.bind((String)Messages.getString("ExportAction_4"), (Object[])new Object[]{ExportAction.this.dialog.getFilePath()}), -1);
                            ExportAction.this.export();
                        }
                        catch (Exception e) {
                            LOG.error((Object)"Error while exporting data.", (Throwable)e);
                            status = new Status(4, "sernet.verinice.samt.rcp", "Error while exporting data.", (Throwable)e);
                            ExportAction.this.password = null;
                            monitor.done();
                            this.done(status);
                        }
                    }
                    finally {
                        ExportAction.this.password = null;
                        monitor.done();
                        this.done(status);
                    }
                    return status;
                }
            };
            exportJob.addJobChangeListener((IJobChangeListener)new ExportJobChangeListener(shell, this.filePath, this.dialog.getSelectedElement().getTitle()));
            JobScheduler.scheduleJob(exportJob, iSchedulingRule);
        }
    }

    private void export() {
        String internalSourceId = null;
        int uuidStringLength = 6;
        if (this.getElementSet() != null && !this.getElementSet().isEmpty()) {
            internalSourceId = this.getSourceId() == null || this.getSourceId().isEmpty() ? UUID.randomUUID().toString().substring(0, 6) : this.getSourceId();
            Activator.inheritVeriniceContextState();
            ExportCommand exportCommand = Activator.getDefault().isStandalone() && !this.isEncryption() ? new ExportCommand(new LinkedList<CnATreeElement>(this.getElementSet()), internalSourceId, this.isReImport(), Integer.valueOf(this.getFileFormat())) : new ExportCommand(new LinkedList<CnATreeElement>(this.getElementSet()), internalSourceId, this.isReImport(), Integer.valueOf(this.getFileFormat()));
            try {
                boolean exportRiskAnalysis = Activator.getDefault().getPreferenceStore().getBoolean("export_risk_analysis");
                exportCommand.setExportRiskAnalysis(exportRiskAnalysis);
                exportCommand = (ExportCommand)ServiceFactory.lookupCommandService().executeCommand((ICommand)exportCommand);
                if (exportCommand.getResult() != null) {
                    if (this.isEncryption()) {
                        String salt = RandomStringUtils.random((int)8, (boolean)true, (boolean)true);
                        byte[] saltBytes = salt.getBytes("UTF-8");
                        byte[] cypherTextBytes = this.encrypt(exportCommand.getResult(), saltBytes);
                        FileUtils.writeByteArrayToFile((File)new File(this.filePath), (byte[])cypherTextBytes);
                    } else {
                        FileUtils.writeByteArrayToFile((File)new File(this.filePath), (byte[])exportCommand.getResult());
                    }
                }
                this.updateModel(exportCommand.getChangedElements());
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
    }

    private void updateModel(List<CnATreeElement> changedElementList) {
        int maxChangedElements = 9;
        if (changedElementList != null && !changedElementList.isEmpty()) {
            if (changedElementList.size() > 9) {
                CnAElementFactory.getInstance().reloadAllModelsFromDatabase();
            } else {
                for (CnATreeElement cnATreeElement : changedElementList) {
                    CnAElementFactory.getModel(cnATreeElement).childChanged(cnATreeElement);
                    CnAElementFactory.getModel(cnATreeElement).databaseChildChanged(cnATreeElement);
                }
            }
        }
    }

    private int openEncryptionDialog() {
        EncryptionDialog encDialog = new EncryptionDialog(Display.getDefault().getActiveShell());
        if (encDialog.open() == 0) {
            this.password = encDialog.getEnteredPassword();
            return 0;
        }
        return 1;
    }

    private byte[] encrypt(byte[] result, byte[] salt) throws EncryptionException {
        IEncryptionService service = ServiceFactory.lookupEncryptionService();
        byte[] cypherTextBytes = this.password != null ? service.encrypt(result, this.password, salt) : result;
        return cypherTextBytes;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (this.isServerRunning()) {
            action.setEnabled(this.checkRights());
        }
        if (selection instanceof ITreeSelection) {
            ITreeSelection treeSelection = (ITreeSelection)selection;
            Object selectedElement = treeSelection.getFirstElement();
            for (Object obj : treeSelection) {
                if (!(obj instanceof CnATreeElement) || ((CnATreeElement)obj).isScope()) continue;
                if (this.selection != null) {
                    this.selection = null;
                }
                return;
            }
            if (selectedElement instanceof CnATreeElement && ((CnATreeElement)selectedElement).isScope()) {
                this.selection = treeSelection;
            }
        }
    }

    public static String addExtension(String exportPath, String extension) {
        if (exportPath != null && !exportPath.isEmpty() && !exportPath.endsWith(extension)) {
            return String.valueOf(exportPath) + extension;
        }
        return exportPath;
    }

    private Set<CnATreeElement> getElementSet() {
        return this.dialog.getSelectedElementSet();
    }

    private boolean isReImport() {
        return this.dialog.getReImport();
    }

    private boolean isEncryption() {
        return this.dialog.getEncryptOutput();
    }

    private String getSourceId() {
        return this.dialog.getSourceId();
    }

    private int getFileFormat() {
        return this.dialog.getFormat();
    }

    public String getRightID() {
        return "xmlexport";
    }
}

