/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.iso27k.rcp.action;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import sernet.verinice.model.common.CnATreeElement;

public class ExpandAction
extends Action
implements ISelectionChangedListener {
    private static final Logger LOG = Logger.getLogger(ExpandAction.class);
    private TreeViewer viewer;
    private CnATreeElement selectedElement;
    private ITreeContentProvider contentProvider;

    public ExpandAction(TreeViewer viewer, ITreeContentProvider contentProvider) {
        this.viewer = viewer;
        this.contentProvider = contentProvider;
    }

    public void run() {
        CnATreeElement parent;
        ArrayList<Object> expandedElements = new ArrayList<Object>();
        CnATreeElement element = this.selectedElement;
        expandedElements.add(element);
        while ((parent = (CnATreeElement)this.contentProvider.getParent((Object)element)) != null) {
            element = parent;
            expandedElements.add(element);
        }
        element = this.selectedElement;
        this.addChildren(element, expandedElements);
        this.viewer.setExpandedElements(expandedElements.toArray());
    }

    public void selectionChanged(SelectionChangedEvent event) {
        Object sel;
        ISelection selection = event.getSelection();
        if (selection instanceof IStructuredSelection && (sel = ((IStructuredSelection)selection).getFirstElement()) instanceof CnATreeElement) {
            this.selectedElement = (CnATreeElement)sel;
        }
    }

    private void addChildren(CnATreeElement element, List<Object> expandedElements) {
        Object[] children = this.contentProvider.getChildren((Object)element);
        if (children != null && children.length > 0) {
            expandedElements.addAll(Arrays.asList(children));
            Object[] objectArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Object child = objectArray[n2];
                if (child instanceof CnATreeElement) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("child: " + ((CnATreeElement)child).getTitle()));
                    }
                    this.addChildren((CnATreeElement)child, expandedElements);
                }
                ++n2;
            }
        }
    }
}

