/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.iso27k.rcp.action;

import java.lang.reflect.InvocationTargetException;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionDelegate;
import sernet.gs.ui.rcp.main.Activator;
import sernet.gs.ui.rcp.main.common.model.CnAElementFactory;
import sernet.gs.ui.rcp.main.service.ServiceFactory;
import sernet.hui.common.VeriniceContext;
import sernet.springclient.RightsServiceClient;
import sernet.verinice.interfaces.CommandException;
import sernet.verinice.interfaces.ICommand;
import sernet.verinice.interfaces.IInternalServerStartListener;
import sernet.verinice.interfaces.InternalServerEvent;
import sernet.verinice.interfaces.RightEnabledUserInteraction;
import sernet.verinice.iso27k.rcp.action.Messages;
import sernet.verinice.model.common.CnATreeElement;
import sernet.verinice.model.iso27k.ControlGroup;
import sernet.verinice.rcp.InfoDialogWithShowToggle;
import sernet.verinice.service.commands.DeriveStatusCommand;

public class DeriveStatusAction
extends ActionDelegate
implements IViewActionDelegate,
IWorkbenchWindowActionDelegate,
RightEnabledUserInteraction {
    private static final Logger LOG = Logger.getLogger(DeriveStatusAction.class);
    public static final String ID = "sernet.verinice.iso27k.rcp.action.DeriveStatusAction";
    private boolean serverIsRunning = true;
    private List<ControlGroup> selectedGroups;
    private int samtCount = 0;
    private int measureCount = 0;

    public boolean checkRights() {
        RightsServiceClient service = (RightsServiceClient)VeriniceContext.get((String)"rightsService");
        return service.isEnabled(this.getRightID());
    }

    public String getRightID() {
        return "derivestatus";
    }

    public void init(IWorkbenchWindow arg0) {
    }

    public void init(IViewPart arg0) {
    }

    public void init(final IAction action) {
        if (Activator.getDefault().isStandalone() && !Activator.getDefault().getInternalServer().isRunning()) {
            this.serverIsRunning = false;
            IInternalServerStartListener listener = new IInternalServerStartListener(){

                public void statusChanged(InternalServerEvent e) {
                    if (e.isStarted()) {
                        DeriveStatusAction.this.serverIsRunning = true;
                        action.setEnabled(DeriveStatusAction.this.checkRights());
                    }
                }
            };
            Activator.getDefault().getInternalServer().addInternalServerStatusListener(listener);
        } else {
            action.setEnabled(this.checkRights());
        }
    }

    public void run(IAction action) {
        if (this.selectedGroups != null && !this.selectedGroups.isEmpty()) {
            String title = this.selectedGroups.get(0).getTitle();
            boolean confirm = MessageDialog.openConfirm((Shell)Display.getDefault().getActiveShell(), (String)Messages.getString("DeriveStatus.1"), (String)NLS.bind((String)Messages.getString("DeriveStatus.2"), (Object)title));
            if (!confirm) {
                return;
            }
            try {
                PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        monitor.beginTask(Messages.getString("DeriveStatus.3"), -1);
                        DeriveStatusAction.this.derivateStatus();
                        monitor.done();
                    }
                });
                InfoDialogWithShowToggle.openInformation(Messages.getString("DeriveStatus.1"), NLS.bind((String)Messages.getString("DeriveStatus.4"), (Object[])new Object[]{this.measureCount, this.samtCount}), Messages.getString("DeriveStatus.6"), "info_status_derived");
            }
            catch (Exception e) {
                String message = Messages.getString("DeriveStatusAction.6");
                LOG.error((Object)message, (Throwable)e);
                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)Messages.getString("DeriveStatusAction.7"), (String)message);
            }
        }
    }

    private void derivateStatus() {
        try {
            Activator.inheritVeriniceContextState();
            this.samtCount = 0;
            this.measureCount = 0;
            boolean update = false;
            for (ControlGroup group : this.selectedGroups) {
                DeriveStatusCommand command = new DeriveStatusCommand((CnATreeElement)group);
                command = (DeriveStatusCommand)ServiceFactory.lookupCommandService().executeCommand((ICommand)command);
                if (!command.getChangedElements().isEmpty()) {
                    update = true;
                }
                this.samtCount += command.getSamtTopicCount();
                this.measureCount += command.getMeasureCount();
            }
            if (update) {
                this.updateModel();
            }
        }
        catch (CommandException e) {
            LOG.error((Object)"Error while derivating status.", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (this.serverIsRunning) {
            action.setEnabled(this.checkRights());
        }
        this.selectedGroups = new LinkedList<ControlGroup>();
        if (selection instanceof ITreeSelection) {
            ITreeSelection treeSelection = (ITreeSelection)selection;
            for (Object selected : treeSelection) {
                if (!(selected instanceof ControlGroup)) continue;
                this.selectedGroups.add((ControlGroup)selected);
            }
        }
    }

    private void updateModel() {
        CnAElementFactory.getInstance().reloadAllModelsFromDatabase();
    }
}

