/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.iso27k.rcp.action;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;
import sernet.gs.ui.rcp.main.service.ServiceFactory;
import sernet.verinice.interfaces.CommandException;
import sernet.verinice.interfaces.ICommand;
import sernet.verinice.iso27k.rcp.CnPItems;
import sernet.verinice.iso27k.rcp.action.CopyHandler;
import sernet.verinice.iso27k.rcp.action.Messages;
import sernet.verinice.model.common.CnALink;
import sernet.verinice.model.common.CnATreeElement;
import sernet.verinice.service.commands.ValidateLinksInSubtrees;

public class CopyWithLinksHandler
extends CopyHandler {
    private static final int ERROR_MESSAGE_LINK_CUTOFF = 5;

    @Override
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IStructuredSelection selectedElements = HandlerUtil.getCurrentStructuredSelection((ExecutionEvent)event);
        if (!selectedElements.isEmpty()) {
            HashSet<String> selectedElementsUUIDs = new HashSet<String>(selectedElements.size());
            for (Object selectedElement : selectedElements.toList()) {
                if (!(selectedElement instanceof CnATreeElement)) continue;
                selectedElementsUUIDs.add(((CnATreeElement)selectedElement).getUuid());
            }
            ValidateLinksInSubtrees validateLinksInSubtrees = new ValidateLinksInSubtrees(selectedElementsUUIDs);
            try {
                validateLinksInSubtrees = (ValidateLinksInSubtrees)ServiceFactory.lookupCommandService().executeCommand((ICommand)validateLinksInSubtrees);
                Set invalidLinks = validateLinksInSubtrees.getInvalidLinks();
                if (!invalidLinks.isEmpty()) {
                    CopyWithLinksHandler.showInvalidLinksMessage(invalidLinks);
                    throw new ExecutionException("Found " + invalidLinks.size() + " invalid link(s): " + invalidLinks);
                }
            }
            catch (CommandException e) {
                throw new ExecutionException("Could not check links", (Throwable)e);
            }
        }
        Object result = super.execute(event);
        CnPItems.setCopyLinks(true);
        return result;
    }

    private static void showInvalidLinksMessage(Set<CnALink> invalidLinks) {
        StringBuilder dialogMessageBuilder = new StringBuilder(Messages.getString("InvalidLinksDialogMessage")).append("\n");
        invalidLinks.stream().limit(5L).forEach(link -> {
            StringBuilder stringBuilder2 = dialogMessageBuilder.append("\n - ").append(link.getDependant().getTitle()).append(" \u2192 ").append(link.getDependency().getTitle()).append(" (").append(link.getRelationId()).append(")");
        });
        if (invalidLinks.size() > 5) {
            dialogMessageBuilder.append("\n...");
        }
        MessageDialog.openError(null, (String)Messages.getString("InvalidLinksDialogTitle"), (String)dialogMessageBuilder.toString());
    }
}

