/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.iso27k.rcp.action;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import sernet.gs.ui.rcp.main.bsi.dnd.DNDHelper;
import sernet.gs.ui.rcp.main.bsi.dnd.DNDItems;
import sernet.gs.ui.rcp.main.bsi.dnd.transfer.ItemTransfer;
import sernet.verinice.interfaces.iso27k.IItem;
import sernet.verinice.service.iso27k.Item;

public class ControlDragListener
implements DragSourceListener {
    private static final Logger LOG = Logger.getLogger(ControlDragListener.class);
    TreeViewer viewer;
    List<IItem> dragedItemList = new ArrayList<IItem>();

    public ControlDragListener(TreeViewer viewer) {
        this.viewer = viewer;
    }

    public void dragStart(DragSourceEvent event) {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        this.dragedItemList.clear();
        event.doit = true;
        for (Object o : selection) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("dragStart, selected element: " + o));
            }
            if (!(o instanceof IItem)) {
                event.doit = false;
                continue;
            }
            this.dragedItemList.add((IItem)o);
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)("dragStart, added to dragedItemList: " + ((IItem)o).getName()));
        }
    }

    public void dragSetData(DragSourceEvent event) {
        try {
            IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
            if (ItemTransfer.getInstance().isSupportedType(event.dataType)) {
                if (selection.getFirstElement() instanceof Item) {
                    event.data = DNDHelper.castDataArray(selection.toArray());
                } else {
                    event.data = DNDItems.CNAITEM;
                    LOG.error((Object)"Something went wrong here");
                }
            }
        }
        catch (Exception t) {
            LOG.error((Object)"error", (Throwable)t);
        }
    }

    public void dragFinished(DragSourceEvent event) {
        this.dragedItemList.clear();
    }
}

