/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.iso27k.rcp.action;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;
import sernet.gs.model.Baustein;
import sernet.gs.model.Gefaehrdung;
import sernet.gs.model.Massnahme;
import sernet.gs.ui.rcp.main.Activator;
import sernet.gs.ui.rcp.main.ExceptionUtil;
import sernet.gs.ui.rcp.main.bsi.dnd.transfer.IGSModelElementTransfer;
import sernet.gs.ui.rcp.main.bsi.dnd.transfer.ItemTransfer;
import sernet.gs.ui.rcp.main.common.model.CnAElementHome;
import sernet.hui.common.VeriniceContext;
import sernet.springclient.RightsServiceClient;
import sernet.verinice.interfaces.RightEnabledUserInteraction;
import sernet.verinice.interfaces.iso27k.IItem;
import sernet.verinice.iso27k.rcp.GS2BSITransformOperation;
import sernet.verinice.iso27k.rcp.action.DropPerformer;
import sernet.verinice.iso27k.rcp.action.Messages;
import sernet.verinice.iso27k.service.ItemTransformException;
import sernet.verinice.model.common.CnATreeElement;
import sernet.verinice.model.iso27k.Group;

public class BSIModelDropPerformer
extends ViewerDropAdapter
implements DropPerformer,
RightEnabledUserInteraction {
    private boolean isActive = false;
    private static final Logger LOG = Logger.getLogger(BSIModelDropPerformer.class);
    private Object target = null;

    public BSIModelDropPerformer(TreeViewer viewer) {
        super((Viewer)viewer);
    }

    public boolean performDrop(Object data) {
        if (!this.validateDropObjects(this.target, data)) {
            return false;
        }
        boolean success = this.isActive();
        if (this.isActive()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"performDrop...");
            }
            try {
                Group group = (Group)this.target;
                if (CnAElementHome.getInstance().isNewChildAllowed((CnATreeElement)group)) {
                    GS2BSITransformOperation operation = new GS2BSITransformOperation(group, data);
                    IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
                    progressService.run(true, true, (IRunnableWithProgress)operation);
                    IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();
                    boolean dontShow = preferenceStore.getBoolean("info_controls_added");
                    String objectType = "";
                    objectType = operation.isScenario() ? Messages.getString("GS2BSITransformer.1") : Messages.getString("ControlDropPerformer.2");
                    if (!dontShow) {
                        MessageDialogWithToggle dialog = MessageDialogWithToggle.openInformation((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)Messages.getString("ControlDropPerformer.1"), (String)NLS.bind((String)objectType, (Object)operation.getNumberProcessed(), (Object)((Group)this.target).getTitle()), (String)Messages.getString("ControlDropPerformer.3"), (boolean)dontShow, (IPreferenceStore)preferenceStore, (String)"info_controls_added");
                        preferenceStore.setValue("info_controls_added", dialog.getToggleState());
                    }
                } else if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"User is not allowed to add elements to this group");
                }
            }
            catch (ItemTransformException e) {
                LOG.error((Object)"Error while transforming items to controls", (Throwable)e);
                this.showException(e);
            }
            catch (InvocationTargetException e) {
                LOG.error((Object)"Error while transforming items to controls", (Throwable)e);
                Throwable t = e.getTargetException();
                if (t instanceof ItemTransformException) {
                    this.showException((ItemTransformException)t);
                } else {
                    ExceptionUtil.log(e, Messages.getString("ControlDropPerformer.5"));
                }
            }
            catch (Exception e) {
                LOG.error((Object)"Error while transforming items to controls", (Throwable)e);
                ExceptionUtil.log(e, Messages.getString("ControlDropPerformer.5"));
            }
        }
        return success;
    }

    public void drop(DropTargetEvent event) {
        if (this.target != null) {
            this.target = (CnATreeElement)this.determineTarget(event);
        }
        super.drop(event);
    }

    @Override
    public boolean validateDrop(Object target, int operation, TransferData transferType) {
        boolean valid = false;
        if (target != null) {
            this.target = target;
        }
        if (target instanceof Group && this.isSupportedData(transferType)) {
            List<String> childTypeList = Arrays.asList(((Group)target).getChildTypes());
            boolean bl = valid = childTypeList.contains("control") || childTypeList.contains("incident_scenario") || childTypeList.contains("threat") || childTypeList.contains("vulnerability");
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Group:\t" + ((Group)target).getTypeId()));
                for (String childType : childTypeList) {
                    LOG.debug((Object)("childType:\t" + childType));
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("validateDrop, target: " + ((CnATreeElement)target).getTitle() + " result: " + valid));
            LOG.debug((Object)("group:\t" + String.valueOf(target instanceof Group) + "\tsupported:\t" + this.isSupportedData(transferType)));
        }
        this.isActive = valid;
        return this.isActive;
    }

    public boolean validateDropObjects(Object target, Object data) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("validateDrop, target: " + target));
        }
        boolean valid = false;
        if (!this.checkRights()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"not sufficient rights to perform drop");
            }
            return false;
        }
        ArrayList<IItem> items = new ArrayList<IItem>(0);
        if (data instanceof Object[]) {
            Object[] o;
            Object[] objectArray = o = (Object[])data;
            int n = o.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                items.add((IItem)object);
                ++n2;
            }
        } else if (data instanceof Object) {
            items.add((IItem)data);
        }
        if (items == null || items.isEmpty()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"No items in drag list");
            }
            this.isActive = false;
            return this.isActive;
        }
        if (target instanceof Group) {
            List<String> childTypeList = Arrays.asList(((Group)target).getChildTypes());
            if (childTypeList.contains("control")) {
                valid = this.isCorrectItemsForGroup(items, "control");
            }
            if (!valid && childTypeList.contains("incident_scenario")) {
                valid = this.isCorrectItemsForGroup(items, "incident_scenario");
            }
            if (!valid && childTypeList.contains("threat")) {
                valid = this.isCorrectItemsForGroup(items, "threat");
            }
            if (!valid && childTypeList.contains("vulnerability")) {
                valid = this.isCorrectItemsForGroup(items, "vulnerability");
            }
            if (LOG.isDebugEnabled() && !valid) {
                LOG.debug((Object)"Targetgroup does not accept droppedData as children");
            }
        }
        this.isActive = valid;
        return this.isActive;
    }

    private boolean isCorrectItemsForGroup(Collection<IItem> items, String type) {
        boolean valid = false;
        try {
            for (IItem item : items) {
                if ((item instanceof Massnahme || item instanceof Baustein) && type.equals("control")) {
                    valid = true;
                }
                if (!(item instanceof Gefaehrdung) && !(item instanceof Baustein) || !type.equals("incident_scenario")) continue;
                valid = true;
            }
        }
        catch (ClassCastException e) {
            LOG.error((Object)"Wrong type of item dropped", (Throwable)e);
            valid = false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("isCorrectItemsForGroup result: " + valid));
        }
        return valid;
    }

    @Override
    public boolean isActive() {
        return this.isActive;
    }

    private void showException(ItemTransformException e) {
        String message = String.valueOf(Messages.getString("ControlDropPerformer.0")) + e.getMessage();
        MessageDialog.openError((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)Messages.getString("ControlDropPerformer.4"), (String)message);
    }

    private boolean isSupportedData(TransferData transferType) {
        return IGSModelElementTransfer.getInstance().isSupportedType(transferType) || ItemTransfer.getInstance().isSupportedType(transferType);
    }

    @Override
    public boolean performDrop(Object data, Object target, Viewer viewer) {
        return this.performDrop(data);
    }

    public boolean checkRights() {
        RightsServiceClient service = (RightsServiceClient)VeriniceContext.get((String)"rightsService");
        return service.isEnabled(this.getRightID());
    }

    public String getRightID() {
        return "bsidnd";
    }
}

