/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.iso27k.rcp.action;

import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import sernet.gs.ui.rcp.main.Activator;
import sernet.gs.ui.rcp.main.ExceptionUtil;
import sernet.gs.ui.rcp.main.ImageCache;
import sernet.gs.ui.rcp.main.bsi.editors.EditorFactory;
import sernet.gs.ui.rcp.main.common.model.CnAElementFactory;
import sernet.gs.ui.rcp.main.common.model.CnAElementHome;
import sernet.gs.ui.rcp.main.common.model.NotSufficientRightsException;
import sernet.hui.common.VeriniceContext;
import sernet.springclient.RightsServiceClient;
import sernet.verinice.interfaces.RightEnabledUserInteraction;
import sernet.verinice.iso27k.rcp.action.Messages;
import sernet.verinice.model.common.CnATreeElement;
import sernet.verinice.model.iso27k.Asset;
import sernet.verinice.model.iso27k.Audit;
import sernet.verinice.model.iso27k.IISO27kGroup;

public class AddIsaControl
implements IObjectActionDelegate,
RightEnabledUserInteraction {
    private IWorkbenchPart targetPart;
    private static final Logger LOG = Logger.getLogger(AddIsaControl.class);
    public static final Map<String, String> TITLE_FOR_TYPE = new HashMap<String, String>();

    static {
        TITLE_FOR_TYPE.put("assetgroup", Messages.getString("AddElement.0"));
        TITLE_FOR_TYPE.put("auditgroup", Messages.getString("AddElement.1"));
        TITLE_FOR_TYPE.put("controlgroup", Messages.getString("AddElement.22"));
        TITLE_FOR_TYPE.put("document_group", Messages.getString("AddElement.3"));
        TITLE_FOR_TYPE.put("evidence_group", Messages.getString("AddElement.4"));
        TITLE_FOR_TYPE.put("exceptiongroup", Messages.getString("AddElement.5"));
        TITLE_FOR_TYPE.put("finding_group", Messages.getString("AddElement.6"));
        TITLE_FOR_TYPE.put("incident_group", Messages.getString("AddElement.7"));
        TITLE_FOR_TYPE.put("incident_scenario_group", Messages.getString("AddElement.8"));
        TITLE_FOR_TYPE.put("interview_group", Messages.getString("AddElement.9"));
        TITLE_FOR_TYPE.put("persongroup", Messages.getString("AddElement.10"));
        TITLE_FOR_TYPE.put("process_group", Messages.getString("AddElement.11"));
        TITLE_FOR_TYPE.put("record_group", Messages.getString("AddElement.12"));
        TITLE_FOR_TYPE.put("requirementgroup", Messages.getString("AddElement.13"));
        TITLE_FOR_TYPE.put("response_group", Messages.getString("AddElement.14"));
        TITLE_FOR_TYPE.put("threat_group", Messages.getString("AddElement.15"));
        TITLE_FOR_TYPE.put("vulnerability_group", Messages.getString("AddElement.16"));
        TITLE_FOR_TYPE.put("asset", Messages.getString("AddElement.18"));
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.targetPart = targetPart;
    }

    public void run(IAction action) {
        block10: {
            try {
                if (this.checkRights()) {
                    Object sel = ((IStructuredSelection)this.targetPart.getSite().getSelectionProvider().getSelection()).getFirstElement();
                    CnATreeElement newElement = null;
                    if (sel instanceof IISO27kGroup) {
                        IISO27kGroup group = (IISO27kGroup)sel;
                        String childType = null;
                        if (group.getChildTypes() != null && group.getChildTypes().length > 0) {
                            childType = group.getChildTypes()[1];
                            if (group instanceof Asset) {
                                childType = "samt_topic";
                            }
                        } else {
                            LOG.error((Object)Messages.getString("AddElement.17"));
                        }
                        if (childType != null) {
                            boolean inheritIcon = Activator.getDefault().getPreferenceStore().getBoolean("inherit_special_group_icon");
                            newElement = CnAElementFactory.getInstance().saveNew((CnATreeElement)group, childType, null, inheritIcon);
                        }
                    }
                    if (newElement != null) {
                        EditorFactory.getInstance().updateAndOpenObject(newElement);
                    }
                    break block10;
                }
                throw new NotSufficientRightsException("Action not allowed for user");
            }
            catch (NotSufficientRightsException e) {
                LOG.error((Object)"Could not add element", (Throwable)e);
                ExceptionUtil.log(e, Messages.getString("AddElement.21"));
            }
            catch (Exception e) {
                LOG.error((Object)"Could not add element", (Throwable)e);
                ExceptionUtil.log(e, Messages.getString("AddElement.19"));
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        action.setEnabled(this.checkRights());
        if (selection instanceof IStructuredSelection) {
            Object sel = ((IStructuredSelection)selection).getFirstElement();
            boolean allowed = false;
            boolean enabled = false;
            if (sel instanceof CnATreeElement) {
                allowed = CnAElementHome.getInstance().isNewChildAllowed((CnATreeElement)sel);
            }
            if (sel instanceof Audit) {
                enabled = false;
                action.setText(Messages.getString("AddElement.20"));
            } else if (sel instanceof IISO27kGroup) {
                enabled = true;
                IISO27kGroup group = (IISO27kGroup)sel;
                String childType = group.getChildTypes()[1];
                if (group instanceof Asset) {
                    childType = "samt_topic";
                }
                action.setImageDescriptor(ImageDescriptor.createFromImage((Image)ImageCache.getInstance().getImageForTypeId(childType)));
                action.setText(TITLE_FOR_TYPE.get(group.getTypeId()) != null ? TITLE_FOR_TYPE.get(group.getTypeId()) : Messages.getString("AddElement.20"));
            }
            if (action.isEnabled()) {
                action.setEnabled(allowed && enabled);
            }
        }
    }

    public boolean checkRights() {
        RightsServiceClient service = (RightsServiceClient)VeriniceContext.get((String)"rightsService");
        return service.isEnabled(this.getRightID());
    }

    public String getRightID() {
        return "addismelement";
    }
}

