/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.iso27k.rcp.action;

import java.util.Optional;
import org.apache.log4j.Logger;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import sernet.gs.ui.rcp.main.Activator;
import sernet.gs.ui.rcp.main.ExceptionUtil;
import sernet.gs.ui.rcp.main.ImageCache;
import sernet.gs.ui.rcp.main.bsi.editors.EditorFactory;
import sernet.gs.ui.rcp.main.common.model.CnAElementFactory;
import sernet.gs.ui.rcp.main.common.model.CnAElementHome;
import sernet.gs.ui.rcp.main.common.model.NotSufficientRightsException;
import sernet.hui.common.VeriniceContext;
import sernet.springclient.RightsServiceClient;
import sernet.verinice.interfaces.CnATreeElementBuildException;
import sernet.verinice.interfaces.CommandException;
import sernet.verinice.interfaces.RightEnabledUserInteraction;
import sernet.verinice.iso27k.rcp.action.Messages;
import sernet.verinice.model.common.CnATreeElement;
import sernet.verinice.model.iso27k.Asset;
import sernet.verinice.model.iso27k.Audit;
import sernet.verinice.model.iso27k.Group;
import sernet.verinice.model.iso27k.IISO27kGroup;
import sernet.verinice.rcp.AddGroupMessageHelper;

public class AddGroup
extends Action
implements IObjectActionDelegate,
RightEnabledUserInteraction {
    private static final String MESSAGE_KEY_NEW_ELEMENT_GROUP = "AddGroup.19";
    private static final Logger logger = Logger.getLogger(AddGroup.class);
    private IWorkbenchPart targetPart;
    private CnATreeElement parent;
    private String typeId;

    public AddGroup() {
    }

    public AddGroup(CnATreeElement element, String typeId, String childTypeId) {
        this.parent = element;
        this.typeId = typeId;
        this.setImageDescriptor(ImageDescriptor.createFromImage((Image)ImageCache.getInstance().getImageForTypeId(childTypeId)));
        this.setText(Optional.ofNullable(AddGroupMessageHelper.getMessageForAddGroup(typeId)).orElse(Messages.getString(MESSAGE_KEY_NEW_ELEMENT_GROUP)));
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.targetPart = targetPart;
    }

    public void run() {
        if (!this.checkRights()) {
            NotSufficientRightsException e = new NotSufficientRightsException("Action not allowed for user");
            logger.error((Object)"Could not add element", (Throwable)e);
            ExceptionUtil.log(e, Messages.getString("AddElement.21"));
        } else {
            try {
                Object sel;
                if (this.targetPart != null && (sel = ((IStructuredSelection)this.targetPart.getSite().getSelectionProvider().getSelection()).getFirstElement()) instanceof Group) {
                    this.parent = (Group)sel;
                }
                if (this.parent != null) {
                    AddGroup.createNewGroup(this.parent, this.typeId);
                }
            }
            catch (Exception e) {
                logger.error((Object)"Could not add element group", (Throwable)e);
                ExceptionUtil.log(e, Messages.getString("AddGroup.18"));
            }
        }
    }

    private static void createNewGroup(CnATreeElement parent, String typeId) throws CommandException, CnATreeElementBuildException {
        String currentType = typeId;
        if (currentType == null) {
            currentType = parent.getTypeId();
            if (parent instanceof Asset) {
                currentType = "controlgroup";
            }
        }
        boolean inheritIcon = Activator.getDefault().getPreferenceStore().getBoolean("inherit_special_group_icon");
        CnATreeElement newElement = CnAElementFactory.getInstance().saveNew(parent, currentType, null, inheritIcon);
        Optional.ofNullable(newElement).ifPresent(EditorFactory.getInstance()::openEditor);
    }

    public void run(IAction action) {
        this.run();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        action.setEnabled(this.checkRights());
        if (selection instanceof IStructuredSelection) {
            Object sel = ((IStructuredSelection)selection).getFirstElement();
            boolean allowed = false;
            boolean enabled = false;
            if (sel instanceof CnATreeElement) {
                allowed = CnAElementHome.getInstance().isNewChildAllowed((CnATreeElement)sel);
            }
            if (sel instanceof Audit) {
                action.setText(Messages.getString(MESSAGE_KEY_NEW_ELEMENT_GROUP));
            } else if (sel instanceof IISO27kGroup) {
                enabled = true;
                IISO27kGroup group = (IISO27kGroup)sel;
                String typeId0 = group.getChildTypes()[0];
                if (group instanceof Asset) {
                    typeId0 = "control";
                }
                action.setImageDescriptor(ImageDescriptor.createFromImage((Image)ImageCache.getInstance().getImageForTypeId(typeId0)));
                action.setText(Optional.ofNullable(AddGroupMessageHelper.getMessageForAddGroup(group.getTypeId())).orElse(Messages.getString(MESSAGE_KEY_NEW_ELEMENT_GROUP)));
            }
            if (action.isEnabled()) {
                action.setEnabled(allowed && enabled);
            }
        }
    }

    public boolean checkRights() {
        RightsServiceClient service = (RightsServiceClient)VeriniceContext.get((String)"rightsService");
        return service.isEnabled(this.getRightID());
    }

    public String getRightID() {
        return "addismgroup";
    }
}

