/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.iso27k.rcp;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.swt.widgets.Composite;
import sernet.gs.service.NumericStringComparator;
import sernet.gs.ui.rcp.main.service.ServiceFactory;
import sernet.verinice.interfaces.CommandException;
import sernet.verinice.interfaces.ICommand;
import sernet.verinice.iso27k.rcp.Messages;
import sernet.verinice.model.bp.elements.ItNetwork;
import sernet.verinice.model.bsi.ITVerbund;
import sernet.verinice.model.common.CnATreeElement;
import sernet.verinice.model.iso27k.Organization;
import sernet.verinice.rcp.MultiselectWidget;
import sernet.verinice.service.commands.crud.LoadCnAElementByType;

public class ScopeMultiselectWidget
extends MultiselectWidget<CnATreeElement> {
    public ScopeMultiselectWidget(Composite composite, ITreeSelection selection, CnATreeElement selectedElement) throws CommandException {
        super(composite, selection, selectedElement);
        this.setTitle(Messages.SamtExportDialog_2);
    }

    public ScopeMultiselectWidget(Composite composite) throws CommandException {
        super(composite);
        this.setTitle(Messages.SamtExportDialog_2);
    }

    protected Set<Class<?>> getElementClasses() {
        HashSet elementClasses = new HashSet();
        elementClasses.add(Organization.class);
        elementClasses.add(ITVerbund.class);
        elementClasses.add(ItNetwork.class);
        return elementClasses;
    }

    @Override
    protected void initData() throws CommandException {
        this.itemList = new ArrayList();
        for (Class<CnATreeElement> clazz : this.getElementClasses()) {
            this.loadElements(clazz);
        }
        this.itemList = this.sortItems(this.itemList);
    }

    private void loadElements(Class<CnATreeElement> clazz) throws CommandException {
        LoadCnAElementByType cmdLoadOrganization = new LoadCnAElementByType(clazz);
        cmdLoadOrganization = (LoadCnAElementByType)ServiceFactory.lookupCommandService().executeCommand((ICommand)cmdLoadOrganization);
        this.itemList.addAll(cmdLoadOrganization.getElements());
    }

    @Override
    protected String getLabel(CnATreeElement elmt) {
        return elmt.getTitle();
    }

    @Override
    protected List<CnATreeElement> sortItems(List<CnATreeElement> list) {
        Collections.sort(list, new Comparator<CnATreeElement>(){

            @Override
            public int compare(CnATreeElement o1, CnATreeElement o2) {
                NumericStringComparator comparator = new NumericStringComparator();
                return comparator.compare((Object)o1.getTitle(), (Object)o2.getTitle());
            }
        });
        return list;
    }

    @Override
    public boolean isShowOnlySelected() {
        return false;
    }

    @Override
    public boolean isShowOnlySelectedCheckbox() {
        return false;
    }
}

