/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.iso27k.rcp;

import java.util.Optional;
import org.apache.log4j.Logger;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPartReference;
import sernet.verinice.iso27k.rcp.ILinkedWithEditorView;

public class LinkWithEditorPartListener
implements IPartListener2 {
    private static final Logger LOG = Logger.getLogger(LinkWithEditorPartListener.class);
    private final ILinkedWithEditorView view;

    public LinkWithEditorPartListener(ILinkedWithEditorView view) {
        this.view = view;
    }

    public void partActivated(IWorkbenchPartReference ref) {
        if (ref.getPart(true) instanceof IEditorPart) {
            if (this.view.getViewSite().getPage() == null) {
                LOG.info((Object)("partActivated ---> page is null " + this.view.getViewSite()));
                return;
            }
            IEditorPart editor = this.view.getViewSite().getPage().getActiveEditor();
            Optional.ofNullable(editor).ifPresent(this.view::editorActivated);
        }
    }

    public void partBroughtToTop(IWorkbenchPartReference ref) {
        this.refreshLinkedState(ref);
    }

    public void partOpened(IWorkbenchPartReference ref) {
        this.refreshLinkedState(ref);
    }

    public void partVisible(IWorkbenchPartReference ref) {
        this.refreshLinkedState(ref);
    }

    private void refreshLinkedState(IWorkbenchPartReference ref) {
        if (ref.getId().equals(this.view.getViewSite().getId())) {
            if (this.view.getViewSite().getPage() == null) {
                LOG.info((Object)("refreshLinkedState ---> page is null " + this.view.getViewSite()));
                return;
            }
            IEditorPart editor = this.view.getViewSite().getPage().getActiveEditor();
            if (editor != null && ref.getPart(true) == this.view) {
                this.view.editorActivated(editor);
            }
        }
    }

    public void partClosed(IWorkbenchPartReference ref) {
    }

    public void partDeactivated(IWorkbenchPartReference ref) {
    }

    public void partHidden(IWorkbenchPartReference ref) {
    }

    public void partInputChanged(IWorkbenchPartReference ref) {
    }
}

