/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.iso27k.rcp;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import sernet.gs.service.NumericStringComparator;
import sernet.gs.service.RuntimeCommandException;
import sernet.gs.ui.rcp.main.common.model.CnAElementFactory;
import sernet.gs.ui.rcp.main.service.ServiceFactory;
import sernet.verinice.interfaces.CommandException;
import sernet.verinice.interfaces.ICommand;
import sernet.verinice.interfaces.UsernameExistsException;
import sernet.verinice.interfaces.ldap.PersonParameter;
import sernet.verinice.interfaces.ldap.SizeLimitExceededException;
import sernet.verinice.iso27k.rcp.Messages;
import sernet.verinice.model.common.CnATreeElement;
import sernet.verinice.model.common.Domain;
import sernet.verinice.rcp.InfoDialogWithShowToggle;
import sernet.verinice.service.ldap.LoadLdapUser;
import sernet.verinice.service.ldap.PersonInfo;
import sernet.verinice.service.ldap.SaveLdapUser;
import sernet.verinice.service.ldap.UsePasswordFromClient;

public class LdapImportDialog
extends TitleAreaDialog {
    private static final Logger LOG = Logger.getLogger(LdapImportDialog.class);
    private CheckboxTableViewer viewer;
    private Text surname;
    private Text givenName;
    private Text title;
    private Text department;
    private Text company;
    private Button[] radioButtonTargetPerspective = new Button[3];
    private HashMap<PersonParameter, List<PersonInfo>> ldapQueryCache;
    private Text ldapSearchPassword;

    public LdapImportDialog(Shell parent) {
        super(parent);
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
        this.ldapQueryCache = new HashMap();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        int shellWidth = 700;
        int shellHeight = 800;
        newShell.setText(Messages.LdapImportDialog_28);
        newShell.setSize(700, 800);
    }

    protected Control createDialogArea(Composite parent) {
        int gridDataHorizontalSpan = 5;
        this.setTitle(Messages.LdapImportDialog_30);
        int defaultMarginHeight = 10;
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout layoutRoot = (GridLayout)composite.getLayout();
        layoutRoot.marginWidth = 10;
        layoutRoot.marginHeight = 10;
        GridData gd = new GridData(512);
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        composite.setLayoutData((Object)gd);
        this.showInformation();
        Composite container = new Composite(composite, 2048);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        GridData containerGd = new GridData(512);
        containerGd.grabExcessHorizontalSpace = true;
        containerGd.grabExcessVerticalSpace = true;
        containerGd.horizontalAlignment = 4;
        containerGd.verticalAlignment = 4;
        containerGd.horizontalSpan = 2;
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)containerGd);
        Label givenNameLabel = new Label(container, 0);
        givenNameLabel.setText(Messages.LdapImportDialog_0);
        this.givenName = new Text(container, 2048);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        this.givenName.setLayoutData((Object)gridData);
        Label nameLabel = new Label(container, 0);
        nameLabel.setText(Messages.LdapImportDialog_31);
        this.surname = new Text(container, 2048);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        this.surname.setLayoutData((Object)gridData);
        Label titleLabel = new Label(container, 0);
        titleLabel.setText(Messages.LdapImportDialog_2);
        this.title = new Text(container, 2048);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        this.title.setLayoutData((Object)gridData);
        Label departmentLabel = new Label(container, 0);
        departmentLabel.setText(Messages.LdapImportDialog_3);
        this.department = new Text(container, 2048);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        this.department.setLayoutData((Object)gridData);
        Label companyLabel = new Label(container, 0);
        companyLabel.setText(Messages.LdapImportDialog_4);
        this.company = new Text(container, 2048);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        this.company.setLayoutData((Object)gridData);
        Composite authAndLoadRow = new Composite(container, 0);
        GridData gdAuthAndLoadRow = new GridData(4, 128, true, false);
        gdAuthAndLoadRow.horizontalSpan = 2;
        authAndLoadRow.setLayoutData((Object)gdAuthAndLoadRow);
        authAndLoadRow.setLayout((Layout)new GridLayout(3, false));
        boolean usePasswordFromClient = false;
        try {
            usePasswordFromClient = ((UsePasswordFromClient)ServiceFactory.lookupCommandService().executeCommand((ICommand)new UsePasswordFromClient())).isUsePasswordFromClient();
        }
        catch (CommandException e1) {
            throw new RuntimeCommandException((Throwable)e1);
        }
        if (usePasswordFromClient) {
            Label ldapSearchPasswordLabel = new Label(authAndLoadRow, 0);
            ldapSearchPasswordLabel.setText(Messages.LdapImportDialog_Password);
            gridData = new GridData();
            gridData.grabExcessHorizontalSpace = true;
            gridData.horizontalAlignment = 131072;
            ldapSearchPasswordLabel.setLayoutData((Object)gridData);
            this.ldapSearchPassword = new Text(authAndLoadRow, 0x400800);
            gridData = new GridData();
            gridData.widthHint = 120;
            gridData.grabExcessHorizontalSpace = false;
            gridData.horizontalAlignment = 131072;
            this.ldapSearchPassword.setLayoutData((Object)gridData);
        }
        Button buttonLoadAccounts = new Button(authAndLoadRow, 2056);
        buttonLoadAccounts.setText(Messages.LdapImportDialog_35);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = !usePasswordFromClient;
        gridData.horizontalAlignment = 131072;
        buttonLoadAccounts.setLayoutData((Object)gridData);
        this.createViewer(container);
        Composite buttonRow = new Composite(container, 0);
        GridData gdButtonRow = new GridData(4, 128, true, false);
        gdButtonRow.horizontalSpan = 2;
        buttonRow.setLayoutData((Object)gdButtonRow);
        buttonRow.setLayout((Layout)new GridLayout(3, false));
        final Button selectAll = new Button(buttonRow, 2056);
        selectAll.setText(sernet.gs.ui.rcp.main.Messages.Select_All);
        selectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LdapImportDialog.this.viewer.setAllChecked(true);
            }
        });
        selectAll.setEnabled(false);
        final Button selectNone = new Button(buttonRow, 2056);
        selectNone.setText(sernet.gs.ui.rcp.main.Messages.Select_None);
        selectNone.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LdapImportDialog.this.viewer.setAllChecked(false);
            }
        });
        selectNone.setEnabled(false);
        buttonLoadAccounts.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (LdapImportDialog.this.ldapQueryCache.containsKey(LdapImportDialog.this.getParameter())) {
                    LdapImportDialog.this.viewer.setInput(LdapImportDialog.this.getFromCache(LdapImportDialog.this.getParameter()));
                } else {
                    LdapImportDialog.this.loadLdapUser();
                }
                selectAll.setEnabled(LdapImportDialog.this.viewer.getTable().getItemCount() > 0);
                selectNone.setEnabled(LdapImportDialog.this.viewer.getTable().getItemCount() > 0);
            }
        });
        Composite targetComposite = new Composite(container, 0);
        GridLayout targetLayout = new GridLayout(this.radioButtonTargetPerspective.length + 1, false);
        targetLayout.marginWidth = 10;
        targetLayout.marginHeight = 10;
        targetComposite.setLayout((Layout)targetLayout);
        GridData gdTarget = new GridData(768);
        gdTarget.grabExcessHorizontalSpace = true;
        gdTarget.grabExcessVerticalSpace = false;
        gdTarget.horizontalAlignment = 16384;
        gdTarget.verticalAlignment = 128;
        gdTarget.horizontalSpan = 5;
        targetComposite.setLayoutData((Object)gdTarget);
        Label targetLabel = new Label(targetComposite, 16384);
        targetLabel.setText(Messages.LdapImportDialog_47);
        this.radioButtonTargetPerspective[0] = this.generateButton(targetComposite, 16, Messages.LdapImportDialog_48, false);
        this.radioButtonTargetPerspective[1] = this.generateButton(targetComposite, 16, Messages.LdapImportDialog_49, true);
        this.radioButtonTargetPerspective[2] = this.generateButton(targetComposite, 16, Messages.Modernized_IT_Baseline_Protection, false);
        return container;
    }

    private Button generateButton(Composite composite, Integer style, String text, boolean selection) {
        Button button = new Button(composite, style.intValue());
        button.setText(text != null ? text : button.getText());
        button.setSelection(selection);
        return button;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, Messages.LdapImportDialog_37, false).setEnabled(false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void showInformation() {
        this.setMessage(Messages.LdapImportDialog_38);
    }

    private void loadLdapUser() {
        try {
            String password = null;
            if (this.ldapSearchPassword != null) {
                password = this.ldapSearchPassword.getText();
            }
            LoadLdapUser loadLdapUser = new LoadLdapUser(this.getParameter(), password);
            loadLdapUser = (LoadLdapUser)ServiceFactory.lookupCommandService().executeCommand((ICommand)loadLdapUser);
            List personList = loadLdapUser.getPersonList();
            if (personList != null) {
                ArrayList accountList = new ArrayList(personList);
                this.ldapQueryCache.put(this.getParameter(), accountList);
            }
            this.viewer.setInput((Object)personList);
        }
        catch (SizeLimitExceededException sizeLimitExceededException) {
            LOG.warn((Object)"Too many results when searching for LDAP users.");
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"stacktrace: ", (Throwable)sizeLimitExceededException);
            }
            MessageDialog.openInformation((Shell)this.getShell(), (String)Messages.LdapImportDialog_6, (String)Messages.LdapImportDialog_7);
        }
        catch (Exception t) {
            LOG.error((Object)"Error while setting table data", (Throwable)t);
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.LdapImportDialog_45, (String)Messages.LdapImportDialog_1);
        }
    }

    private PersonParameter getParameter() {
        return new PersonParameter(this.surname.getText(), this.givenName.getText(), this.title.getText(), this.department.getText(), this.company.getText());
    }

    private void createViewer(Composite parent) {
        int style = 770;
        style = style | 0x10000 | 0x800;
        this.viewer = CheckboxTableViewer.newCheckList((Composite)parent, (int)style);
        this.createColumns();
        Table table = this.viewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        NumericStringComparator numericStringComparator = new NumericStringComparator();
        final Comparator personInfoComparator = (o1, o2) -> numericStringComparator.compare((Object)o1.getLoginName(), (Object)o2.getLoginName());
        this.viewer.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                return personInfoComparator.compare((PersonInfo)e1, (PersonInfo)e2);
            }
        });
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.addCheckStateListener(event -> {
            Button button = this.getButton(0);
            button.setEnabled(this.viewer.getCheckedElements().length != 0);
        });
        GridData gridData = new GridData();
        gridData.verticalAlignment = 4;
        gridData.horizontalSpan = 2;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        this.viewer.getControl().setLayoutData((Object)gridData);
    }

    private void createColumns() {
        String[] titles = new String[]{Messages.LdapImportDialog_39, Messages.LdapImportDialog_40, Messages.LdapImportDialog_41, Messages.LdapImportDialog_2, Messages.LdapImportDialog_3, Messages.LdapImportDialog_4};
        int[] bounds = new int[]{80, 90, 130, 100, 100, 120};
        this.createTableViewerColumn(titles[0], bounds[0], PersonInfo::getLoginName);
        this.createTableViewerColumn(titles[1], bounds[1], PersonInfo::getGivenName);
        this.createTableViewerColumn(titles[2], bounds[2], PersonInfo::getSurname);
        int constant3 = 3;
        int constant4 = 4;
        int constant5 = 5;
        this.createTableViewerColumn(titles[3], bounds[3], PersonInfo::getTitle);
        this.createTableViewerColumn(titles[4], bounds[4], PersonInfo::getDepartment);
        this.createTableViewerColumn(titles[5], bounds[5], PersonInfo::getCompany);
    }

    private TableViewerColumn createTableViewerColumn(String title, int bound, Function<PersonInfo, String> labelRetriever) {
        TableViewerColumn viewerColumn = new TableViewerColumn((TableViewer)this.viewer, 0);
        TableColumn column = viewerColumn.getColumn();
        column.setText(title);
        column.setWidth(bound);
        column.setResizable(true);
        column.setMoveable(true);
        viewerColumn.setLabelProvider((CellLabelProvider)new PersonInfoLabelProvider(labelRetriever));
        return viewerColumn;
    }

    protected void okPressed() {
        Domain domain = this.radioButtonTargetPerspective[0].getSelection() ? Domain.BASE_PROTECTION_OLD : (this.radioButtonTargetPerspective[1].getSelection() ? Domain.ISM : Domain.BASE_PROTECTION);
        SaveLdapUser saveLdapUser = new SaveLdapUser(Arrays.stream(this.viewer.getCheckedElements()).map(PersonInfo.class::cast).collect(Collectors.toSet()), domain);
        try {
            saveLdapUser = (SaveLdapUser)ServiceFactory.lookupCommandService().executeCommand((ICommand)saveLdapUser);
        }
        catch (UsernameExistsException e) {
            LOG.error((Object)e.getMessage());
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Stacktrace: ", (Throwable)e);
            }
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.LdapImportDialog_45, (String)NLS.bind((String)Messages.LdapImportDialog_46, (Object)e.getUsername()));
            return;
        }
        catch (CommandException e) {
            throw new RuntimeException(e);
        }
        LdapImportDialog.updateModel(saveLdapUser.getImportRootObject(), saveLdapUser.getChangedElements());
        super.okPressed();
        InfoDialogWithShowToggle.openInformation(Messages.LdapImportDialog_42, NLS.bind((String)Messages.LdapImportDialog_43, (Object)saveLdapUser.getChangedElements().size()), Messages.LdapImportDialog_44, "info_import_ldap");
    }

    private static void updateModel(CnATreeElement importRootObject, List<CnATreeElement> changedElement) {
        int maxNrOfElements = 9;
        if (changedElement != null && changedElement.size() > 9) {
            CnAElementFactory.getInstance().reloadAllModelsFromDatabase();
        } else {
            if (importRootObject != null) {
                LdapImportDialog.fireAddedEvents(importRootObject);
                if (changedElement != null) {
                    changedElement.forEach(LdapImportDialog::fireAddedEvents);
                }
            }
            if (changedElement != null) {
                changedElement.forEach(LdapImportDialog::fireChangedEvents);
            }
        }
    }

    private static void fireChangedEvents(CnATreeElement element) {
        CnAElementFactory.getModel(element).childChanged(element);
        CnAElementFactory.getModel(element).databaseChildChanged(element);
    }

    private static void fireAddedEvents(CnATreeElement element) {
        CnAElementFactory.getModel(element).childAdded(element.getParent(), element);
        CnAElementFactory.getModel(element).databaseChildAdded(element);
    }

    private List<PersonInfo> getFromCache(PersonParameter parameter) {
        if (this.ldapQueryCache.containsKey(parameter)) {
            return this.ldapQueryCache.get(parameter);
        }
        return Collections.emptyList();
    }

    private static class PersonInfoLabelProvider
    extends ColumnLabelProvider {
        private final Function<PersonInfo, String> labelRetriever;

        private PersonInfoLabelProvider(Function<PersonInfo, String> labelRetriever) {
            this.labelRetriever = labelRetriever;
        }

        public String getText(Object element) {
            return this.labelRetriever.apply((PersonInfo)element);
        }
    }
}

