/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.iso27k.rcp;

import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.DrillDownAdapter;
import sernet.gs.service.NumericStringComparator;
import sernet.gs.ui.rcp.main.Activator;
import sernet.gs.ui.rcp.main.ExceptionUtil;
import sernet.gs.ui.rcp.main.ImageCache;
import sernet.gs.ui.rcp.main.actions.ShowAccessControlEditAction;
import sernet.gs.ui.rcp.main.actions.ShowBulkEditAccountsAction;
import sernet.gs.ui.rcp.main.actions.ShowBulkEditAction;
import sernet.gs.ui.rcp.main.bsi.actions.NaturalizeAction;
import sernet.gs.ui.rcp.main.bsi.dnd.BSIModelViewDragListener;
import sernet.gs.ui.rcp.main.bsi.dnd.BSIModelViewDropListener;
import sernet.gs.ui.rcp.main.bsi.dnd.transfer.BausteinUmsetzungTransfer;
import sernet.gs.ui.rcp.main.bsi.dnd.transfer.IBSIStrukturElementTransfer;
import sernet.gs.ui.rcp.main.bsi.dnd.transfer.IGSModelElementTransfer;
import sernet.gs.ui.rcp.main.bsi.dnd.transfer.ISO27kElementTransfer;
import sernet.gs.ui.rcp.main.bsi.dnd.transfer.ISO27kGroupTransfer;
import sernet.gs.ui.rcp.main.bsi.dnd.transfer.ItemTransfer;
import sernet.gs.ui.rcp.main.bsi.dnd.transfer.SearchViewElementTransfer;
import sernet.gs.ui.rcp.main.bsi.editors.AttachmentEditorInput;
import sernet.gs.ui.rcp.main.bsi.editors.BSIElementEditorInput;
import sernet.gs.ui.rcp.main.bsi.editors.EditorFactory;
import sernet.gs.ui.rcp.main.bsi.views.ImportGroupFirstComparator;
import sernet.gs.ui.rcp.main.common.model.CnAElementFactory;
import sernet.gs.ui.rcp.main.common.model.CnAElementHome;
import sernet.gs.ui.rcp.main.common.model.DefaultModelLoadListener;
import sernet.gs.ui.rcp.main.common.model.IModelLoadListener;
import sernet.gs.ui.rcp.main.service.ServiceFactory;
import sernet.verinice.interfaces.ICommandService;
import sernet.verinice.interfaces.IParameter;
import sernet.verinice.iso27k.rcp.ILinkedWithEditorView;
import sernet.verinice.iso27k.rcp.JobScheduler;
import sernet.verinice.iso27k.rcp.LinkWithEditorPartListener;
import sernet.verinice.iso27k.rcp.Messages;
import sernet.verinice.iso27k.rcp.action.AddGroup;
import sernet.verinice.iso27k.rcp.action.BSIModelDropPerformer;
import sernet.verinice.iso27k.rcp.action.CollapseAction;
import sernet.verinice.iso27k.rcp.action.ExpandAction;
import sernet.verinice.iso27k.rcp.action.FileDropPerformer;
import sernet.verinice.iso27k.rcp.action.HideEmptyFilter;
import sernet.verinice.iso27k.rcp.action.MetaDropAdapter;
import sernet.verinice.model.common.CnATreeElement;
import sernet.verinice.model.common.TagParameter;
import sernet.verinice.model.common.TypeParameter;
import sernet.verinice.model.iso27k.IISO27KModelListener;
import sernet.verinice.model.iso27k.IISO27kElement;
import sernet.verinice.model.iso27k.ISO27KModel;
import sernet.verinice.model.iso27k.Organization;
import sernet.verinice.rcp.RightsEnabledView;
import sernet.verinice.rcp.ViewFilterAction;
import sernet.verinice.rcp.tree.TreeContentProvider;
import sernet.verinice.rcp.tree.TreeLabelProvider;
import sernet.verinice.rcp.tree.TreeUpdateListener;
import sernet.verinice.service.tree.ElementManager;

public class ISMView
extends RightsEnabledView
implements ILinkedWithEditorView {
    private static final Logger LOG = Logger.getLogger(ISMView.class);
    public static final String ID = "sernet.verinice.iso27k.rcp.ISMView";
    private static int operations = 3;
    protected TreeViewer viewer;
    private TreeContentProvider contentProvider;
    private ElementManager elementManager;
    private DrillDownAdapter drillDownAdapter;
    private ShowBulkEditAction bulkEditAction;
    private ShowBulkEditAccountsAction bulkEditAccountsAction;
    private ExpandAction expandAction;
    private CollapseAction collapseAction;
    private Action expandAllAction;
    private Action collapseAllAction;
    private Action linkWithEditorAction;
    private IPartListener2 linkWithEditorPartListener = new LinkWithEditorPartListener(this);
    private ViewFilterAction filterAction;
    private MetaDropAdapter metaDropAdapter;
    private ShowAccessControlEditAction accessControlEditAction;
    private NaturalizeAction naturalizeAction;
    private IModelLoadListener modelLoadListener;
    private Object mutex = new Object();
    private IISO27KModelListener modelUpdateListener;
    private boolean linkingActive = false;
    private ICommandService commandService;

    public ISMView() {
        this.elementManager = new ElementManager();
    }

    @Override
    public String getRightID() {
        return "ismview";
    }

    @Override
    public String getViewId() {
        return ID;
    }

    @Override
    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        try {
            this.initView(parent);
            this.startInitDataJob();
        }
        catch (Exception e) {
            LOG.error((Object)"Error while creating organization view", (Throwable)e);
            ExceptionUtil.log(e, Messages.ISMView_2);
        }
    }

    protected void initView(Composite parent) {
        IWorkbench workbench = this.getSite().getWorkbenchWindow().getWorkbench();
        if (CnAElementFactory.isIsoModelLoaded()) {
            CnAElementFactory.getInstance().reloadAllModelsFromDatabase();
        }
        this.contentProvider = new TreeContentProvider(this.elementManager);
        this.viewer = new TreeViewer(parent, 2818);
        this.drillDownAdapter = new DrillDownAdapter(this.viewer);
        this.viewer.getTree().setLayoutData((Object)new GridData(1808));
        this.viewer.setContentProvider((IContentProvider)this.contentProvider);
        this.viewer.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)new TreeLabelProvider(), (ILabelDecorator)workbench.getDecoratorManager()));
        this.viewer.setComparator((ViewerComparator)new ImportGroupFirstComparator((Comparator<? super String>)new NumericStringComparator()));
        this.toggleLinking(Activator.getDefault().getPreferenceStore().getBoolean("link_to_editor"));
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.hookContextMenu();
        this.makeActions();
        this.addActions();
        this.fillToolBar();
        this.hookDNDListeners();
        this.getSite().getPage().addPartListener(this.linkWithEditorPartListener);
    }

    protected void startInitDataJob() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"ISMview: startInitDataJob");
        }
        WorkspaceJob initDataJob = new WorkspaceJob(Messages.ISMView_InitData){

            public IStatus runInWorkspace(IProgressMonitor monitor) {
                IStatus status = Status.OK_STATUS;
                try {
                    try {
                        monitor.beginTask(Messages.ISMView_InitData, -1);
                        ISMView.this.initData();
                    }
                    catch (Exception e) {
                        LOG.error((Object)"Error while loading data.", (Throwable)e);
                        status = new Status(4, "sernet.gs.ui.rcp.main", Messages.ISMView_4, (Throwable)e);
                        monitor.done();
                    }
                }
                finally {
                    monitor.done();
                }
                return status;
            }
        };
        JobScheduler.scheduleInitJob(initDataJob);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initData() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"ISMVIEW: initData");
        }
        Object object = this.mutex;
        synchronized (object) {
            if (CnAElementFactory.isIsoModelLoaded()) {
                if (this.modelUpdateListener == null) {
                    if (LOG.isDebugEnabled()) {
                        Logger.getLogger(this.getClass()).debug((Object)"Creating modelUpdateListener for ISMView.");
                    }
                    this.modelUpdateListener = new TreeUpdateListener(this.viewer, this.elementManager);
                    CnAElementFactory.getInstance().getISO27kModel().addISO27KModelListener(this.modelUpdateListener);
                    Display.getDefault().syncExec(() -> this.setInput(CnAElementFactory.getInstance().getISO27kModel()));
                }
            } else if (this.modelLoadListener == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"ISMView No model loaded, adding model load listener.");
                }
                this.modelLoadListener = new DefaultModelLoadListener(){

                    @Override
                    public void loaded(ISO27KModel model) {
                        ISMView.this.startInitDataJob();
                    }
                };
                CnAElementFactory.getInstance().addLoadListener(this.modelLoadListener);
            }
        }
    }

    public void dispose() {
        this.elementManager.clearCache();
        if (CnAElementFactory.isIsoModelLoaded()) {
            CnAElementFactory.getInstance().getISO27kModel().removeISO27KModelListener(this.modelUpdateListener);
        }
        CnAElementFactory.getInstance().removeLoadListener(this.modelLoadListener);
        this.getSite().getPage().removePartListener(this.linkWithEditorPartListener);
        super.dispose();
    }

    public void setInput(ISO27KModel model) {
        this.viewer.setInput((Object)model);
    }

    public void setInput(List<Organization> organizationList) {
        this.viewer.setInput(organizationList);
    }

    public void setInput(Organization organization) {
        this.viewer.setInput((Object)organization);
    }

    private void makeActions() {
        this.bulkEditAction = new ShowBulkEditAction(this.getViewSite(), Messages.ISMView_6);
        this.bulkEditAccountsAction = new ShowBulkEditAccountsAction(this.getViewSite(), sernet.gs.ui.rcp.main.Messages.ContextMenuAccountBulkEditor);
        this.expandAction = new ExpandAction(this.viewer, this.contentProvider);
        this.expandAction.setText(Messages.ISMView_7);
        this.expandAction.setImageDescriptor(ImageCache.getInstance().getImageDescriptor("expandall.gif"));
        this.collapseAction = new CollapseAction(this.viewer);
        this.collapseAction.setText(Messages.ISMView_8);
        this.collapseAction.setImageDescriptor(ImageCache.getInstance().getImageDescriptor("collapseall.gif"));
        this.expandAllAction = new Action(){

            public void run() {
                ISMView.this.expandAll();
            }
        };
        this.expandAllAction.setText(Messages.ISMView_9);
        this.expandAllAction.setImageDescriptor(ImageCache.getInstance().getImageDescriptor("expandall.gif"));
        this.collapseAllAction = new Action(){

            public void run() {
                ISMView.this.viewer.collapseAll();
            }
        };
        this.collapseAllAction.setText(Messages.ISMView_10);
        this.collapseAllAction.setImageDescriptor(ImageCache.getInstance().getImageDescriptor("collapseall.gif"));
        HideEmptyFilter hideEmptyFilter = this.createHideEmptyFilter();
        TypeParameter typeParameter = this.createTypeParameter();
        TagParameter tagParameter = new TagParameter();
        this.filterAction = new ViewFilterAction(Messages.ISMView_12, tagParameter, hideEmptyFilter, typeParameter);
        this.elementManager.addParameter((IParameter)tagParameter);
        if (typeParameter != null) {
            this.elementManager.addParameter((IParameter)typeParameter);
        }
        this.metaDropAdapter = new MetaDropAdapter((Viewer)this.viewer);
        BSIModelViewDropListener bsiDropAdapter = new BSIModelViewDropListener(this.viewer);
        BSIModelDropPerformer bsi2IsmDropAdapter = new BSIModelDropPerformer(this.viewer);
        FileDropPerformer fileDropPerformer = new FileDropPerformer(this.viewer);
        this.metaDropAdapter.addAdapter(bsiDropAdapter);
        this.metaDropAdapter.addAdapter(bsi2IsmDropAdapter);
        this.metaDropAdapter.addAdapter(fileDropPerformer);
        this.accessControlEditAction = new ShowAccessControlEditAction(this.getViewSite(), Messages.ISMView_11);
        this.naturalizeAction = new NaturalizeAction(this.getViewSite());
        this.linkWithEditorAction = new Action(Messages.ISMView_5, 2){

            public void run() {
                ISMView.this.toggleLinking(this.isChecked());
            }
        };
        this.linkWithEditorAction.setChecked(this.isLinkingActive());
        this.linkWithEditorAction.setImageDescriptor(ImageCache.getInstance().getImageDescriptor("linked.gif"));
    }

    protected HideEmptyFilter createHideEmptyFilter() {
        return new HideEmptyFilter((StructuredViewer)this.viewer);
    }

    protected TypeParameter createTypeParameter() {
        return new TypeParameter();
    }

    protected void fillToolBar() {
        IActionBars bars = this.getViewSite().getActionBars();
        IToolBarManager manager = bars.getToolBarManager();
        manager.add((IAction)this.expandAllAction);
        manager.add((IAction)this.collapseAllAction);
        this.drillDownAdapter.addNavigationActions(manager);
        manager.add((IAction)this.filterAction);
        manager.add((IAction)this.linkWithEditorAction);
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(this::fillContextMenu);
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    private void hookDNDListeners() {
        Transfer[] dragTypes = new Transfer[]{ISO27kElementTransfer.getInstance(), ISO27kGroupTransfer.getInstance()};
        Transfer[] dropTypes = new Transfer[]{IGSModelElementTransfer.getInstance(), BausteinUmsetzungTransfer.getInstance(), ItemTransfer.getInstance(), ISO27kElementTransfer.getInstance(), ISO27kGroupTransfer.getInstance(), IBSIStrukturElementTransfer.getInstance(), FileTransfer.getInstance(), SearchViewElementTransfer.getInstance()};
        this.viewer.addDragSupport(operations, dragTypes, (DragSourceListener)new BSIModelViewDragListener(this.viewer));
        this.viewer.addDropSupport(operations, dropTypes, (DropTargetListener)this.metaDropAdapter);
    }

    protected void expandAll() {
        this.viewer.expandAll();
    }

    private void addActions() {
        this.viewer.addDoubleClickListener(event -> {
            ISelection selection = event.getViewer().getSelection();
            if (!selection.isEmpty() && selection instanceof IStructuredSelection) {
                Object sel = ((IStructuredSelection)selection).getFirstElement();
                EditorFactory.getInstance().updateAndOpenObject(sel);
            }
        });
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)this.expandAction);
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)this.collapseAction);
    }

    protected void fillContextMenu(IMenuManager manager) {
        Object sel;
        ISelection selection = this.viewer.getSelection();
        if (selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() == 1 && (sel = ((IStructuredSelection)selection).getFirstElement()) instanceof Organization) {
            Organization element = (Organization)sel;
            if (CnAElementHome.getInstance().isNewChildAllowed((CnATreeElement)element)) {
                MenuManager submenuNew = new MenuManager(Messages.NewObjectMenu, "content/new");
                submenuNew.add((IAction)new AddGroup((CnATreeElement)element, "assetgroup", "asset"));
                submenuNew.add((IAction)new AddGroup((CnATreeElement)element, "auditgroup", "audit"));
                submenuNew.add((IAction)new AddGroup((CnATreeElement)element, "controlgroup", "control"));
                submenuNew.add((IAction)new AddGroup((CnATreeElement)element, "document_group", "document"));
                submenuNew.add((IAction)new AddGroup((CnATreeElement)element, "evidence_group", "evidence"));
                submenuNew.add((IAction)new AddGroup((CnATreeElement)element, "exceptiongroup", "exception"));
                submenuNew.add((IAction)new AddGroup((CnATreeElement)element, "finding_group", "finding"));
                submenuNew.add((IAction)new AddGroup((CnATreeElement)element, "incident_group", "incident"));
                submenuNew.add((IAction)new AddGroup((CnATreeElement)element, "incident_scenario_group", "incident_scenario"));
                submenuNew.add((IAction)new AddGroup((CnATreeElement)element, "interview_group", "interview"));
                submenuNew.add((IAction)new AddGroup((CnATreeElement)element, "persongroup", "person-iso"));
                submenuNew.add((IAction)new AddGroup((CnATreeElement)element, "process_group", "process"));
                submenuNew.add((IAction)new AddGroup((CnATreeElement)element, "record_group", "record"));
                submenuNew.add((IAction)new AddGroup((CnATreeElement)element, "requirementgroup", "requirement"));
                submenuNew.add((IAction)new AddGroup((CnATreeElement)element, "response_group", "response"));
                submenuNew.add((IAction)new AddGroup((CnATreeElement)element, "threat_group", "threat"));
                submenuNew.add((IAction)new AddGroup((CnATreeElement)element, "vulnerability_group", "vulnerability"));
                manager.add((IContributionItem)submenuNew);
            }
        }
        manager.add((IContributionItem)new GroupMarker("content"));
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new GroupMarker("additions"));
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new GroupMarker("special"));
        manager.add((IAction)this.bulkEditAction);
        manager.add((IAction)this.bulkEditAccountsAction);
        manager.add((IAction)this.accessControlEditAction);
        manager.add((IAction)this.naturalizeAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.expandAction);
        manager.add((IAction)this.collapseAction);
        this.drillDownAdapter.addNavigationActions(manager);
    }

    @Override
    public void editorActivated(IEditorPart editor) {
        if (!this.isLinkingActive() || !this.getViewSite().getPage().isPartVisible((IWorkbenchPart)this)) {
            return;
        }
        CnATreeElement element = BSIElementEditorInput.extractElement(editor);
        if (element == null && editor.getEditorInput() instanceof AttachmentEditorInput) {
            element = this.getElementFromAttachment(editor);
        }
        if (!(element instanceof IISO27kElement)) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Element in editor: " + element.getUuid()));
            LOG.debug((Object)"Expanding tree now to show element...");
        }
        if (element == null) {
            return;
        }
        this.viewer.setSelection((ISelection)new StructuredSelection((Object)element), true);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Tree is expanded.");
        }
    }

    private CnATreeElement getElementFromAttachment(IEditorPart editor) {
        return AttachmentEditorInput.extractCnaTreeElement(editor);
    }

    protected void toggleLinking(boolean checked) {
        this.linkingActive = checked;
        if (checked) {
            Optional.ofNullable(this.getSite().getPage().getActiveEditor()).ifPresent(this::editorActivated);
        }
    }

    protected boolean isLinkingActive() {
        return this.linkingActive;
    }

    @Override
    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public ICommandService getCommandService() {
        if (this.commandService == null) {
            this.commandService = this.createCommandService();
        }
        return this.commandService;
    }

    private ICommandService createCommandService() {
        return ServiceFactory.lookupCommandService();
    }
}

