/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.iso27k.rcp;

import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.jface.action.Action;
import org.eclipse.ui.IWorkbenchWindow;
import sernet.gs.ui.rcp.main.ImageCache;
import sernet.gs.ui.rcp.main.service.ServiceFactory;
import sernet.verinice.interfaces.GraphCommand;
import sernet.verinice.interfaces.ICommand;
import sernet.verinice.interfaces.IGraphCommand;
import sernet.verinice.interfaces.graph.GraphElementLoader;
import sernet.verinice.interfaces.graph.IGraphElementLoader;
import sernet.verinice.interfaces.graph.VeriniceGraph;
import sernet.verinice.model.common.CnATreeElement;

public class GraphAction
extends Action {
    private static final Logger LOG = Logger.getLogger(GraphAction.class);
    private static String[] typeIds = new String[]{"org", "assetgroup", "asset", "incident_scenario"};
    private static String ID = "sernet.verinice.iso27k.rcp.GraphAction";

    public GraphAction(IWorkbenchWindow window) {
        this.setText("Graph action");
        this.setId(ID);
        this.setActionDefinitionId(ID);
        this.setImageDescriptor(ImageCache.getInstance().getImageDescriptor("arrow_out.png"));
        this.setEnabled(true);
    }

    public void run() {
        try {
            GraphCommand command = new GraphCommand();
            GraphElementLoader loader = new GraphElementLoader();
            loader.setScopeId(Integer.valueOf(96826));
            loader.setTypeIds(typeIds);
            command.addLoader((IGraphElementLoader)loader);
            command.addRelationId("rel_incscen_asset");
            command = (IGraphCommand)ServiceFactory.lookupCommandService().executeCommand((ICommand)command);
            VeriniceGraph graph = command.getGraph();
            Set elementSet = graph.getElements();
            for (CnATreeElement element : elementSet) {
                LOG.debug((Object)("Element: " + element.getTitle()));
                CnATreeElement parent = graph.getParent(element);
                if (parent != null) {
                    LOG.debug((Object)("    P: " + parent.getTitle()));
                }
                LOG.debug((Object)"  Children:");
                Set children = graph.getChildren(element);
                for (CnATreeElement child : children) {
                    LOG.debug((Object)("   " + child.getTitle()));
                }
                LOG.debug((Object)"  Links:");
                Set links = graph.getLinkTargets(element);
                for (CnATreeElement target : links) {
                    LOG.debug((Object)("   " + target.getTitle()));
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error while retrieving configuration", (Throwable)e);
        }
    }
}

