/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.iso27k.rcp;

import java.io.File;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import sernet.gs.service.FileUtil;
import sernet.gs.service.StringUtil;
import sernet.gs.ui.rcp.main.Activator;
import sernet.verinice.interfaces.CommandException;
import sernet.verinice.iso27k.rcp.Messages;
import sernet.verinice.iso27k.rcp.ScopeMultiselectWidget;
import sernet.verinice.iso27k.rcp.action.ExportAction;
import sernet.verinice.model.common.CnATreeElement;
import sernet.verinice.service.commands.SyncParameter;

public class ExportDialog
extends TitleAreaDialog {
    private static final Logger LOG = Logger.getLogger(ExportDialog.class);
    private static final String[] EXTENSION_ARRAY = new String[]{".vna", ".xml"};
    private static final String DEFAULT_ORGANIZATION_TITLE = "organization";
    private boolean encryptOutput = false;
    private boolean reImport = false;
    private ITreeSelection selection;
    private CnATreeElement selectedElement;
    private String filePath;
    private String sourceId;
    private ScopeMultiselectWidget organizationWidget = null;
    private Text sourceIdText;
    private Text txtLocation;
    private String defaultFolder;
    private boolean useDefaultFolder = true;
    private String organizationTitle = "organization";
    private int format = SyncParameter.EXPORT_FORMAT_DEFAULT;
    private boolean serverConnectionMode = false;

    public ExportDialog(Shell activeShell) {
        this(activeShell, (CnATreeElement)null);
    }

    public ExportDialog(Shell activeShell, boolean serverConnectionMode, String filePath) {
        super(activeShell);
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
        this.serverConnectionMode = serverConnectionMode;
        this.filePath = filePath;
    }

    public ExportDialog(Shell activeShell, CnATreeElement selectedOrganization) {
        super(activeShell);
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
        this.selectedElement = selectedOrganization;
    }

    public ExportDialog(Shell activeShell, ITreeSelection selection) {
        this(activeShell, (CnATreeElement)null);
        this.selection = selection;
    }

    protected Control createDialogArea(Composite parent) {
        int layoutMarginWidth = 10;
        int layoutMarginHeight = 10;
        int sourceIdCompositeNumColumns = 3;
        int sourceIdCompositeMarginTop = 15;
        int reimportChechboxHorizontalSpan = 3;
        int sourceIdTextMinimumWidth = 150;
        int txtLocationMinimumWidth = 302;
        int udfbHorizontalSpan = 3;
        int encryptionCheckboxHorizontalSpan = 3;
        this.initDefaultFolder();
        this.setTitle(Messages.SamtExportDialog_0);
        this.setMessage(Messages.SamtExportDialog_1, 1);
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout layout = (GridLayout)composite.getLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        GridData gd = new GridData(4, 4, true, true);
        composite.setLayoutData((Object)gd);
        try {
            this.organizationWidget = new ScopeMultiselectWidget(composite, this.selection, this.selectedElement){

                @Override
                protected boolean isItemVisible(CnATreeElement item) {
                    String parentType = item.getParent().getTypeId();
                    if ("catalog_model".equals(parentType)) {
                        return false;
                    }
                    return super.isItemVisible(item);
                }
            };
            this.setOrgTitle();
        }
        catch (CommandException ex) {
            LOG.error((Object)"Error while loading organizations", (Throwable)ex);
            this.setMessage(Messages.SamtExportDialog_4, 3);
            return null;
        }
        SelectionAdapter organizationListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button checkbox = (Button)e.getSource();
                if (checkbox.getSelection()) {
                    ExportDialog.this.setOrgTitle();
                    if (ExportDialog.this.txtLocation != null) {
                        ExportDialog.this.filePath = ExportDialog.this.isFilepath() ? String.valueOf(FileUtil.getFolderFromPath((String)ExportDialog.this.txtLocation.getText())) + ExportDialog.this.organizationTitle + ExportDialog.this.getDefaultExtension() : String.valueOf(ExportDialog.this.defaultFolder) + ExportDialog.this.organizationTitle + ExportDialog.this.getDefaultExtension();
                        ExportDialog.this.txtLocation.setText(ExportDialog.this.filePath);
                    }
                    ExportDialog.this.setSourceId((CnATreeElement)ExportDialog.this.organizationWidget.getSelectedElement());
                }
                super.widgetSelected(e);
            }
        };
        this.organizationWidget.addSelectionListener((SelectionListener)organizationListener);
        if (!this.serverConnectionMode) {
            Composite sourceIdComposite = new Composite(composite, 0);
            sourceIdComposite.setLayout((Layout)new GridLayout(3, false));
            ((GridLayout)sourceIdComposite.getLayout()).marginTop = 15;
            gd = new GridData(4, 1024, true, false);
            gd.grabExcessHorizontalSpace = true;
            sourceIdComposite.setLayoutData((Object)gd);
            Button reImportCheckbox = new Button(sourceIdComposite, 32);
            reImportCheckbox.setText(Messages.ExportDialog_0);
            gd = new GridData();
            gd.horizontalSpan = 3;
            reImportCheckbox.setLayoutData((Object)gd);
            reImportCheckbox.setSelection(this.reImport);
            reImportCheckbox.setEnabled(true);
            reImportCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Button checkBox = (Button)e.getSource();
                    ExportDialog.this.reImport = checkBox.getSelection();
                }
            });
            Button encryptionCheckbox = new Button(sourceIdComposite, 32);
            encryptionCheckbox.setText(Messages.SamtExportDialog_5);
            gd = new GridData();
            gd.horizontalSpan = 3;
            encryptionCheckbox.setLayoutData((Object)gd);
            encryptionCheckbox.setSelection(this.encryptOutput);
            encryptionCheckbox.setEnabled(true);
            encryptionCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Button checkBox = (Button)e.getSource();
                    ExportDialog.this.encryptOutput = checkBox.getSelection();
                }
            });
            sourceIdComposite.pack();
            Label sourceIdLabel = new Label(sourceIdComposite, 0);
            sourceIdLabel.setText(Messages.SamtExportDialog_14);
            this.sourceIdText = new Text(sourceIdComposite, 2048);
            gd = new GridData(512);
            gd.horizontalSpan = 2;
            gd.minimumWidth = 150;
            this.sourceIdText.setLayoutData((Object)gd);
            this.sourceIdText.addModifyListener(e -> {
                String string = this.sourceId = this.sourceIdText.getText();
            });
            this.setSourceId((CnATreeElement)this.organizationWidget.getSelectedElement());
            Label labelLocation = new Label(sourceIdComposite, 0);
            labelLocation.setText(Messages.SamtExportDialog_6);
            this.txtLocation = new Text(sourceIdComposite, 2060);
            gd = new GridData(4, 128, true, false);
            gd.grabExcessHorizontalSpace = true;
            gd.minimumWidth = 302;
            this.txtLocation.setLayoutData((Object)gd);
            this.txtLocation.addKeyListener(new KeyListener(){

                public void keyReleased(KeyEvent e) {
                    ExportDialog.this.filePath = ExportDialog.this.txtLocation.getText();
                }

                public void keyPressed(KeyEvent e) {
                }
            });
            Button buttonBrowseLocations = new Button(sourceIdComposite, 0);
            buttonBrowseLocations.setText(Messages.SamtExportDialog_7);
            buttonBrowseLocations.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    FileDialog dialog = new FileDialog(Display.getCurrent().getActiveShell(), 8192);
                    dialog.setText(Messages.SamtExportDialog_3);
                    if (ExportDialog.this.isFilepath()) {
                        try {
                            dialog.setFilterPath(FileUtil.getFolderFromPath((String)ExportDialog.this.txtLocation.getText()));
                            dialog.setFileName(FilenameUtils.getName((String)ExportDialog.this.txtLocation.getText()));
                        }
                        catch (Exception e1) {
                            LOG.debug((Object)Messages.ExportDialog_1, (Throwable)e1);
                            dialog.setFileName("");
                        }
                    } else if (ExportDialog.this.useDefaultFolder) {
                        dialog.setFilterPath(ExportDialog.this.defaultFolder);
                    }
                    dialog.setFilterExtensions(new String[]{"*" + EXTENSION_ARRAY[0], "*" + EXTENSION_ARRAY[1]});
                    dialog.setFilterNames(new String[]{Messages.ExportDialog_2, Messages.SamtExportDialog_15});
                    dialog.setFilterIndex(0);
                    String exportPath = dialog.open();
                    ExportDialog.this.setFormat(dialog.getFilterIndex());
                    if (exportPath != null) {
                        ExportDialog.this.txtLocation.setText(ExportAction.addExtension(exportPath, EXTENSION_ARRAY[dialog.getFilterIndex()]));
                        ExportDialog.this.filePath = exportPath;
                    } else {
                        ExportDialog.this.txtLocation.setText("");
                        ExportDialog.this.filePath = "";
                    }
                }
            });
            Button useDefaultFolderButton = new Button(sourceIdComposite, 32);
            useDefaultFolderButton.setText(Messages.ExportDialog_3);
            useDefaultFolderButton.setSelection(this.useDefaultFolder);
            useDefaultFolderButton.setEnabled(true);
            GridData useDefaultFolderButtonGridData = new GridData();
            useDefaultFolderButtonGridData.horizontalSpan = 3;
            useDefaultFolderButton.setLayoutData((Object)useDefaultFolderButtonGridData);
            useDefaultFolderButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Button checkBox = (Button)e.getSource();
                    ExportDialog.this.useDefaultFolder = checkBox.getSelection();
                }
            });
        }
        if (this.organizationWidget.getSelectedElement() != null) {
            this.filePath = String.valueOf(this.defaultFolder) + this.organizationTitle + this.getDefaultExtension();
            this.txtLocation.setText(this.filePath);
        }
        composite.pack();
        return composite;
    }

    private void setOrgTitle() {
        String title = null;
        if (this.organizationWidget.getSelectedElement() != null) {
            title = ((CnATreeElement)this.organizationWidget.getSelectedElement()).getTitle();
        }
        this.organizationTitle = title != null ? StringUtil.convertToFileName(title) : DEFAULT_ORGANIZATION_TITLE;
    }

    private boolean isFilepath() {
        return this.txtLocation != null && this.txtLocation.getText() != null && !this.txtLocation.getText().isEmpty();
    }

    private String initDefaultFolder() {
        IPreferenceStore prefs = Activator.getDefault().getPreferenceStore();
        this.defaultFolder = prefs.getString("default_folder_export");
        if (this.defaultFolder == null || this.defaultFolder.isEmpty()) {
            this.defaultFolder = System.getProperty("user.home");
        }
        if (!this.defaultFolder.endsWith(System.getProperty("file.separator"))) {
            this.defaultFolder = String.valueOf(this.defaultFolder) + System.getProperty("file.separator");
        }
        return this.defaultFolder;
    }

    protected String setupDirPath() {
        String currentPath;
        String path = currentPath = this.txtLocation.getText();
        if (currentPath != null && !currentPath.isEmpty()) {
            int lastSlash = currentPath.lastIndexOf(System.getProperty("file.separator"));
            path = lastSlash != -1 ? currentPath.substring(0, lastSlash + 1) : currentPath.substring(0, lastSlash);
        }
        if (currentPath != null && !currentPath.equals(path)) {
            this.txtLocation.setText(path);
        }
        return path;
    }

    protected String getDefaultExtension() {
        return ".vna";
    }

    private void setSourceId(CnATreeElement element) {
        if (element != null && element.getSourceId() != null) {
            this.sourceId = element.getSourceId();
            if (this.sourceIdText != null) {
                this.sourceIdText.setText(element.getSourceId());
            }
        } else {
            this.sourceId = null;
            if (this.sourceIdText != null) {
                this.sourceIdText.setText("");
            }
        }
    }

    protected void okPressed() {
        StringBuilder sb = new StringBuilder();
        if (this.filePath == null || this.filePath.isEmpty()) {
            sb.append(Messages.SamtExportDialog_10);
        } else {
            try {
                File test = new File(this.filePath);
                if (test.createNewFile()) {
                    test.delete();
                }
            }
            catch (Exception e) {
                LOG.error((Object)("Error in file name: " + this.filePath), (Throwable)e);
                sb.append(Messages.SamtExportDialog_11);
            }
        }
        if (this.organizationWidget.getSelectedElement() == null) {
            sb.append(Messages.SamtExportDialog_12);
        }
        if (sb.length() > 0) {
            sb.append(Messages.SamtExportDialog_13);
            this.setMessage(sb.toString(), 3);
        } else {
            String currentPath = this.setupDirPath();
            if (this.useDefaultFolder) {
                Activator.getDefault().getPreferenceStore().setValue("default_folder_export", currentPath);
            }
            super.okPressed();
        }
    }

    public String getFilePath() {
        return this.filePath;
    }

    public boolean getEncryptOutput() {
        return this.encryptOutput;
    }

    public boolean getReImport() {
        return this.reImport;
    }

    public String getSourceId() {
        return this.sourceId;
    }

    public int getFormat() {
        return this.format;
    }

    public void setFormat(int exportFormat) {
        this.format = exportFormat;
    }

    public Set<CnATreeElement> getSelectedElementSet() {
        return this.organizationWidget.getSelectedElementSet();
    }

    public CnATreeElement getSelectedElement() {
        return (CnATreeElement)this.organizationWidget.getSelectedElement();
    }

    public boolean getUseDefaultFolder() {
        return this.useDefaultFolder;
    }

    public static String[] getExtensionArray() {
        return EXTENSION_ARRAY;
    }
}

