/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.iso27k.rcp;

import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import sernet.verinice.interfaces.ElementChange;
import sernet.verinice.iso27k.rcp.RcpProgressObserver;
import sernet.verinice.iso27k.service.CutService;
import sernet.verinice.model.common.CnATreeElement;

public class CutOperation
implements IRunnableWithProgress {
    private CutService service;
    private CnATreeElement selectedGroup;
    private List<CnATreeElement> elements;
    private List<ElementChange> changes;
    private boolean inheritPermissions = false;

    public CutOperation(CnATreeElement selectedGroup, List<CnATreeElement> elements) {
        this.selectedGroup = selectedGroup;
        this.elements = elements;
    }

    public void run(IProgressMonitor monitor) {
        RcpProgressObserver progressObserver = new RcpProgressObserver(monitor);
        this.service = new CutService(progressObserver, this.selectedGroup, this.elements);
        this.service.setInheritPermissions(this.isInheritPermissions());
        this.service.run();
        this.changes = this.service.getElementChanges();
    }

    public int getNumberOfElements() {
        int n = 0;
        if (this.service != null) {
            n = this.service.getNumberOfElements();
        }
        return n;
    }

    public List<ElementChange> getChanges() {
        return this.changes;
    }

    public boolean isInheritPermissions() {
        return this.inheritPermissions;
    }

    public void setInheritPermissions(boolean inheritPermissions) {
        this.inheritPermissions = inheritPermissions;
    }
}

