/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.iso27k.rcp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import sernet.verinice.iso27k.rcp.ComboModelObject;
import sernet.verinice.iso27k.rcp.IComboModelFilter;
import sernet.verinice.iso27k.rcp.IComboModelLabelProvider;
import sernet.verinice.iso27k.rcp.Messages;

public class ComboModel<T> {
    private List<ComboModelObject<T>> objectList = new ArrayList<ComboModelObject<T>>();
    IComboModelLabelProvider<T> labelProvider;
    IComboModelFilter<T> filter;
    int selectedIndex = -1;

    public ComboModel(IComboModelLabelProvider<T> labelProvider) {
        this.labelProvider = labelProvider;
    }

    public void add(T object) {
        this.objectList.add(new ComboModelObject<T>(object, this.labelProvider.getLabel(object)));
    }

    public void add(int position, T object) {
        this.objectList.add(position, new ComboModelObject<T>(object, this.labelProvider.getLabel(object)));
    }

    public void addAll(Collection<T> objectList) {
        for (T object : objectList) {
            this.objectList.add(new ComboModelObject<T>(object, this.labelProvider.getLabel(object)));
        }
    }

    public void addNoSelectionObject() {
        this.addNoSelectionObject(Messages.ComboModel_0);
    }

    public void addNoSelectionObject(String label) {
        this.objectList.add(0, new ComboModelObject<Object>(null, label));
    }

    public void remove(int i) {
        this.remove(this.getObject(i));
    }

    public boolean remove(T object) {
        boolean found = false;
        for (ComboModelObject<T> curent : this.objectList) {
            if (!curent.equals(object)) continue;
            this.objectList.remove(curent);
            found = true;
            break;
        }
        return found;
    }

    public void removeSelected() {
        this.remove(this.selectedIndex);
        if (this.selectedIndex > 0 || this.getComboModelObjectList().size() == 0) {
            --this.selectedIndex;
        }
    }

    public void clear() {
        this.objectList.clear();
        this.selectedIndex = -1;
    }

    public void sort() {
        Collections.sort(this.objectList);
    }

    public void sort(Comparator<ComboModelObject<T>> comparator) {
        Collections.sort(this.objectList, comparator);
    }

    public int size() {
        return this.objectList.size();
    }

    public int getSize() {
        return this.size();
    }

    public boolean isEmpty() {
        return this.size() < 1;
    }

    public T getSelectedObject() {
        return this.selectedIndex >= 0 ? (T)this.getComboModelObjectListFiltered().get(this.selectedIndex).getObject() : null;
    }

    public String getSelectedLabel() {
        return this.selectedIndex >= 0 ? this.getComboModelObjectListFiltered().get(this.selectedIndex).getLabel() : null;
    }

    public T getObject(int i) {
        return this.getComboModelObjectListFiltered().get(i).getObject();
    }

    public String getLabel(int i) {
        return this.getComboModelObjectListFiltered().get(i).getLabel();
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public void setSelectedIndex(int selectedIndex) {
        if (selectedIndex < this.getComboModelObjectListFiltered().size()) {
            this.selectedIndex = selectedIndex;
        }
    }

    public void setSelectedObject(T object) {
        this.selectedIndex = -1;
        int i = 0;
        for (ComboModelObject<T> current : this.getComboModelObjectList()) {
            if (object.equals(current.getObject())) {
                this.selectedIndex = i;
                break;
            }
            ++i;
        }
    }

    public String[] getLabelArray() {
        LinkedList<String> labelList = new LinkedList<String>();
        for (ComboModelObject<T> object : this.getComboModelObjectListFiltered()) {
            labelList.add(object.getLabel());
        }
        return labelList.toArray(new String[labelList.size()]);
    }

    public List<ComboModelObject<T>> getComboModelObjectListFiltered() {
        if (this.filter != null) {
            return this.createFilteredList();
        }
        return this.objectList;
    }

    private List<ComboModelObject<T>> createFilteredList() {
        LinkedList<ComboModelObject<T>> filteredList = new LinkedList<ComboModelObject<T>>();
        for (ComboModelObject<T> comboModelObject : this.objectList) {
            if (!this.isVisible(comboModelObject)) continue;
            filteredList.add(comboModelObject);
        }
        return filteredList;
    }

    private boolean isVisible(ComboModelObject<T> comboModelObject) {
        boolean visible = true;
        if (comboModelObject.getObject() != null) {
            visible = this.filter.isVisible(comboModelObject.getObject());
        }
        return visible;
    }

    public List<ComboModelObject<T>> getComboModelObjectList() {
        return this.objectList;
    }

    public List<T> getObjectList() {
        LinkedList<T> list = new LinkedList<T>();
        for (ComboModelObject<T> object : this.objectList) {
            list.add(object.getObject());
        }
        return list;
    }

    public IComboModelFilter<T> getFilter() {
        return this.filter;
    }

    public void setFilter(IComboModelFilter<T> filter) {
        this.filter = filter;
    }
}

