/*
 * Decompiled with CFR 0.152.
 */
package sernet.verinice.bpm.rcp;

import java.text.DateFormat;
import java.util.Hashtable;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.osgi.service.prefs.Preferences;
import sernet.verinice.bpm.rcp.Base64Utils;
import sernet.verinice.bpm.rcp.IndividualProcessWizard;
import sernet.verinice.bpm.rcp.Messages;
import sernet.verinice.interfaces.bpm.IndividualServiceParameter;

public class TemplatePage
extends WizardPage {
    private static final Logger LOG = Logger.getLogger(TemplatePage.class);
    public static final String NAME = "TEMPLATE_PAGE";
    private Preferences preferences;
    private Preferences bpmPreferences;
    private Hashtable<String, IndividualServiceParameter> templateMap;
    private Label title;
    private Label date;
    private Label reminder;
    private Label assignee;
    private Label assigneeRelation;
    private Label releaseProcess;
    private Text description;
    private Text properties;

    protected TemplatePage() {
        super(NAME);
        this.setTitle(Messages.TemplatePage_1);
        this.setMessage(Messages.TemplatePage_2);
    }

    private void addFormElements(Composite container) {
        int descriptionGdHeightHint = 100;
        int propertyLabelHeightHint = 50;
        Label titleLabel = new Label(container, 0);
        titleLabel.setText(Messages.TemplatePage_3);
        this.title = new Label(container, 0);
        GridData gd = new GridData(4, 128, true, false);
        this.title.setLayoutData((Object)gd);
        FontData[] fD = this.title.getFont().getFontData();
        int i = 0;
        while (i < fD.length) {
            fD[i].setStyle(1);
            ++i;
        }
        Font newFont = new Font((Device)this.getShell().getDisplay(), fD);
        this.title.setFont(newFont);
        Label descriptionLabel = new Label(container, 0);
        descriptionLabel.setText(Messages.TemplatePage_4);
        int style = 16450;
        style = style | 8 | 0x200;
        this.description = new Text(container, style);
        gd = new GridData(4, 128, true, false);
        gd.heightHint = 100;
        this.description.setLayoutData((Object)gd);
        this.description.setFont(newFont);
        Label dateLabel = new Label(container, 0);
        dateLabel.setText(Messages.TemplatePage_5);
        this.date = new Label(container, 0);
        gd = new GridData(4, 128, true, false);
        this.date.setLayoutData((Object)gd);
        this.date.setFont(newFont);
        Label reminderLabel = new Label(container, 0);
        reminderLabel.setText(Messages.TemplatePage_6);
        this.reminder = new Label(container, 0);
        gd = new GridData(4, 128, true, false);
        this.reminder.setLayoutData((Object)gd);
        this.reminder.setFont(newFont);
        Label assigneeLabel = new Label(container, 0);
        assigneeLabel.setText(Messages.TemplatePage_7);
        this.assignee = new Label(container, 0);
        gd = new GridData(4, 128, true, false);
        this.assignee.setLayoutData((Object)gd);
        this.assignee.setFont(newFont);
        this.assignee.setText(Messages.TemplatePage_8);
        Label relationLabel = new Label(container, 0);
        relationLabel.setText(Messages.TemplatePage_9);
        this.assigneeRelation = new Label(container, 0);
        gd = new GridData(4, 128, true, false);
        this.assigneeRelation.setLayoutData((Object)gd);
        this.assigneeRelation.setFont(newFont);
        this.assigneeRelation.setText(Messages.TemplatePage_10);
        Label propertyLabel = new Label(container, 0);
        propertyLabel.setText(Messages.TemplatePage_11);
        int propertiesStyle = 16450;
        this.properties = new Text(container, propertiesStyle | 8 | 0x200);
        gd = new GridData(4, 128, true, false);
        gd.heightHint = 50;
        this.properties.setLayoutData((Object)gd);
        this.properties.setFont(newFont);
        Label releaseProcessLabel = new Label(container, 0);
        releaseProcessLabel.setText(Messages.DescriptionPage_12);
        this.releaseProcess = new Label(container, 0);
        gd = new GridData(4, 128, true, false);
        this.releaseProcess.setLayoutData((Object)gd);
        this.releaseProcess.setFont(newFont);
        this.releaseProcess.setText(Messages.TemplatePage_10);
    }

    public void saveTemplate(boolean overwrite) {
        MessageDialog dialog;
        IndividualServiceParameter parameter = ((IndividualProcessWizard)this.getWizard()).getParameter();
        if (this.getTemplateMap().get(parameter.getTitle()) != null && !overwrite && (dialog = new MessageDialog(this.getShell(), Messages.TemplatePage_14, null, Messages.TemplatePage_16, 3, new String[]{Messages.TemplatePage_17, Messages.TemplatePage_18}, 1)).open() == 0) {
            return;
        }
        this.doSaveTemplate();
    }

    private void doSaveTemplate() {
        try {
            IndividualServiceParameter parameter = ((IndividualProcessWizard)this.getWizard()).getParameter();
            this.getTemplateMap().put(parameter.getTitle(), parameter);
            String value = Base64Utils.encode(this.templateMap);
            this.getBpmPreferences().put("task_templates", value);
            this.getPreferences().flush();
            this.setMessage(String.valueOf(Messages.TemplatePage_13) + parameter.getTitle());
        }
        catch (Exception e) {
            LOG.error((Object)"Error while saving template", (Throwable)e);
            this.setErrorMessage(Messages.TemplatePage_15);
        }
    }

    private Hashtable<String, IndividualServiceParameter> getTemplateMap() {
        if (this.templateMap == null) {
            String value = this.getBpmPreferences().get("task_templates", null);
            this.templateMap = value != null ? (Hashtable)Base64Utils.decode(value) : new Hashtable();
        }
        return this.templateMap;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            IndividualServiceParameter parameter = ((IndividualProcessWizard)this.getWizard()).getParameter();
            String taskTitle = parameter.getTitle();
            this.title.setText(taskTitle);
            this.description.setText(parameter.getDescription());
            this.date.setText(DateFormat.getDateInstance().format(parameter.getDueDate()));
            this.reminder.setText(String.valueOf(parameter.getReminderPeriodDays()));
            if (parameter.getAssignee() != null) {
                this.assignee.setText(parameter.getAssignee());
            }
            if (parameter.getAssigneeRelationName() != null) {
                this.assigneeRelation.setText(parameter.getAssigneeRelationName());
            }
            if (parameter.getPropertyNames() != null) {
                StringBuilder sb = new StringBuilder();
                boolean first = true;
                for (String prop : parameter.getPropertyNames()) {
                    if (!first) {
                        sb.append(", ");
                    } else {
                        first = false;
                    }
                    sb.append(prop);
                }
                this.properties.setText(sb.toString());
            }
            if (parameter.isWithAReleaseProcess()) {
                this.releaseProcess.setText(Messages.TemplatePage_18);
            } else {
                this.releaseProcess.setText(Messages.TemplatePage_10);
            }
        }
    }

    public boolean isPageComplete() {
        return true;
    }

    public void createControl(Composite parent) {
        int layotMarginWidth = 10;
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 10;
        composite.setLayout((Layout)layout);
        GridData gd = new GridData(4, 4, true, true);
        composite.setLayoutData((Object)gd);
        this.addFormElements(composite);
        composite.pack();
        this.setControl((Control)composite);
        this.setPageComplete(true);
    }

    public Preferences getPreferences() {
        if (this.preferences == null) {
            this.preferences = ConfigurationScope.INSTANCE.getNode("sernet.gs.ui.rcp.main");
        }
        return this.preferences;
    }

    public Preferences getBpmPreferences() {
        if (this.bpmPreferences == null) {
            this.bpmPreferences = this.getPreferences().node("bpm");
        }
        return this.bpmPreferences;
    }
}

